/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring;

import java.util.Collection;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.CopyRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.DeleteRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.FileRenameRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.MoveRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class XMLRefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        return referenceable instanceof Referenceable;
    }

    public void doFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        assert (referenceable != null) : "The node's NamedReferenceable should not be null";
        WhereUsedQueryUI whereUsedQueryUI = new WhereUsedQueryUI(referenceable);
        UI.openRefactoringUI((RefactoringUI)whereUsedQueryUI);
    }

    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        if (referenceable instanceof Model && RefactoringUtil.isWritable((Model)referenceable)) {
            return true;
        }
        return referenceable instanceof Nameable && RefactoringUtil.isWritable(SharedUtils.getModel(referenceable));
    }

    public void doRename(Lookup lookup) {
        Model model;
        Collection collection = lookup.lookupAll(Node.class);
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Object object = null;
        if (referenceable instanceof Model) {
            model = (Model)referenceable;
            object = new FileRenameRefactoringUI(model);
        } else if (referenceable instanceof Nameable) {
            object = new RenameRefactoringUI((Nameable)Nameable.class.cast(referenceable));
        }
        if (this.isFromEditor(editorCookie)) {
            model = TopComponent.getRegistry().getActivated();
            UI.openRefactoringUI((RefactoringUI)object, (TopComponent)model);
        } else {
            UI.openRefactoringUI((RefactoringUI)object);
        }
    }

    public boolean canDelete(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        if (referenceable instanceof Component && ((Component)referenceable).getParent() == null) {
            return false;
        }
        return referenceable instanceof NamedReferenceable && RefactoringUtil.isWritable(SharedUtils.getModel(referenceable)) && nodeArray[0].canDestroy();
    }

    public void doDelete(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        DeleteRefactoringUI deleteRefactoringUI = new DeleteRefactoringUI((NamedReferenceable)NamedReferenceable.class.cast(referenceable));
        if (this.isFromEditor(editorCookie)) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            UI.openRefactoringUI((RefactoringUI)deleteRefactoringUI, (TopComponent)topComponent);
        } else {
            UI.openRefactoringUI((RefactoringUI)deleteRefactoringUI);
        }
    }

    private boolean isFromEditor(EditorCookie editorCookie) {
        TopComponent topComponent;
        return editorCookie != null && editorCookie.getOpenedPanes() != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public boolean canMove(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node[] nodeArray = collection.toArray(new Node[0]);
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject == null || !dataObject.isValid()) {
            return false;
        }
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        if (referenceable == null) {
            return false;
        }
        return referenceable instanceof Model && RefactoringUtil.isWritable((Model)referenceable);
    }

    public void doMove(Lookup lookup) {
        Model model;
        Collection collection = lookup.lookupAll(Node.class);
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        MoveRefactoringUI moveRefactoringUI = null;
        if (referenceable instanceof Model) {
            model = (Model)referenceable;
            moveRefactoringUI = new MoveRefactoringUI(model);
        }
        if (this.isFromEditor(editorCookie)) {
            model = TopComponent.getRegistry().getActivated();
            UI.openRefactoringUI((RefactoringUI)moveRefactoringUI, (TopComponent)model);
        } else {
            UI.openRefactoringUI(moveRefactoringUI);
        }
    }

    public boolean canCopy(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        if (referenceable == null) {
            return false;
        }
        return referenceable instanceof Model && RefactoringUtil.isWritable((Model)referenceable);
    }

    public void doCopy(Lookup lookup) {
        Model model;
        Collection collection = lookup.lookupAll(Node.class);
        Node[] nodeArray = collection.toArray(new Node[0]);
        Referenceable referenceable = SharedUtils.getReferenceable(nodeArray);
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        CopyRefactoringUI copyRefactoringUI = null;
        if (referenceable instanceof Model) {
            model = (Model)referenceable;
            copyRefactoringUI = new CopyRefactoringUI(model);
        }
        if (this.isFromEditor(editorCookie)) {
            model = TopComponent.getRegistry().getActivated();
            UI.openRefactoringUI((RefactoringUI)copyRefactoringUI, (TopComponent)model);
        } else {
            UI.openRefactoringUI(copyRefactoringUI);
        }
    }
}

