/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.model;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.sun.manager.jbi.actions.MBeanOperationAction;
import org.netbeans.modules.sun.manager.jbi.actions.MBeanOperationGroupAction;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIComponentActionDescriptor {
    private static final String ACTION_NAMESPACE = "http://sun.com/jbi/components/ActionableMBeans";
    private static final String ACTION = "Action";
    private static final String DISPLAY_NAME = "DisplayName";
    private static final String DESCRIPTION = "Description";
    private static final String MBEAN_KEY = "MBeanKey";
    private static final String OPERATION_NAME = "OperationName";
    private static final String ENABLED = "Enabled";
    private static final String IS_GROUP = "isGroup";
    private String mBeanKey;
    private String displayName;
    private String description;
    private String operationName;
    private boolean enabled;
    private boolean isGroup;
    private List<JBIComponentActionDescriptor> children;

    private JBIComponentActionDescriptor(String string, String string2) {
        this.displayName = string;
        this.description = string2;
        this.isGroup = true;
    }

    private JBIComponentActionDescriptor(String string, String string2, String string3, String string4, boolean bl) {
        this.displayName = string;
        this.description = string2;
        this.mBeanKey = string3;
        this.operationName = string4;
        this.enabled = bl;
        this.isGroup = false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMBeanKey() {
        return this.mBeanKey;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return Utils.getTooltip(this.description);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void addChild(JBIComponentActionDescriptor jBIComponentActionDescriptor) {
        if (this.children == null) {
            this.children = new LinkedList<JBIComponentActionDescriptor>();
        }
        this.children.add(jBIComponentActionDescriptor);
    }

    public List<JBIComponentActionDescriptor> getChildren() {
        return this.children;
    }

    public static List<MBeanOperationAction> getActions(String string) {
        JBIComponentActionDescriptor jBIComponentActionDescriptor = null;
        try {
            jBIComponentActionDescriptor = JBIComponentActionDescriptor.parse(string);
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        MBeanOperationGroupAction mBeanOperationGroupAction = (MBeanOperationGroupAction)JBIComponentActionDescriptor.getAction(jBIComponentActionDescriptor);
        return mBeanOperationGroupAction.getActions();
    }

    private static MBeanOperationAction getAction(JBIComponentActionDescriptor jBIComponentActionDescriptor) {
        MBeanOperationAction mBeanOperationAction = null;
        if (jBIComponentActionDescriptor != null) {
            String string = jBIComponentActionDescriptor.getDisplayName();
            String string2 = jBIComponentActionDescriptor.getDescription();
            if (jBIComponentActionDescriptor.isGroup()) {
                MBeanOperationGroupAction mBeanOperationGroupAction = new MBeanOperationGroupAction(string, string2);
                for (JBIComponentActionDescriptor jBIComponentActionDescriptor2 : jBIComponentActionDescriptor.getChildren()) {
                    MBeanOperationAction mBeanOperationAction2 = JBIComponentActionDescriptor.getAction(jBIComponentActionDescriptor2);
                    mBeanOperationGroupAction.addAction(mBeanOperationAction2);
                }
                mBeanOperationAction = mBeanOperationGroupAction;
            } else {
                String string3 = jBIComponentActionDescriptor.getMBeanKey();
                String string4 = jBIComponentActionDescriptor.getOperationName();
                boolean bl = jBIComponentActionDescriptor.isEnabled();
                mBeanOperationAction = new MBeanOperationAction(string3, string4, string, string2, bl);
            }
        }
        return mBeanOperationAction;
    }

    private static JBIComponentActionDescriptor parse(String string) throws ParserConfigurationException, IOException, SAXException {
        if (string == null) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        JBIComponentActionDescriptor jBIComponentActionDescriptor = new JBIComponentActionDescriptor("", "");
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getNamespaceURI().equals(ACTION_NAMESPACE) || !((Element)node).getLocalName().equals(ACTION)) continue;
            jBIComponentActionDescriptor.addChild(JBIComponentActionDescriptor.parseActionElement((Element)node));
        }
        return jBIComponentActionDescriptor;
    }

    private static JBIComponentActionDescriptor parseActionElement(Element element) {
        JBIComponentActionDescriptor jBIComponentActionDescriptor;
        String string = element.getElementsByTagNameNS(ACTION_NAMESPACE, DISPLAY_NAME).item(0).getTextContent();
        String string2 = element.getElementsByTagNameNS(ACTION_NAMESPACE, DESCRIPTION).item(0).getTextContent();
        String string3 = element.getAttribute(IS_GROUP);
        if (string3 != null && string3.length() > 0 && Boolean.parseBoolean(string3)) {
            jBIComponentActionDescriptor = new JBIComponentActionDescriptor(string, string2);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !((Element)node).getNamespaceURI().equals(ACTION_NAMESPACE) || !((Element)node).getLocalName().equals(ACTION)) continue;
                jBIComponentActionDescriptor.addChild(JBIComponentActionDescriptor.parseActionElement((Element)node));
            }
        } else {
            String string4 = element.getElementsByTagNameNS(ACTION_NAMESPACE, MBEAN_KEY).item(0).getTextContent();
            String string5 = element.getElementsByTagNameNS(ACTION_NAMESPACE, OPERATION_NAME).item(0).getTextContent();
            boolean bl = false;
            Element element2 = (Element)element.getElementsByTagNameNS(ACTION_NAMESPACE, ENABLED).item(0);
            if (element2 != null) {
                bl = Boolean.parseBoolean(element2.getTextContent());
            }
            jBIComponentActionDescriptor = new JBIComponentActionDescriptor(string, string2, string4, string5, bl);
        }
        return jBIComponentActionDescriptor;
    }
}

