/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.explorer;

import com.sun.rave.designtime.BeanCreateInfoSet;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.Result;
import com.sun.sql.rowset.CachedRowSetXImpl;
import java.awt.Image;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.dataconnectivity.DataconnectivitySettings;
import org.netbeans.modules.visualweb.dataconnectivity.Log;
import org.netbeans.modules.visualweb.dataconnectivity.customizers.RowSetSelection;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;

public class RowSetBeanCreateInfoSet
implements BeanCreateInfoSet {
    DataSourceInfo dsInfo;
    String tableName;
    String bareTableName;
    String rowSetInstanceName;
    DatabaseMetaData metaData;
    protected String rowSetNameSuffix = DataconnectivitySettings.getRsSuffix();
    public static Class rowSetClass = CachedRowSetXImpl.class;
    protected static String dataProviderProperty = "cachedRowSet";
    protected static String dataProviderClassName = "com.sun.data.provider.impl.CachedRowSetDataProvider";
    String dsName = null;
    String command = null;
    DesignBean rsBean = null;
    private static final String SCOPE_PAGE = "page";
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_APPLICATION = "application";

    public RowSetBeanCreateInfoSet(String string, DatabaseMetaData databaseMetaData) {
        this.tableName = string;
        int n = string.lastIndexOf(46);
        this.bareTableName = n >= 0 ? string.substring(n + 1) : string;
        this.metaData = databaseMetaData;
        Log.log("RowSetPaletteItem =" + string + "," + this.bareTableName);
    }

    public String getDisplayName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Image getLargeIcon() {
        return null;
    }

    public Image getSmallIcon() {
        return null;
    }

    public String getHelpKey() {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDataSourceInfo(DataSourceInfo dataSourceInfo) {
        this.dsInfo = dataSourceInfo;
        try {
            this.rowSetInstanceName = this.dsInfo.getDatabaseMetaDataHelper().getNoSchemaName(this.tableName).toLowerCase() + this.rowSetNameSuffix;
        }
        catch (SQLException sQLException) {
            this.rowSetInstanceName = this.bareTableName.toLowerCase() + this.rowSetNameSuffix;
        }
        this.rowSetInstanceName = this.rowSetInstanceName.replaceAll(" ", "");
    }

    public DataSourceInfo getDataSourceInfo(DataSourceInfo dataSourceInfo) {
        return this.dsInfo;
    }

    private String getDataSourceName() {
        if (this.dsName == null) {
            this.dsName = "java:comp/env/jdbc/" + this.dsInfo.getName();
        }
        return this.dsName;
    }

    private String getCommand() {
        if (this.command == null) {
            this.command = DesignTimeDataSource.composeSelect(this.tableName, this.metaData);
        }
        return this.command;
    }

    public String[] getBeanClassNames() {
        return new String[]{dataProviderClassName};
    }

    public Result beansCreatedSetup(DesignBean[] designBeanArray) {
        String string;
        this.rsBean = null;
        DesignBean designBean = null;
        if (designBeanArray.length > 0) {
            designBean = designBeanArray[0];
        }
        if (designBean == null || !dataProviderClassName.equals(designBean.getInstance().getClass().getName())) {
            String string2 = designBean == null ? "none provided" : designBean.getInstance().getClass().getName();
            String string3 = "Unknown dataProvider bean given to SingleTableNode: " + string2;
            RuntimeException runtimeException = new RuntimeException(string3);
            Log.err.notify(65536, (Throwable)runtimeException);
            throw runtimeException;
        }
        DesignContext designContext = designBean.getDesignContext();
        String string4 = (String)designContext.getContextData("scope");
        if (Log.isLoggable()) {
            Log.log("RSPI: dpBeanScope='" + string4 + "' for " + designContext.getDisplayName());
            Log.log("RSPI: canDropAnywhere=" + DataconnectivitySettings.canDropAnywhere());
        }
        RowSetSelection rowSetSelection = new RowSetSelection(designContext, this.tableName, this.getDataSourceName(), "", "", this.getCommand());
        DesignContext designContext2 = null;
        if (!rowSetSelection.hasMatchingRowSets()) {
            string = this.getScopeForNewRowSet(string4, designContext);
            if (!string.equals(string4)) {
                while (string != null) {
                    Object[] objectArray = rowSetSelection.getCreateBeans(string);
                    if (objectArray.length >= 1) {
                        String string5 = string.substring(0, 1).toUpperCase() + string.substring(1) + "Bean1";
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!((DesignContext)objectArray[i]).getDisplayName().equals(string5)) continue;
                            designContext2 = (DesignContext)objectArray[i];
                            break;
                        }
                        if (designContext2 != null) break;
                        designContext2 = (DesignContext)objectArray[0];
                        break;
                    }
                    string = RowSetBeanCreateInfoSet.getNextScope(string);
                }
            }
            if (designContext2 == null) {
                designContext2 = designContext;
            }
        } else {
            boolean bl = rowSetSelection.showDialog();
            DesignBean designBean2 = designBean;
            if (!bl) {
                final DesignBean designBean3 = designBean;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DesignContext designContext = designBean3.getDesignContext();
                        designContext.deleteBean(designBean3);
                    }
                });
                return Result.FAILURE;
            }
            designContext2 = rowSetSelection.getSelectedDesignContext();
            this.rsBean = rowSetSelection.getSelectedRowSetBean();
            if (this.rsBean == null) {
                this.rowSetInstanceName = rowSetSelection.getSelectedRowSetName();
            }
        }
        if (this.rsBean == null) {
            this.rsBean = designContext2.createBean(rowSetClass.getName(), null, null);
            this.setRowSetProperties(this.rsBean, this.rowSetInstanceName);
            string = this.rsBean.getDesignInfo();
            if (string != null) {
                string.beanCreatedSetup(this.rsBean);
            }
            if (Log.isLoggable()) {
                Log.log("RSPI:  created rowset " + this.rowSetInstanceName + " in " + designContext2.getDisplayName());
            }
        }
        if ((string = this.rowSetInstanceName.replaceAll(this.rowSetNameSuffix, DataconnectivitySettings.getDpSuffix())).indexOf(DataconnectivitySettings.getDpSuffix()) < 0) {
            string = string + DataconnectivitySettings.getDpSuffix();
        }
        designBean.setInstanceName(string, true);
        Log.log("RSPI:  setting prop " + dataProviderProperty);
        designBean.getProperty(dataProviderProperty).setValue(this.rsBean.getInstance());
        return Result.SUCCESS;
    }

    private DesignBean setRowSetProperties(DesignBean designBean, String string) {
        String string2;
        if (string != null && string.length() > 0) {
            designBean.setInstanceName(string, true);
        }
        if ((string2 = (String)designBean.getProperty("dataSourceName").getValue()) == null || string2.length() < 1) {
            designBean.getProperty("dataSourceName").setValue((Object)this.getDataSourceName());
        }
        if ((string2 = (String)designBean.getProperty("command").getValue()) == null || string2.length() < 1) {
            designBean.getProperty("command").setValue((Object)this.getCommand());
        }
        if (rowSetClass == CachedRowSetXImpl.class && ((string2 = (String)designBean.getProperty("tableName").getValue()) == null || string2.length() < 1)) {
            designBean.getProperty("tableName").setValue((Object)this.bareTableName);
        }
        return designBean;
    }

    private static boolean isRequestBean(DesignContext designContext) {
        return SCOPE_REQUEST.equals(designContext.getContextData("scope")) && designContext.getDisplayName().indexOf("RequestBean") >= 0;
    }

    private static String getNextScope(String string) {
        if (string.equals(SCOPE_PAGE)) {
            return SCOPE_REQUEST;
        }
        if (string.equals(SCOPE_REQUEST)) {
            return SCOPE_SESSION;
        }
        if (string.equals(SCOPE_SESSION)) {
            return SCOPE_APPLICATION;
        }
        return null;
    }

    private String getScopeForNewRowSet(String string, DesignContext designContext) {
        if (DataconnectivitySettings.canDropAnywhere()) {
            return string;
        }
        if (string.equals(SCOPE_PAGE)) {
            return SCOPE_SESSION;
        }
        if (string.equals(SCOPE_REQUEST)) {
            if (RowSetBeanCreateInfoSet.isRequestBean(designContext)) {
                return SCOPE_REQUEST;
            }
            return SCOPE_SESSION;
        }
        if (string.equals(SCOPE_SESSION)) {
            return SCOPE_SESSION;
        }
        if (string.equals(SCOPE_APPLICATION)) {
            return SCOPE_APPLICATION;
        }
        return SCOPE_SESSION;
    }
}

