/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.customizers;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.visualweb.dataconnectivity.Log;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.model.DatasourceConnectionListener;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DatabaseMetaDataHelper;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSourceHelper;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualSQLEditorMetaDataImpl
implements VisualSQLEditorMetaData {
    private int hashSizeForTables = 30;
    private DataSourceInfo dataSourceInfo = null;
    private DatabaseMetaData databaseMetaData = null;
    private DatabaseMetaDataHelper dbmdh = null;
    private static Hashtable dataSourceCache = new Hashtable();
    static final String contextSuffix = "java:comp/env/jdbc/";
    private DatasourceConnectionListener listener = new DatasourceConnectionListener(){

        public void dataSourceConnectionModified() {
            VisualSQLEditorMetaDataImpl.logInfo(VisualSQLEditorMetaDataImpl.this.dataSourceInfo.getName() + " connectionModified event.");
            VisualSQLEditorMetaDataImpl.this.refresh();
        }
    };
    private List<List<String>> allTables = null;
    public Hashtable pkTable = new Hashtable(this.hashSizeForTables);
    public Hashtable fkExportedTable = new Hashtable(this.hashSizeForTables);
    public Hashtable fkImportedTable = new Hashtable(this.hashSizeForTables);
    private Hashtable columnNameTable = new Hashtable(this.hashSizeForTables);
    private Hashtable allColumnsTable = new Hashtable(400);
    private boolean allColumnsTableLoaded = false;
    String identifierQuoteString = null;
    private static final String LOGPREFIX = "DBCache: ";
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.dataconnectivity.customizers");

    public static synchronized VisualSQLEditorMetaData getDataSourceCache(String string) throws SQLException, NamingException {
        if (string == null) {
            throw new NamingException(NbBundle.getMessage(VisualSQLEditorMetaDataImpl.class, (String)"NAME_REMOVED") + " " + string);
        }
        VisualSQLEditorMetaData visualSQLEditorMetaData = (VisualSQLEditorMetaData)dataSourceCache.get(string);
        if (visualSQLEditorMetaData == null) {
            VisualSQLEditorMetaDataImpl.logInfo("Creating cache for " + string);
            visualSQLEditorMetaData = new VisualSQLEditorMetaDataImpl(string);
            dataSourceCache.put(string, visualSQLEditorMetaData);
        }
        return visualSQLEditorMetaData;
    }

    public static synchronized boolean hasDataSourceCache(String string) {
        VisualSQLEditorMetaData visualSQLEditorMetaData = (VisualSQLEditorMetaData)dataSourceCache.get(string);
        return visualSQLEditorMetaData != null;
    }

    public static synchronized void removeDataSourceCache(String string) throws SQLException {
        VisualSQLEditorMetaDataImpl visualSQLEditorMetaDataImpl = (VisualSQLEditorMetaDataImpl)dataSourceCache.get(string);
        if (visualSQLEditorMetaDataImpl != null) {
            visualSQLEditorMetaDataImpl.refresh();
            dataSourceCache.remove(string);
            VisualSQLEditorMetaDataImpl.logInfo("Removed cache for " + string);
        }
    }

    public VisualSQLEditorMetaDataImpl(String string) throws SQLException {
        try {
            if (string.startsWith(contextSuffix)) {
                string = string.substring(contextSuffix.length());
            }
            this.dataSourceInfo = DesignTimeDataSourceHelper.getDsInfo(string);
            this.dataSourceInfo.addConnectionListener(this.listener);
            this.initMetaData();
        }
        catch (SQLException sQLException) {
            Log.log("Could not create cache for " + sQLException.getLocalizedMessage());
            throw sQLException;
        }
    }

    public void initMetaData() throws SQLException {
        this.dbmdh = this.dataSourceInfo.getDatabaseMetaDataHelper();
        this.databaseMetaData = this.dbmdh.getMetaData();
        this.refreshCacheTables();
    }

    public void refresh() {
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " nulling cache.");
        this.dbmdh = null;
        this.databaseMetaData = null;
        this.refreshCacheTables();
    }

    public void refreshCacheTables() {
        this.columnNameTable.clear();
        this.fkExportedTable.clear();
        this.fkImportedTable.clear();
        this.allTables = null;
        this.allColumnsTable.clear();
        this.allColumnsTableLoaded = false;
        this.pkTable.clear();
        this.identifierQuoteString = null;
    }

    public List<String> getSchemas() {
        List<String> list = Arrays.asList(this.dataSourceInfo.getDataSource().getSchemas());
        return list;
    }

    public List<List<String>> getTables() throws SQLException {
        if (this.dbmdh == null) {
            this.initMetaData();
        }
        if (this.allTables != null) {
            return this.allTables;
        }
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " loading tables");
        this.allTables = new ArrayList<List<String>>();
        String[] stringArray = this.dataSourceInfo.getSchemas();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                VisualSQLEditorMetaDataImpl.logInfo("  schema " + stringArray[i]);
                String[] stringArray2 = this.dbmdh.getTables(stringArray[i]);
                for (int j = 0; j < stringArray2.length; ++j) {
                    this.allTables.add(Arrays.asList(VisualSQLEditorMetaDataImpl.parseTableName(stringArray2[j])));
                }
                String[] stringArray3 = this.dbmdh.getViews(stringArray[i]);
                for (int j = 0; j < stringArray3.length; ++j) {
                    this.allTables.add(Arrays.asList(VisualSQLEditorMetaDataImpl.parseTableName(stringArray3[j])));
                }
            }
        } else {
            VisualSQLEditorMetaDataImpl.logInfo("   all schemas");
            String[] stringArray4 = this.dbmdh.getTables();
            for (int i = 0; i < stringArray4.length; ++i) {
                this.allTables.add(Arrays.asList(VisualSQLEditorMetaDataImpl.parseTableName(stringArray4[i])));
            }
            String[] stringArray5 = this.dbmdh.getViews();
            for (int i = 0; i < stringArray5.length; ++i) {
                this.allTables.add(Arrays.asList(VisualSQLEditorMetaDataImpl.parseTableName(stringArray5[i])));
            }
        }
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " tables loaded " + this.allTables.size());
        return this.allTables;
    }

    public List<String> getPrimaryKeys(String string, String string2) throws SQLException {
        String string3;
        ArrayList<String> arrayList;
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " getPrimaryKeys " + string + "." + string2);
        if (this.dbmdh == null) {
            this.initMetaData();
        }
        if ((arrayList = (ArrayList<String>)this.pkTable.get(string3 = VisualSQLEditorMetaDataImpl.mergeTableName(string, string2))) != null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        String[] stringArray = VisualSQLEditorMetaDataImpl.parseTableName(string3);
        ResultSet resultSet = this.databaseMetaData.getPrimaryKeys(null, string, string2);
        if (resultSet != null) {
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_NAME");
                arrayList.add(string4);
            }
            resultSet.close();
        }
        this.pkTable.put(string3, arrayList);
        return arrayList;
    }

    public List<List<String>> getImportedKeys(String string, String string2) throws SQLException {
        return this.getForeignKeys(string, string2, false);
    }

    public List<List<String>> getExportedKeys(String string, String string2) throws SQLException {
        return this.getForeignKeys(string, string2, true);
    }

    private List<List<String>> getForeignKeys(String string, String string2, boolean bl) throws SQLException {
        ResultSet resultSet;
        String string3;
        Hashtable hashtable;
        ArrayList<List<String>> arrayList;
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " getForeign " + string + " " + string2);
        if (this.dbmdh == null) {
            this.initMetaData();
        }
        if ((arrayList = (ArrayList<List<String>>)(hashtable = bl ? this.fkExportedTable : this.fkImportedTable).get(string3 = VisualSQLEditorMetaDataImpl.mergeTableName(string, string2))) != null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<String>>();
        ResultSet resultSet2 = resultSet = bl ? this.databaseMetaData.getExportedKeys(null, string, string2) : this.databaseMetaData.getImportedKeys(null, string, string2);
        if (resultSet != null) {
            while (resultSet.next()) {
                String string4 = resultSet.getString("FKTABLE_SCHEM");
                String string5 = resultSet.getString("PKTABLE_SCHEM");
                List<String> list = Arrays.asList((string4 != null ? string4 + "." : "") + resultSet.getString("FKTABLE_NAME"), resultSet.getString("FKCOLUMN_NAME"), (string5 != null ? string5 + "." : "") + resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"));
                arrayList.add(list);
            }
            resultSet.close();
        }
        hashtable.put(string3, arrayList);
        return arrayList;
    }

    public List<String> getColumns(String string, String string2) throws SQLException {
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " getColumnsNames " + string + " " + string2);
        if (this.dbmdh == null) {
            this.initMetaData();
        }
        String string3 = VisualSQLEditorMetaDataImpl.mergeTableName(string, string2);
        ArrayList<String> arrayList = (ArrayList<String>)this.columnNameTable.get(string3);
        VisualSQLEditorMetaDataImpl.logInfo("    cache hit=" + (arrayList != null));
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        ResultSet resultSet = this.databaseMetaData.getColumns(null, string, string2, "%");
        if (resultSet != null) {
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet.close();
            if (Log.isLoggable()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Log.log("     Column:" + (String)arrayList.get(i));
                }
            }
        }
        VisualSQLEditorMetaDataImpl.logInfo("   getColumnNames loaded  " + arrayList.size());
        this.columnNameTable.put(string3, arrayList);
        return arrayList;
    }

    public String getIdentifierQuoteString() throws SQLException {
        VisualSQLEditorMetaDataImpl.logInfo(this.dataSourceInfo.getName() + " getIdentifierQuoteString ");
        if (this.dbmdh == null) {
            this.initMetaData();
        }
        if (this.identifierQuoteString != null) {
            return this.identifierQuoteString;
        }
        this.identifierQuoteString = this.databaseMetaData.getIdentifierQuoteString();
        return this.identifierQuoteString;
    }

    private static String[] parseTableName(String string) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length > 1) {
            stringArray[0] = stringArray2[0];
            stringArray[1] = stringArray2[1];
        } else {
            stringArray[0] = null;
            stringArray[1] = stringArray2[0];
        }
        return stringArray;
    }

    private static String mergeTableName(String string, String string2) {
        return string == null || string.equals("") ? string2 : string + "." + string2;
    }

    private static void logInfo(String string) {
        err.log(1, LOGPREFIX + string);
    }

    private boolean isLoggable() {
        return err.isLoggable(1);
    }

    private boolean isLoggable(int n) {
        return err.isLoggable(n);
    }

    private void log(int n, String string) {
        err.log(n, string);
    }

    private static void logErrorInfo(String string) {
        err.log(65536, LOGPREFIX + string);
    }
}

