/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.spi.AntEvent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.ant.debugger.AntDebuggerEngineProvider;
import org.netbeans.modules.ant.debugger.CallStackModel;
import org.netbeans.modules.ant.debugger.IOManager;
import org.netbeans.modules.ant.debugger.Task;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.modules.ant.debugger.VariablesModel;
import org.netbeans.modules.ant.debugger.WatchesModel;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.modules.ant.debugger.breakpoints.BreakpointModel;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;
import org.w3c.dom.Element;

public class AntDebugger
extends ActionsProviderSupport {
    private static RequestProcessor actionsRequestProcessor;
    private AntProjectCookie antCookie;
    private AntDebuggerEngineProvider engineProvider;
    private ContextProvider contextProvider;
    private ExecutorTask execTask;
    private Object LOCK = new Object();
    private Object LOCK_ACTIONS = new Object();
    private boolean actionRunning = false;
    private IOManager ioManager;
    private Object currentLine;
    private LinkedList callStackList = new LinkedList();
    private File currentFile;
    private String currentTargetName;
    private String currentTaskName;
    private int originatingIndex = -1;
    private VariablesModel variablesModel;
    private WatchesModel watchesModel;
    private BreakpointModel breakpointModel;
    private static final Set actions;
    private AntEvent lastEvent;
    private Map watches = new HashMap();
    private Object lastAction;
    private String targetEndToStopAt = null;
    private String taskEndToStopAt = null;
    private File fileToStopAt = null;
    private boolean doStop = true;
    private CallStackModel callStackModel;
    private Map nameToTargetByFiles = new HashMap();
    private Map projectNamesByFiles = new HashMap();
    private String[] variables = new String[0];

    public AntDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.antCookie = (AntProjectCookie)contextProvider.lookupFirst(null, AntProjectCookie.class);
        this.engineProvider = (AntDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            this.setEnabled(iterator.next(), true);
        }
        this.ioManager = new IOManager(this.antCookie.getFile().getName());
    }

    void setExecutor(ExecutorTask executorTask) {
        this.execTask = executorTask;
        if (executorTask != null) {
            executorTask.addTaskListener(new TaskListener(){

                public void taskFinished(org.openide.util.Task task) {
                    AntDebugger.this.finish();
                }
            });
        }
    }

    public Set getActions() {
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object object) {
        Object object2 = this.LOCK_ACTIONS;
        synchronized (object2) {
            this.actionRunning = true;
        }
        if (object == ActionsManager.ACTION_KILL) {
            this.finish();
        } else if (object == ActionsManager.ACTION_CONTINUE) {
            this.doContinue();
        } else {
            if (object == ActionsManager.ACTION_START) {
                return;
            }
            if (object == ActionsManager.ACTION_STEP_INTO || object == ActionsManager.ACTION_STEP_OUT || object == ActionsManager.ACTION_STEP_OVER) {
                this.doStep(object);
            }
        }
        object2 = this.LOCK_ACTIONS;
        synchronized (object2) {
            if (this.actionRunning) {
                try {
                    this.LOCK_ACTIONS.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(final Object object, final Runnable runnable) {
        Object object2 = actions.iterator();
        while (object2.hasNext()) {
            this.setEnabled(object2.next(), false);
        }
        object2 = AntDebugger.class;
        synchronized (AntDebugger.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("Ant debugger actions RP", 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            actionsRequestProcessor.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AntDebugger.this.doAction(object);
                    }
                    finally {
                        runnable.run();
                        Iterator iterator = actions.iterator();
                        while (iterator.hasNext()) {
                            AntDebugger.this.setEnabled(iterator.next(), true);
                        }
                    }
                }
            });
            return;
        }
    }

    void taskStarted(AntEvent antEvent) {
        Object object = Utils.getLine(antEvent);
        this.callStackList.addFirst(new Task(antEvent.getTaskStructure(), object, antEvent.getScriptLocation()));
        this.currentTaskName = antEvent.getTaskStructure().getName();
        this.originatingIndex = 0;
        this.elementStarted(antEvent);
    }

    private void elementStarted(AntEvent antEvent) {
        if (!this.doStop && !this.onBreakpoint()) {
            return;
        }
        this.stopHere(antEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHere(AntEvent antEvent) {
        Object object = this;
        synchronized (object) {
            this.lastEvent = antEvent;
        }
        this.updateUI();
        this.currentFile = antEvent.getScriptLocation();
        object = antEvent.getPropertyNames();
        this.variables = object.toArray(new String[object.size()]);
        this.fireVariables();
        this.fireWatches();
        this.fireBreakpoints();
        Object object2 = this.LOCK_ACTIONS;
        synchronized (object2) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
        object2 = this.LOCK;
        synchronized (object2) {
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        object2 = this;
        synchronized (object2) {
            this.lastEvent = null;
        }
    }

    void taskFinished(AntEvent antEvent) {
        this.callStackList.remove(0);
        if (this.taskEndToStopAt != null && this.taskEndToStopAt.equals(antEvent.getTaskStructure().getName()) && antEvent.getScriptLocation().equals(this.fileToStopAt)) {
            if (this.targetEndToStopAt != null) {
                if (this.targetEndToStopAt.equals(antEvent.getTargetName())) {
                    this.targetEndToStopAt = null;
                    this.taskEndToStopAt = null;
                    this.fileToStopAt = null;
                    this.doStop = true;
                }
            } else {
                this.taskEndToStopAt = null;
                this.fileToStopAt = null;
                this.doStop = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished(AntEvent antEvent) {
        this.engineProvider.getDestructor().killEngine();
        this.ioManager.closeStream();
        Utils.unmarkCurrent();
        Object object = this.LOCK_ACTIONS;
        synchronized (object) {
            this.actionRunning = false;
            this.LOCK_ACTIONS.notifyAll();
        }
    }

    void targetStarted(AntEvent antEvent) {
        Object object;
        List list;
        TargetLister.Target target;
        String string;
        block6: {
            block4: {
                String string2;
                block8: {
                    block7: {
                        block5: {
                            string = antEvent.getTargetName();
                            target = this.findTarget(string, antEvent.getScriptLocation());
                            list = null;
                            if (this.callStackList.size() <= 0) break block4;
                            object = this.callStackList.get(0);
                            if (!(object instanceof Task)) break block5;
                            Task task = (Task)object;
                            String string3 = task.getTaskStructure().getAttribute("target");
                            if (string3 == null || string.equals(string3)) break block6;
                            list = this.findPath(antEvent.getScriptLocation(), string3, string);
                            break block6;
                        }
                        if (!(object instanceof TargetLister.Target)) break block7;
                        String string4 = ((TargetLister.Target)object).getName();
                        LinkedList linkedList = this.findPath(antEvent.getScriptLocation(), string4, string);
                        if (linkedList == null) break block6;
                        this.callStackList.removeFirst();
                        list = linkedList;
                        break block6;
                    }
                    if (!(object instanceof TargetOriginating)) break block6;
                    string2 = ((TargetOriginating)object).getOriginatingTarget().getName();
                    if (!string2.equals(string)) break block8;
                    this.callStackList.removeFirst();
                    --this.originatingIndex;
                    break block6;
                }
                LinkedList linkedList = this.findPath(antEvent.getScriptLocation(), string2, string);
                if (linkedList == null) break block6;
                this.callStackList.removeFirst();
                list = linkedList;
                break block6;
            }
            object = antEvent.getSession().getOriginatingTargets();
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                LinkedList linkedList;
                String string5 = object[i];
                if (string5.equals(string) || (linkedList = this.findPath(antEvent.getScriptLocation(), string5, string)) == null) continue;
                list = linkedList;
                break;
            }
        }
        if (list != null) {
            this.originatingIndex = list.size();
            this.callStackList.addAll(0, list);
        } else {
            this.originatingIndex = 0;
        }
        Object object2 = object = this.callStackList.size() > 0 ? (Object)this.callStackList.getFirst() : null;
        if (object instanceof TargetOriginating && ((TargetOriginating)object).getOriginatingTarget().getName().equals(string)) {
            this.callStackList.removeFirst();
            --this.originatingIndex;
        }
        this.callStackList.addFirst(target);
        this.currentTargetName = string;
        this.currentTaskName = null;
        this.elementStarted(antEvent);
    }

    void targetFinished(AntEvent antEvent) {
        this.callStackList.remove(0);
        if (this.targetEndToStopAt != null && this.targetEndToStopAt.equals(antEvent.getTargetName()) && this.fileToStopAt.equals(antEvent.getScriptLocation())) {
            this.targetEndToStopAt = null;
            this.taskEndToStopAt = null;
            this.fileToStopAt = null;
            this.doStop = true;
        }
        this.currentTargetName = null;
    }

    private Object getTopFrame() {
        Object object = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (object instanceof TargetOriginating) {
            object = ((TargetOriginating)object).getOriginatingTarget();
        }
        return object;
    }

    private void updateUI() {
        String string = null;
        Object object = this.originatingIndex > 0 ? this.callStackList.get(this.originatingIndex) : this.callStackList.get(0);
        if (object instanceof TargetOriginating) {
            TargetLister.Target target = ((TargetOriginating)object).getDependentTarget();
            string = target.getName();
            object = ((TargetOriginating)object).getOriginatingTarget();
        }
        this.currentLine = object instanceof Task ? ((Task)object).getLine() : Utils.getLine((TargetLister.Target)object, string);
        this.updateOutputWindow(this.currentLine);
        Utils.markCurrent(this.currentLine);
        this.getCallStackModel().fireChanges();
    }

    private void updateOutputWindow(Object object) {
        Object object2 = this.getTopFrame();
        if (object2 instanceof Task) {
            Task task = (Task)object2;
            this.ioManager.println(task.getFile().getName() + ":" + (Utils.getLineNumber(object) + 1) + ": Task " + this.getStackAsString(), object);
        } else {
            TargetLister.Target target = (TargetLister.Target)object2;
            this.ioManager.println(target.getScript().getFile().getName() + ":" + (Utils.getLineNumber(object) + 1) + ": Target " + this.getStackAsString(), object);
        }
    }

    private String getStackAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.callStackList.size() - 1;
        stringBuffer.append(AntDebugger.getFrameName(this.callStackList.get(n--)));
        int n2 = Math.max(0, this.originatingIndex);
        while (n >= n2) {
            stringBuffer.append('.').append(AntDebugger.getFrameName(this.callStackList.get(n--)));
        }
        return new String(stringBuffer);
    }

    private static String getFrameName(Object object) {
        if (object instanceof TargetOriginating) {
            object = ((TargetOriginating)object).getOriginatingTarget();
        }
        return object instanceof Task ? ((Task)object).getTaskStructure().getName() : ((TargetLister.Target)object).getName();
    }

    private boolean onBreakpoint() {
        Object object;
        Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
        int n = watchArray.length;
        for (int i = 0; i < n; ++i) {
            object = this.getVariableValue(watchArray[i].getExpression());
            if (object == null) {
                object = new Integer(0);
            }
            if (this.watches.containsKey(watchArray[i].getExpression()) && !this.watches.get(watchArray[i].getExpression()).equals(object)) {
                this.watches.put(watchArray[i].getExpression(), object);
                return true;
            }
            this.watches.put(watchArray[i].getExpression(), object);
        }
        object = DebuggerManager.getDebuggerManager().getBreakpoints();
        n = this.callStackList.size();
        if (n >= 1) {
            Annotatable[] annotatableArray;
            Object object2 = this.callStackList.getFirst();
            if (object2 instanceof TargetOriginating) {
                object2 = ((TargetOriginating)object2).getOriginatingTarget();
            }
            Object object3 = annotatableArray = object2 instanceof Task ? ((Task)object2).getLine() : Utils.getLine((TargetLister.Target)object2, null);
            if (annotatableArray != null) {
                annotatableArray = new Annotatable[]{((Annotatable[])annotatableArray)[0]};
            }
            int n2 = ((Breakpoint[])object).length;
            for (int i = 0; i < n2; ++i) {
                if (!(object[i] instanceof AntBreakpoint) || !object[i].isEnabled() || !Utils.contains(annotatableArray, ((AntBreakpoint)object[i]).getLine())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    private void doContinue() {
        Utils.unmarkCurrent();
        this.doStop = false;
        this.targetEndToStopAt = null;
        this.taskEndToStopAt = null;
        this.fileToStopAt = null;
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStep(Object object) {
        if (object == ActionsManager.ACTION_STEP_INTO) {
            if (this.originatingIndex > 0) {
                --this.originatingIndex;
                this.updateUI();
                Object object2 = this.LOCK_ACTIONS;
                synchronized (object2) {
                    this.actionRunning = false;
                    this.LOCK_ACTIONS.notifyAll();
                }
                return;
            }
            this.doStop = true;
        } else if (object == ActionsManager.ACTION_STEP_OVER) {
            if (this.originatingIndex > 0) {
                Object e = this.callStackList.get(this.originatingIndex);
                TargetLister.Target target = ((TargetOriginating)e).getDependentTarget();
                this.targetEndToStopAt = target.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            } else {
                this.taskEndToStopAt = this.currentTaskName;
                this.targetEndToStopAt = this.currentTargetName;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else if (object == ActionsManager.ACTION_STEP_OUT) {
            Object e;
            if (this.originatingIndex > 1) {
                e = this.callStackList.get(this.originatingIndex - 1);
                TargetLister.Target target = ((TargetOriginating)e).getDependentTarget();
                this.targetEndToStopAt = target.getName();
                this.taskEndToStopAt = null;
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
            if (this.callStackList.size() > 1) {
                e = this.callStackList.get(1);
                if (e instanceof Task) {
                    this.taskEndToStopAt = ((Task)e).getTaskStructure().getName();
                    for (int i = 2; i < this.callStackList.size(); ++i) {
                        e = this.callStackList.get(i);
                        if (!(e instanceof String)) continue;
                        this.targetEndToStopAt = ((TargetLister.Target)e).getName();
                        break;
                    }
                } else {
                    this.targetEndToStopAt = e instanceof TargetOriginating ? ((TargetOriginating)e).getOriginatingTarget().getName() : ((TargetLister.Target)e).getName();
                }
                this.fileToStopAt = this.currentFile;
                this.doStop = false;
            }
        } else {
            throw new IllegalArgumentException(object.toString());
        }
        this.doEngineStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEngineStep() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        if (this.execTask != null) {
            this.execTask.stop();
        }
        Utils.unmarkCurrent();
        this.doStop = false;
        this.taskEndToStopAt = null;
        this.targetEndToStopAt = null;
        this.fileToStopAt = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
        this.buildFinished(null);
    }

    private CallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (CallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    Object[] getCallStack() {
        Object[] objectArray = this.originatingIndex > 0 ? this.callStackList.subList(this.originatingIndex, this.callStackList.size()).toArray() : this.callStackList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof TargetOriginating)) continue;
            objectArray[i] = ((TargetOriginating)objectArray[i]).getOriginatingTarget();
        }
        return objectArray;
    }

    private LinkedList findPath(File file, String string, String string2) {
        TargetLister.Target target = this.findTarget(string, file);
        if (target == null) {
            return null;
        }
        if (string.equals(string2)) {
            LinkedList<TargetOriginating> linkedList = new LinkedList<TargetOriginating>();
            linkedList.addFirst(new TargetOriginating(null, target));
            return linkedList;
        }
        String string3 = target.getElement().getAttribute("depends");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            LinkedList linkedList = this.findPath(file, string4, string2);
            if (linkedList == null) continue;
            TargetOriginating targetOriginating = (TargetOriginating)linkedList.getLast();
            if (targetOriginating.getOriginatingTarget() == null) {
                targetOriginating.setOriginatingTarget(this.findTarget(string, file));
            } else {
                linkedList.addLast(new TargetOriginating(this.findTarget(string, file), targetOriginating.getOriginatingTarget()));
            }
            return linkedList;
        }
        return null;
    }

    private synchronized TargetLister.Target findTarget(String string, File file) {
        Object object;
        TargetLister.Target target;
        HashMap<String, TargetLister.Target> hashMap = (HashMap<String, TargetLister.Target>)this.nameToTargetByFiles.get(file);
        if (hashMap == null) {
            Object object2;
            hashMap = new HashMap<String, TargetLister.Target>();
            target = FileUtil.toFileObject((File)file);
            try {
                object = DataObject.find((FileObject)target);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new IllegalStateException(dataObjectNotFoundException.getLocalizedMessage());
            }
            AntProjectCookie antProjectCookie = (AntProjectCookie)object.getCookie(AntProjectCookie.class);
            Element element = antProjectCookie.getProjectElement();
            if (element != null) {
                object2 = element.getAttribute("name");
                this.projectNamesByFiles.put(file, object2);
            }
            try {
                object2 = TargetLister.getTargets((AntProjectCookie)antProjectCookie);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    TargetLister.Target target2 = (TargetLister.Target)iterator.next();
                    hashMap.put(target2.getName(), target2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nameToTargetByFiles.put(file, hashMap);
        }
        if ((target = (TargetLister.Target)hashMap.get(string)) == null && string.startsWith((String)(object = (String)this.projectNamesByFiles.get(file)) + ".")) {
            string = string.substring(((String)object).length() + 1);
            target = (TargetLister.Target)hashMap.get(string);
        }
        return target;
    }

    synchronized void setVariablesModel(VariablesModel variablesModel) {
        this.variablesModel = variablesModel;
    }

    synchronized void setWatchesModel(WatchesModel watchesModel) {
        this.watchesModel = watchesModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVariables() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.variablesModel == null) {
                return;
            }
        }
        this.variablesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatches() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.watchesModel == null) {
                return;
            }
        }
        this.watchesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpoints() {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.breakpointModel == null) {
                for (TableModel tableModel : DebuggerManager.getDebuggerManager().lookup("BreakpointsView", TableModel.class)) {
                    if (!(tableModel instanceof BreakpointModel)) continue;
                    this.breakpointModel = (BreakpointModel)tableModel;
                    break;
                }
            }
        }
        this.breakpointModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String evaluate(String string) {
        String string2 = this.getVariableValue(string);
        if (string2 != null) {
            return string2;
        }
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.lastEvent == null) {
                return null;
            }
            return this.lastEvent.evaluate(string);
        }
    }

    String[] getVariables() {
        return this.variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getVariableValue(String string) {
        AntDebugger antDebugger = this;
        synchronized (antDebugger) {
            if (this.lastEvent == null) {
                return null;
            }
            return this.lastEvent.getProperty(string);
        }
    }

    static {
        actions = new HashSet();
        actions.add(ActionsManager.ACTION_KILL);
        actions.add(ActionsManager.ACTION_CONTINUE);
        actions.add(ActionsManager.ACTION_START);
        actions.add(ActionsManager.ACTION_STEP_INTO);
        actions.add(ActionsManager.ACTION_STEP_OVER);
        actions.add(ActionsManager.ACTION_STEP_OUT);
    }

    private static class TargetOriginating {
        private TargetLister.Target target;
        private TargetLister.Target dependent;

        TargetOriginating(TargetLister.Target target, TargetLister.Target target2) {
            this.target = target;
            this.dependent = target2;
        }

        TargetLister.Target getOriginatingTarget() {
            return this.target;
        }

        void setOriginatingTarget(TargetLister.Target target) {
            this.target = target;
        }

        TargetLister.Target getDependentTarget() {
            return this.dependent;
        }
    }
}

