/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.modules.xml.lib.Util;
import org.netbeans.modules.xml.wizard.ExternalReferenceDecorator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ExternalReferenceDataNode
extends FilterNode {
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_PREFIX = "prefix";
    private Sheet sheet;
    private boolean selected;
    private String prefix = null;
    private static int counter = 0;
    private ExternalReferenceDecorator decorator;

    public ExternalReferenceDataNode(Node node, ExternalReferenceDecorator externalReferenceDecorator) {
        super(node, (org.openide.nodes.Children)new Children(node, externalReferenceDecorator));
        this.decorator = externalReferenceDecorator;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canSelect() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        return dataObject != null && !dataObject.getPrimaryFile().isFolder();
    }

    private Node.Property createProperty(String string, Class clazz, Object object, String string2, String string3) {
        PropertySupport.Reflection reflection = null;
        try {
            reflection = new PropertySupport.Reflection(object, clazz, string2, string3);
            reflection.setName(string);
            reflection.setDisplayName(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_SchemaPanel_Column_Name_" + string)));
            reflection.setShortDescription(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_SchemaPanel_Column_Desc_" + string)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return reflection;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createProperty("name", String.class, (Object)this, "getHtmlDisplayName", null));
        if (this.canSelect()) {
            set.put(this.createProperty(PROP_SELECTED, Boolean.TYPE, (Object)this, "isSelected", "setSelected"));
        }
        return sheet;
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.sheet = this.createSheet();
        this.firePropertySetsChange(null, null);
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet sheet = this.getSheet();
        return sheet.toArray();
    }

    public String getHtmlDisplayName() {
        String string = this.getOriginal().getHtmlDisplayName();
        return string;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
            this.prefix = dataObject != null && !dataObject.getPrimaryFile().isFolder() ? this.decorator.generatePrefix(this.prefix, dataObject) : "";
        }
        return this.prefix;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDisplayName(String string) {
        super.disableDelegation(12);
        super.setDisplayName(string);
    }

    public void setPrefix(String string) {
        String string2 = this.prefix;
        this.prefix = string;
        this.firePropertyChange(PROP_PREFIX, string2, string);
    }

    public void setSelected(boolean bl) {
        if (!this.canSelect()) {
            throw new IllegalStateException("node cannot be selected");
        }
        boolean bl2 = this.selected;
        this.selected = bl;
        this.firePropertyChange(PROP_SELECTED, new Boolean(bl2), new Boolean(bl));
    }

    public String getNamespace() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return Util.getNamespace(fileObject);
        }
        return null;
    }

    public String getSchemaFileName() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            File file = FileUtil.toFile((FileObject)fileObject);
            String string = file.getPath();
            if (string != null) {
                try {
                    string = new URI(string).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return string;
        }
        return null;
    }

    private static class Children
    extends FilterNode.Children {
        ExternalReferenceDecorator decorator;

        public Children(Node node, ExternalReferenceDecorator externalReferenceDecorator) {
            super(node);
            this.decorator = externalReferenceDecorator;
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject != null) {
                FileObject fileObject = dataObject.getPrimaryFile();
                if (fileObject.isFolder() && fileObject.getNameExt().equals("nbproject") && fileObject.getFileObject("project.xml") != null) {
                    return new Node[0];
                }
                String string = fileObject.getNameExt();
                String string2 = this.decorator.getDocumentType();
                if (fileObject.isFolder() || string.endsWith(string2)) {
                    return super.createNodes(node);
                }
            }
            return new Node[0];
        }

        protected Node copyNode(Node node) {
            return this.decorator.createExternalReferenceNode(node);
        }
    }
}

