/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.cookies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.xml.cookies.CookieFactory;
import org.netbeans.modules.xml.cookies.CookieFactoryCreator;
import org.netbeans.modules.xml.lib.LookupManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.CookieSet;

public final class CookieManager
extends LookupManager {
    private final DataObject dataObject;
    private final CookieSet cookieSet;
    private final Map<CookieFactoryCreator, CookieFactory> factoryMap;

    public CookieManager(DataObject dataObject, CookieSet cookieSet, Class clazz) {
        if (!CookieFactoryCreator.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parameter class must extend CookieFactoryCreator class.");
        }
        this.dataObject = dataObject;
        this.cookieSet = cookieSet;
        this.factoryMap = new HashMap<CookieFactoryCreator, CookieFactory>();
        this.register(clazz);
        this.addedToResult(this.getResult());
    }

    protected void removedFromResult(Collection collection) {
        for (CookieFactoryCreator cookieFactoryCreator : collection) {
            CookieFactory cookieFactory = this.factoryMap.remove(cookieFactoryCreator);
            if (cookieFactory == null) continue;
            cookieFactory.unregisterCookies(this.cookieSet);
        }
    }

    protected void addedToResult(Collection collection) {
        for (CookieFactoryCreator cookieFactoryCreator : this.getResult()) {
            CookieFactory cookieFactory = cookieFactoryCreator.createCookieFactory(this.dataObject);
            if (cookieFactory == null) continue;
            this.factoryMap.put(cookieFactoryCreator, cookieFactory);
            cookieFactory.registerCookies(this.cookieSet);
        }
    }
}

