/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenuItem;
import org.netbeans.modules.xml.lib.Util;
import org.openide.awt.JInlineMenu;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class CollectSystemAction
extends SystemAction
implements Presenter.Popup {
    private static final long serialVersionUID = 6517322512481423122L;
    private Lookup.Result allActionsResult;
    static JMenuItem[] NONE = new JMenuItem[0];

    protected abstract Class getActionLookClass();

    protected synchronized Collection getPossibleActions() {
        if (this.allActionsResult == null) {
            this.allActionsResult = Lookup.getDefault().lookup(new Lookup.Template(this.getActionLookClass()));
        }
        return this.allActionsResult.allInstances();
    }

    private JMenuItem[] createMenu() {
        JMenuItem[] jMenuItemArray = this.createMenu(this.getPossibleActions());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--- CollectSystemAction.createMenu: menu = " + jMenuItemArray);
        }
        return jMenuItemArray;
    }

    private JMenuItem[] createMenu(Collection collection) {
        JMenuItem[] jMenuItemArray2;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n--> CollectSystemAction.createMenu: ( " + collection + " )");
        }
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (JMenuItem[] jMenuItemArray2 : collection) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("-*- CollectSystemAction.createMenu: next action " + jMenuItemArray2 + " -- " + (jMenuItemArray2.isEnabled() ? "<enabled>" : "[disabled]"));
            }
            if (!jMenuItemArray2.isEnabled()) continue;
            JMenuItem jMenuItem = null;
            if (jMenuItemArray2 instanceof Presenter.Popup) {
                jMenuItem = ((Presenter.Popup)jMenuItemArray2).getPopupPresenter();
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("-*- CollectSystemAction.createMenu: menu item = " + jMenuItem);
            }
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("<-- CollectSystemAction.createMenu: all items = " + arrayList + "\n");
        }
        jMenuItemArray2 = new JMenuItem[arrayList.size()];
        arrayList.toArray(jMenuItemArray2);
        return jMenuItemArray2;
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private class Menu
    extends JInlineMenu {
        private static final long serialVersionUID = -4962039848190160129L;
        private JMenuItem[] last = NONE;
        private PropL propL = new PropL();
        boolean needsChange = false;

        Menu() {
            this.changeMenuItems(CollectSystemAction.this.createMenu());
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)registry));
        }

        synchronized void changeMenuItems(JMenuItem[] jMenuItemArray) {
            this.removeListeners(this.last);
            this.addListeners(jMenuItemArray);
            this.last = jMenuItemArray;
            this.setMenuItems(jMenuItemArray);
        }

        private void addListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].addPropertyChangeListener(this.propL);
            }
        }

        private void removeListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].removePropertyChangeListener(this.propL);
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(CollectSystemAction.this.createMenu());
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        private class PropL
        implements PropertyChangeListener {
            private PropL() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == null || string.equals("enabled") || string.equals("activatedNodes")) {
                    Menu.this.needsChange = true;
                }
            }
        }
    }
}

