/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.MetadataObject;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCompletionItems
implements Iterable<SQLCompletionItem> {
    private final List<SQLCompletionItem> items = new ArrayList<SQLCompletionItem>();
    private final SQLIdentifiers.Quoter quoter;
    private final int itemOffset;

    public SQLCompletionItems(SQLIdentifiers.Quoter quoter, int n) {
        this.quoter = quoter;
        this.itemOffset = n;
    }

    public Set<String> addSchemas(Catalog catalog, Set<String> set, String string, final String string2, final int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(catalog.getSchemas(), set, string, new Handler<Schema>(){

            @Override
            public void handle(Schema schema) {
                if (!schema.isSynthetic()) {
                    String string = schema.getName();
                    SQLCompletionItems.this.items.add(SQLCompletionItem.schema(string, SQLCompletionItems.this.quote(string, string2), SQLCompletionItems.this.itemOffset + n));
                }
            }
        });
        return treeSet;
    }

    public void addTables(Schema schema, Set<String> set, String string, final String string2, final int n) {
        SQLCompletionItems.filterMetadata(schema.getTables(), set, string, new Handler<Table>(){

            @Override
            public void handle(Table table) {
                String string = table.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.table(string, SQLCompletionItems.this.quote(string, string2), SQLCompletionItems.this.itemOffset + n));
            }
        });
    }

    public void addAliases(List<String> list, String string, String string2, final int n) {
        SQLCompletionItems.filterStrings(list, null, string, new Handler<String>(){

            @Override
            public void handle(String string) {
                SQLCompletionItems.this.items.add(SQLCompletionItem.alias(string, string, SQLCompletionItems.this.itemOffset + n));
            }
        });
    }

    public void addColumns(Schema schema, final Table table, String string, final String string2, final int n) {
        final QualIdent qualIdent = schema.isDefault() ? null : new QualIdent(schema.getName(), table.getName());
        SQLCompletionItems.filterMetadata(table.getColumns(), null, string, new Handler<Column>(){

            @Override
            public void handle(Column column) {
                String string = column.getName();
                if (qualIdent != null) {
                    SQLCompletionItems.this.items.add(SQLCompletionItem.column(qualIdent, string, SQLCompletionItems.this.quote(string, string2), SQLCompletionItems.this.itemOffset + n));
                } else {
                    SQLCompletionItems.this.items.add(SQLCompletionItem.column(table.getName(), string, SQLCompletionItems.this.quote(string, string2), SQLCompletionItems.this.itemOffset + n));
                }
            }
        });
    }

    public void addColumns(Catalog catalog, QualIdent qualIdent, String string, String string2, int n) {
        Schema schema = null;
        Table table = null;
        if (qualIdent.isSimple()) {
            if (!catalog.isDefault()) {
                return;
            }
            schema = catalog.getDefaultSchema();
            if (schema == null) {
                return;
            }
            table = schema.getTable(qualIdent.getSimpleName());
        } else if (qualIdent.isSingleQualified()) {
            schema = catalog.getSchema(qualIdent.getFirstQualifier());
            if (schema == null) {
                return;
            }
            table = schema.getTable(qualIdent.getSimpleName());
        }
        if (table != null) {
            this.addColumns(schema, table, string, string2, n);
        }
    }

    public void fill(CompletionResultSet completionResultSet) {
        completionResultSet.addAllItems(this.items);
    }

    @Override
    public Iterator<SQLCompletionItem> iterator() {
        return this.items.iterator();
    }

    private String quote(String string, String string2) {
        if (string2 != null) {
            return new StringBuilder(string.length() + 2).append(string2).append(string).append(string2).toString();
        }
        return this.quoter.quoteIfNeeded(string);
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    private static boolean filter(String string, String string2) {
        return string2 == null || SQLCompletionItems.startsWithIgnoreCase(string, string2);
    }

    private static void filterStrings(Collection<String> collection, Set<String> set, String string, Handler<String> handler) {
        for (String string2 : collection) {
            if (set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            handler.handle(string2);
        }
    }

    private static <T extends MetadataObject> void filterMetadata(Collection<T> collection, Set<String> set, String string, Handler<T> handler) {
        for (MetadataObject metadataObject : collection) {
            String string2 = metadataObject.getName();
            if (string2 == null || set != null && !set.contains(string2) || !SQLCompletionItems.filter(string2, string)) continue;
            handler.handle(metadataObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<T> {
        public void handle(T var1);
    }
}

