/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatementAnalyzer {
    private final TokenSequence<SQLTokenId> seq;
    private final List<List<String>> selectValues = new ArrayList<List<String>>();
    private final List<FromTable> fromTables = new ArrayList<FromTable>();
    private final List<SQLStatement> subqueries = new ArrayList<SQLStatement>();
    private State state = State.START;

    public static SQLStatement analyze(TokenSequence<SQLTokenId> tokenSequence) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return new SQLStatement(0, 0, Collections.<List<String>>emptyList(), null, Collections.<SQLStatement>emptyList());
        }
        int n = tokenSequence.offset();
        SQLStatementAnalyzer sQLStatementAnalyzer = new SQLStatementAnalyzer(tokenSequence);
        sQLStatementAnalyzer.parse();
        FromClause fromClause = sQLStatementAnalyzer.state.isAfter(State.FROM) ? sQLStatementAnalyzer.createFromClause() : null;
        return new SQLStatement(n, tokenSequence.offset() + tokenSequence.token().length(), Collections.unmodifiableList(sQLStatementAnalyzer.selectValues), fromClause, Collections.unmodifiableList(sQLStatementAnalyzer.subqueries));
    }

    private SQLStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence) {
        this.seq = tokenSequence;
    }

    private FromClause createFromClause() {
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (FromTable fromTable : this.fromTables) {
            if (fromTable.alias == null) {
                hashSet.add(fromTable.tableName);
                continue;
            }
            if (hashMap.containsKey(fromTable.alias)) continue;
            hashMap.put(fromTable.alias, fromTable.tableName);
        }
        return new FromClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parse() {
        boolean bl = false;
        block14: do {
            switch (this.state) {
                case START: {
                    if (!this.isKeyword("SELECT")) continue block14;
                    this.state = State.SELECT;
                    break;
                }
                case SELECT: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            List<String> list = this.analyzeSelectValue();
                            if (list.isEmpty()) break;
                            this.selectValues.add(list);
                            break;
                        }
                        case KEYWORD: {
                            if (!this.isKeyword("FROM")) break;
                            this.state = State.FROM;
                            bl = true;
                            break;
                        }
                    }
                    break;
                }
                case FROM: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            if (!bl) break;
                            this.fromTables.add(this.parseFromTable());
                            bl = false;
                            break;
                        }
                        case COMMA: {
                            bl = true;
                            break;
                        }
                        case KEYWORD: {
                            if (this.isKeyword("FROM") || this.isKeyword("JOIN")) {
                                bl = true;
                                break;
                            }
                            if (!this.isKeywordAfterFrom()) break;
                            this.state = State.END;
                        }
                    }
                    break;
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeSelectValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((Object)this.seq.token().text()).toString());
        boolean bl = false;
        block7: while (true) {
            if (!this.nextToken()) {
                return arrayList;
            }
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block7;
                }
                case IDENTIFIER: {
                    if (bl) {
                        bl = false;
                        arrayList.add(((Object)this.seq.token().text()).toString());
                        continue block7;
                    }
                    arrayList.clear();
                    arrayList.add(((Object)this.seq.token().text()).toString());
                    continue block7;
                }
                case LPAREN: {
                    arrayList.clear();
                    continue block7;
                }
                case COMMA: {
                    break block7;
                }
                case KEYWORD: {
                    if (this.isKeyword("AS")) {
                        bl = false;
                        arrayList.clear();
                        continue block7;
                    }
                    if (!this.isKeyword("FROM") && !this.isKeywordAfterFrom()) continue block7;
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        this.seq.movePrevious();
        return arrayList;
    }

    private FromTable parseFromTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((Object)this.seq.token().text()).toString());
        boolean bl = false;
        String string = null;
        block5: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block5;
                }
                case IDENTIFIER: {
                    if (bl && string == null) {
                        bl = false;
                        arrayList.add(((Object)this.seq.token().text()).toString());
                        continue block5;
                    }
                    string = ((Object)this.seq.token().text()).toString();
                    continue block5;
                }
                case KEYWORD: {
                    if (this.isKeyword("AS")) {
                        bl = false;
                        continue block5;
                    }
                    this.seq.movePrevious();
                    break block5;
                }
                default: {
                    this.seq.movePrevious();
                    break block5;
                }
            }
        }
        return new FromTable(new QualIdent(arrayList), string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean nextToken() {
        boolean bl;
        block7: while (bl = this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block7;
                }
            }
        }
        if (!this.state.isAfter(State.SELECT)) return bl;
        if (!this.isKeyword("SELECT")) return bl;
        int n = this.seq.offset();
        int n2 = 1;
        while (bl = this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case LPAREN: {
                    ++n2;
                    break;
                }
                case RPAREN: {
                    if (--n2 != 0) break;
                    TokenSequence tokenSequence = this.seq.subSequence(n, this.seq.offset());
                    this.subqueries.add(SQLStatementAnalyzer.analyze((TokenSequence<SQLTokenId>)tokenSequence));
                    return bl;
                }
            }
        }
        return bl;
    }

    private boolean isKeyword(CharSequence charSequence) {
        return this.seq.token().id() == SQLTokenId.KEYWORD && StringUtils.textEqualsIgnoreCase(this.seq.token().text(), charSequence);
    }

    private boolean isKeywordAfterFrom() {
        if (this.seq.token().id() != SQLTokenId.KEYWORD) {
            return false;
        }
        CharSequence charSequence = this.seq.token().text();
        return StringUtils.textEqualsIgnoreCase("WHERE", charSequence) || StringUtils.textEqualsIgnoreCase("HAVING", charSequence) || StringUtils.textEqualsIgnoreCase("ORDER", charSequence);
    }

    private static class FromTable {
        private final QualIdent tableName;
        private final String alias;

        public FromTable(QualIdent qualIdent, String string) {
            this.tableName = qualIdent;
            this.alias = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START(0),
        SELECT(1),
        FROM(2),
        END(3);

        private int order;

        private State(int n2) {
            this.order = n2;
        }

        public boolean isAfter(State state) {
            return this.order >= state.order;
        }
    }
}

