/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualIdent
implements Comparable<QualIdent> {
    private final List<String> parts;

    public QualIdent(String ... stringArray) {
        this.parts = Arrays.asList(stringArray);
    }

    public QualIdent(List<String> list) {
        this.parts = new ArrayList<String>(list);
    }

    public QualIdent(QualIdent qualIdent, String string) {
        this.parts = new ArrayList<String>(qualIdent.parts.size() + 1);
        this.parts.addAll(qualIdent.parts);
        this.parts.add(string);
    }

    public QualIdent(String string, QualIdent qualIdent) {
        this.parts = new ArrayList<String>(qualIdent.parts.size() + 1);
        this.parts.add(string);
        this.parts.addAll(qualIdent.parts);
    }

    private QualIdent(List<String> list, int n, int n2) {
        this.parts = list.subList(n, n2);
    }

    public String getFirstQualifier() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty.");
        }
        return this.parts.get(0);
    }

    public String getSimpleName() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty.");
        }
        return this.parts.get(this.parts.size() - 1);
    }

    public QualIdent getPrefix() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty");
        }
        return new QualIdent(this.parts, 0, this.parts.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isSimple() {
        return this.size() == 1;
    }

    public boolean isSingleQualified() {
        return this.size() == 2;
    }

    public int size() {
        return this.parts.size();
    }

    public boolean isPrefixedBy(QualIdent qualIdent) {
        if (this.size() < qualIdent.size()) {
            return false;
        }
        for (int i = 0; i < qualIdent.size(); ++i) {
            if (this.parts.get(i).equals(qualIdent.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(QualIdent qualIdent) {
        int n = 0;
        while (true) {
            if (n < this.parts.size()) {
                if (n >= qualIdent.parts.size()) return 1;
                int n2 = this.parts.get(n).compareToIgnoreCase(qualIdent.parts.get(n));
                if (n2 != 0) {
                    return n2;
                }
            } else {
                if (n >= qualIdent.parts.size()) return 0;
                return -1;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QualIdent)) {
            return false;
        }
        QualIdent qualIdent = (QualIdent)object;
        return ((Object)qualIdent.parts).equals(this.parts);
    }

    public int hashCode() {
        return ((Object)this.parts).hashCode();
    }

    public String toString() {
        if (this.parts.size() == 0) {
            return "<empty>";
        }
        StringBuilder stringBuilder = new StringBuilder(this.parts.size() * 10);
        Iterator<String> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

