/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.view;

import java.util.List;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.visitor.XPathVisitor;
import org.netbeans.modules.xslt.mapper.model.BuildExpressionVisitor;
import org.netbeans.modules.xslt.mapper.model.nodes.LiteralCanvasNode;
import org.netbeans.modules.xslt.mapper.model.nodes.Node;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.model.targettree.StylesheetNode;
import org.netbeans.modules.xslt.mapper.view.GetExpressionVisitor;
import org.netbeans.modules.xslt.mapper.view.NodeCreatorVisitor;
import org.netbeans.modules.xslt.mapper.view.PredicateFinderVisitor;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslVisitor;

public class DiagramBuilder {
    boolean updating = false;
    private XsltMapper mapper;
    private boolean relayoutRequired;
    private PredicateFinderVisitor pfv;

    public DiagramBuilder(XsltMapper xsltMapper) {
        this.mapper = xsltMapper;
        this.pfv = new PredicateFinderVisitor(xsltMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiagram(boolean bl) {
        TreeNode treeNode = (TreeNode)this.mapper.getMapperViewManager().getDestView().getTree().getModel().getRoot();
        if (treeNode != null) {
            this.relayoutRequired = false;
            try {
                this.updating = true;
                this.updateDiagramRecursive(treeNode, bl);
            }
            finally {
                this.updating = false;
            }
            if (this.relayoutRequired) {
                this.mapper.getMapperViewManager().getCanvasView().getAutoLayout().autoLayout();
            }
        }
        this.mapper.getPredicateManager().clearTemporaryPredicates();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void updateDiagram(TreeNode treeNode, boolean bl) {
        Node node;
        Object object = treeNode.getDataObject();
        if (!(object instanceof XslComponent)) {
            return;
        }
        XslComponent xslComponent = (XslComponent)object;
        GetExpressionVisitor getExpressionVisitor = new GetExpressionVisitor();
        xslComponent.accept((XslVisitor)getExpressionVisitor);
        XPathExpression xPathExpression = getExpressionVisitor.getExpression();
        if (xPathExpression != null) {
            this.pfv.setContextXslComponent(xslComponent);
            xPathExpression.accept((XPathVisitor)this.pfv);
        }
        List<Node> list = treeNode.getPreviousNodes();
        Object object2 = null;
        if (bl) {
            if (!list.isEmpty() && bl && (node = list.get(0)) != null) {
                BuildExpressionVisitor buildExpressionVisitor = new BuildExpressionVisitor(this.mapper.getContext());
                node.accept(buildExpressionVisitor);
                object2 = buildExpressionVisitor.getResult();
            }
            if (!(object2 == null || xPathExpression != null && object2.toString().equals(xPathExpression.toString()))) {
                this.destroyDiagramRecursive(treeNode);
            }
        } else {
            this.destroyDiagramRecursive(treeNode);
        }
        if (!(xPathExpression == null || object2 != null && xPathExpression.toString().equals(object2.toString()))) {
            this.relayoutRequired = true;
            node = this.buildDiagramRecursive(xPathExpression);
            if (node != null) {
                this.mapper.addLink(node, treeNode);
            }
        }
    }

    public void destroyDiagramRecursive(Node node) {
        List<Node> list = node.getPreviousNodes();
        for (Node node2 : list) {
            if (node2 == null) continue;
            IBasicViewModel iBasicViewModel = this.mapper.getMapperViewManager().getMapperModel().getSelectedViewModel();
            this.mapper.removeDirectedChain(node2.getMapperNode(), iBasicViewModel);
        }
        List list2 = node.getMapperNode().getLinks();
        for (int i = 0; i < list2.size(); ++i) {
            this.mapper.removeLink((IMapperLink)list2.get(i));
        }
    }

    private Node buildDiagramRecursive(XPathExpression xPathExpression) {
        NodeCreatorVisitor nodeCreatorVisitor = new NodeCreatorVisitor(this.mapper);
        xPathExpression.accept((XPathVisitor)nodeCreatorVisitor);
        Node node = nodeCreatorVisitor.getResult();
        if (node == null) {
            return null;
        }
        IMapperNode iMapperNode = node.getMapperNode();
        if (!(iMapperNode instanceof IMapperTreeNode)) {
            IFieldNode iFieldNode;
            this.mapper.addNode(iMapperNode);
            if (node instanceof LiteralCanvasNode) {
                iFieldNode = (IFieldNode)node.getOutputNode();
                iFieldNode.setLiteralName(xPathExpression.toString());
            }
            if (iMapperNode instanceof IMethoidNode && xPathExpression instanceof XPathOperationOrFuntion) {
                iFieldNode = (IMethoidNode)iMapperNode;
                IMethoid iMethoid = (IMethoid)iFieldNode.getMethoidObject();
                boolean bl = iMethoid.isAccumulative();
                int n = 0;
                for (Object e : ((XPathOperationOrFuntion)xPathExpression).getChildren()) {
                    List list = iFieldNode.getInputFieldNodes();
                    if (n >= list.size()) break;
                    IFieldNode iFieldNode2 = (IFieldNode)list.get(n);
                    assert (iFieldNode2 != null) : "Filed shouldn't be null anyway";
                    if (!e.toString().startsWith("$unconnectedInput_")) {
                        Node node2 = this.buildDiagramRecursive((XPathExpression)e);
                        iFieldNode2.setNodeObject((Object)node2);
                        if (node2 != null) {
                            this.mapper.addLink(node2, node);
                        }
                    }
                    ++n;
                }
            }
        }
        return node;
    }

    private boolean methoidHasField(IMethoidNode iMethoidNode, String string) {
        for (Object e : iMethoidNode.getInputFieldNodes()) {
            IFieldNode iFieldNode;
            String string2;
            if (!(e instanceof IFieldNode) || !string.equals(string2 = (iFieldNode = (IFieldNode)e).getName())) continue;
            return true;
        }
        return false;
    }

    private void updateDiagramRecursive(TreeNode treeNode, boolean bl) {
        if (treeNode instanceof StylesheetNode) {
            this.updateDiagram(treeNode, bl);
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.updateDiagramRecursive(treeNode2, bl);
            }
        }
    }
}

