/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 */

webui.suntheme4_2.dojo.provide("webui.suntheme4_2.widget.jsfx.textField");

webui.suntheme4_2.dojo.require("webui.suntheme4_2.json");
webui.suntheme4_2.dojo.require("webui.suntheme4_2.widget.jsfx.common");
webui.suntheme4_2.dojo.require("webui.suntheme4_2.widget.jsfx.dynaFaces");
webui.suntheme4_2.dojo.require("webui.suntheme4_2.widget.textField");

/**
 * @class This class contains functions to obtain data asynchronously using JSF
 * Extensions as the underlying transfer protocol.
 * @static
 */
webui.suntheme4_2.widget.jsfx.textField = {
    /**
     * This function is used to process validation events with Object literals.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @return {boolean} true if successful; otherwise, false.
     */
    processValidationEvent: function(props) {
        if (props == null) {
            return false;
        }
        
        // Dynamic Faces requires a DOM node as the source property.
        var domNode = document.getElementById(props.id);
        
        // Generate AJAX request using the JSF Extensions library.
        DynaFaces.fireAjaxTransaction(
            (domNode) ? domNode : document.forms[0], {
            execute: props.id,
            render: props.id,
            replaceElement: webui.suntheme4_2.widget.jsfx.textField.validationCallback,
            xjson: {
                id : props.id,
                event: "validate"
            }
        });
        return true;
    },  

    /**
     * This function is used to update widgets.
     *
     * @param {String} elementId The HTML element Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to DynaFaces.fireAjaxTransaction.
     * @param {Object} xjson The xjson argument provided to DynaFaces.fireAjaxTransaction.
     * @return {boolean} true if successful; otherwise, false.
     */
    validationCallback: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }
        
        // Parse JSON text.
        var props = webui.suntheme4_2.json.parse(content);

        // Update text field.
        var widget = webui.suntheme4_2.dijit.byId(elementId);
        widget.setProps({
            valid: props.valid,
            errorImage: {
                title: props.detail
            }
        });

        // Notify decoupled widgets.
        if (widget.notify) {
            // Update each given client ID.
            for (var i = 0; i < widget.notify.length; i++) {
                // Get widget associated with client ID.
                var curWidget = webui.suntheme4_2.dijit.byId(widget.notify[i]);
                if (curWidget && typeof curWidget.notify == "function") {
                    curWidget.notify(props);
                }
            }
        }

        // Publish an event for custom AJAX implementations to listen for.
        webui.suntheme4_2.dojo.publish(
            webui.suntheme4_2.widget.textField.event.validation.endTopic, [props]);
        return true;
    },

    /**
     * This function is used to process autoComplete events.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @return {boolean} true if successful; otherwise, false.
     */
    processAutoCompleteEvent: function(props) {
        if (props == null) {
            return false;
        }
        
        // Dynamic Faces requires a DOM node as the source property.
        var domNode = document.getElementById(props.id);
        
        // Generate AJAX request using the JSF Extensions library.
        DynaFaces.fireAjaxTransaction(
            (domNode) ? domNode : document.forms[0], {
            execute: props.id,
            render: props.id,
            replaceElement: webui.suntheme4_2.widget.jsfx.textField.autoCompleteCallback,
            xjson: {
                id : props.id,
                event: "autocomplete"
            }
        });
        return true;
    },  

    /**
     * This function is used to update widgets with new autoComplete options list.
     *
     * @param {String} elementId The HTML element Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to DynaFaces.fireAjaxTransaction.
     * @param {Object} xjson The xjson argument provided to DynaFaces.fireAjaxTransaction.
     * @return {boolean} true if successful; otherwise, false.
     */
    autoCompleteCallback: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }
        
        // Parse JSON text.
        var props = webui.suntheme4_2.json.parse(content);

        // Update text field.
        var widget = webui.suntheme4_2.dijit.byId(elementId);
        widget.setProps(props);       


        // Publish an event for custom AJAX implementations to listen for.
        webui.suntheme4_2.dojo.publish(
            webui.suntheme4_2.widget.textField.event.autoComplete.endTopic, [props]);
        return true;
    }    
};

// Listen for Dojo Widget events.
webui.suntheme4_2.dojo.subscribe(webui.suntheme4_2.widget.textField.event.refresh.beginTopic,
    webui.suntheme4_2.widget.jsfx.common, "processRefreshEvent");
webui.suntheme4_2.dojo.subscribe(webui.suntheme4_2.widget.textField.event.state.beginTopic,
    webui.suntheme4_2.widget.jsfx.common, "processStateEvent");
webui.suntheme4_2.dojo.subscribe(webui.suntheme4_2.widget.textField.event.submit.beginTopic,
    webui.suntheme4_2.widget.jsfx.common, "processSubmitEvent");
webui.suntheme4_2.dojo.subscribe(webui.suntheme4_2.widget.textField.event.validation.beginTopic,
    webui.suntheme4_2.widget.jsfx.textField, "processValidationEvent");
webui.suntheme4_2.dojo.subscribe(webui.suntheme4_2.widget.textField.event.autoComplete.beginTopic,
    webui.suntheme4_2.widget.jsfx.textField, "processAutoCompleteEvent");
