/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.util;

import com.sun.rave.web.ui.util.ClassLoaderFinder;
import com.sun.rave.web.ui.util.MessageUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceBundleManager {
    private static ResourceBundleManager _instance = new ResourceBundleManager();
    private Map _cache = new HashMap();

    protected ResourceBundleManager() {
    }

    public static ResourceBundleManager getInstance() {
        if (_instance == null) {
            _instance = new ResourceBundleManager();
        }
        return _instance;
    }

    protected ResourceBundle getCachedBundle(String baseName, Locale locale) {
        return (ResourceBundle)this._cache.get(this.getCacheKey(baseName, locale));
    }

    protected String getCacheKey(String baseName, Locale locale) {
        return baseName + "__" + locale.toString();
    }

    protected void addCachedBundle(String baseName, Locale locale, ResourceBundle bundle) {
        HashMap<String, ResourceBundle> map = new HashMap<String, ResourceBundle>(this._cache);
        map.put(this.getCacheKey(baseName, locale), bundle);
        this._cache = map;
    }

    public ResourceBundle getBundle(String baseName, Locale locale) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null && (bundle = ResourceBundle.getBundle(baseName, locale, ClassLoaderFinder.getCurrentLoader(MessageUtil.class))) != null) {
            this.addCachedBundle(baseName, locale, bundle);
        }
        return bundle;
    }

    public ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null && (bundle = ResourceBundle.getBundle(baseName, locale, loader)) != null) {
            this.addCachedBundle(baseName, locale, bundle);
        }
        return bundle;
    }
}

