/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.theme;

import com.sun.rave.web.ui.theme.ThemeFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemeServlet
extends HttpServlet {
    public static final String localeParameter = "com.sun.rave.web.ui.locales";
    private static final boolean DEBUG = false;
    private static final Map respType = new HashMap();
    private long lastModified = new Date().getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceName = request.getPathInfo();
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            int character;
            int lastDot;
            inStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
            if (inStream == null) {
                response.sendError(404, request.getRequestURI());
                return;
            }
            inStream = new BufferedInputStream(inStream, 4096);
            String type = this.getServletContext().getMimeType(resourceName);
            if (type == null && (lastDot = resourceName.lastIndexOf(46)) != -1) {
                String suffix = resourceName.substring(lastDot + 1);
                type = (String)respType.get(suffix.toLowerCase());
            }
            if (type != null) {
                response.setContentType(type);
            }
            response.setDateHeader("Last-Modified", this.getLastModified(request));
            outStream = response.getOutputStream();
            outStream = new BufferedOutputStream(outStream, 4096);
            while ((character = inStream.read()) != -1) {
                outStream.write(character);
            }
        }
        catch (IOException ioex) {
        }
        finally {
            try {
                inStream.close();
            }
            catch (Throwable t) {}
            try {
                outStream.close();
            }
            catch (Throwable t) {}
        }
    }

    public String getServletInfo() {
        return "Theme Servlet for Sun Web Components";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ThemeFactory.initializeThemeManager(config.getServletContext(), this.getLocales(config));
    }

    private Set getLocales(ServletConfig config) {
        String localesString = config.getInitParameter(localeParameter);
        if (localesString == null) {
            return null;
        }
        String[] localeArray = localesString.split(",");
        HashSet<Locale> locales = new HashSet<Locale>();
        Object language = null;
        Object country = null;
        Object variant = null;
        String[] strings = null;
        Locale locale = null;
        String localeString = null;
        for (int counter = 0; counter < localeArray.length; ++counter) {
            localeString = localeArray[counter].trim();
            if (localeString.length() == 0) continue;
            strings = localeString.split("_");
            if (strings.length > 2) {
                locale = new Locale(strings[0], strings[1], strings[2]);
            } else if (strings.length > 1) {
                locale = new Locale(strings[0], strings[1]);
            } else if (strings.length > 0) {
                locale = new Locale(strings[0]);
            }
            locales.add(locale);
        }
        return locales;
    }

    public long getLastModified(HttpServletRequest request) {
        return this.lastModified;
    }

    static {
        respType.put("js", "text/javascript");
        respType.put("css", "text/css");
        respType.put("htm", "text/html");
        respType.put("html", "text/html");
        respType.put("wml", "text/wml");
        respType.put("txt", "text/plain");
        respType.put("xml", "text/xml");
        respType.put("jpeg", "image/jpeg");
        respType.put("jpe", "image/jpeg");
        respType.put("jpg", "image/jpeg");
        respType.put("png", "image/png");
        respType.put("tif", "image/tiff");
        respType.put("tiff", "image/tiff");
        respType.put("bmp", "image/bmp");
        respType.put("xbm", "image/xbm");
        respType.put("ico", "image/x-icon");
        respType.put("gif", "image/gif");
        respType.put("pdf", "application/pdf");
        respType.put("ps", "application/postscript");
        respType.put("mim", "application/mime");
        respType.put("mime", "application/mime");
        respType.put("mid", "application/midi");
        respType.put("midi", "application/midi");
        respType.put("wav", "audio/wav");
        respType.put("bwf", "audio/wav");
        respType.put("cpr", "image/cpr");
        respType.put("avi", "video/x-msvideo");
        respType.put("mpeg", "video/mpeg");
        respType.put("mpg", "video/mpeg");
        respType.put("mpm", "video/mpeg");
        respType.put("mpv", "video/mpeg");
        respType.put("mpa", "video/mpeg");
        respType.put("au", "audio/basic");
        respType.put("snd", "audio/basic");
        respType.put("ulw", "audio/basic");
        respType.put("aiff", "audio/x-aiff");
        respType.put("aif", "audio/x-aiff");
        respType.put("aifc", "audio/x-aiff");
        respType.put("cdda", "audio/x-aiff");
        respType.put("pict", "image/x-pict");
        respType.put("pic", "image/x-pict");
        respType.put("pct", "image/x-pict");
        respType.put("mov", "video/quicktime");
        respType.put("qt", "video/quicktime");
        respType.put("pdf", "application/pdf");
        respType.put("pdf", "application/pdf");
        respType.put("ssm", "application/smil");
        respType.put("rsml", "application/vnd.rn-rsml");
        respType.put("ra", "application/vnd.rn-realaudio");
        respType.put("rm", "application/vnd.rn-realmedia");
        respType.put("rv", "application/vnd.rn-realvideo");
        respType.put("rf", "application/vnd.rn-realflash");
        respType.put("rf", "application/vnd.rn-realflash");
        respType.put("asf", "application/x-ms-asf");
        respType.put("asx", "application/x-ms-asf");
        respType.put("wm", "application/x-ms-wm");
        respType.put("wma", "application/x-ms-wma");
        respType.put("wax", "application/x-ms-wax");
        respType.put("wmw", "application/x-ms-wmw");
        respType.put("wvx", "application/x-ms-wvx");
        respType.put("swf", "application/x-shockwave-flash");
        respType.put("spl", "application/futuresplash");
        respType.put("avi", "video/msvideo");
        respType.put("flc", "video/flc");
        respType.put("mp4", "video/mpeg4");
    }
}

