/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Tab;
import com.sun.rave.web.ui.component.TabSet;
import com.sun.rave.web.ui.renderer.HyperlinkRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TabRenderer
extends HyperlinkRenderer {
    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        super.renderStart(context, component, writer);
        UIComponent parent = component.getParent();
        if (!(parent instanceof Tab) && !(parent instanceof TabSet) && LogUtil.infoEnabled()) {
            LogUtil.info((Object)TabRenderer.class, "WEBUI0006", new String[]{component.getId()});
        }
    }

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Tab tab = (Tab)component;
        int tabIndex = tab.getTabIndex();
        if (tabIndex >= 0) {
            writer.writeAttribute("tabIndex", (Object)Integer.toString(tabIndex), null);
        }
        super.finishRenderAttributes(context, component, writer);
    }

    protected String getStyles(FacesContext context, UIComponent component) {
        String text;
        Object value;
        Tab link = (Tab)component;
        StringBuffer sb = new StringBuffer(200);
        String tabStyleClass = link.getExtraStyles();
        if (tabStyleClass != null) {
            sb.append(tabStyleClass);
        }
        Theme theme = ThemeUtilities.getTheme(context);
        if (link.isDisabled()) {
            sb.append(" ");
            sb.append(theme.getStyleClass("disabled"));
        }
        if ((value = link.getText()) != null && (text = ConversionUtilities.convertValueToString((UIComponent)link, link.getText())).length() <= 6) {
            sb.append(" ");
            sb.append(theme.getStyleClass("TabPad"));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }
}

