/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Property;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class PropertyRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean overlapLabel;
        String labelAlign;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Property property = (Property)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("tr", (UIComponent)property);
        String propValue = RenderingUtilities.getStyleClasses(context, component, null);
        if (propValue != null) {
            writer.writeAttribute("class", (Object)propValue, null);
        }
        if ((propValue = property.getStyle()) != null) {
            writer.writeAttribute("style", (Object)propValue, "style");
        }
        writer.startElement("td", (UIComponent)property);
        writer.writeAttribute("valign", (Object)"top", null);
        boolean nowrap = property.isNoWrap();
        if (nowrap) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if ((labelAlign = property.getLabelAlign()) != null) {
            writer.writeAttribute("align", (Object)labelAlign, null);
        }
        if (overlapLabel = property.isOverlapLabel()) {
            writer.writeAttribute("colspan", (Object)"2", null);
        }
        writer.startElement("div", (UIComponent)property);
        writer.writeAttribute("class", (Object)theme.getStyleClass("ConTblCl1Div"), null);
        this.renderLabel(context, property, theme, writer);
        if (!overlapLabel) {
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", (UIComponent)property);
            writer.startElement("div", (UIComponent)property);
            writer.writeAttribute("class", (Object)theme.getStyleClass("ConTblCl2Div"), null);
        }
        this.renderPropertyComponents(context, property, theme, writer);
        this.renderHelpText(context, property, theme, writer);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderPropertyComponents(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent content = property.getContentComponent();
        if (content != null) {
            RenderingUtilities.renderComponent(content, context);
            return;
        }
        Iterator childrenIterator = property.getChildren().iterator();
        while (childrenIterator.hasNext()) {
            UIComponent child = (UIComponent)childrenIterator.next();
            RenderingUtilities.renderComponent(child, context);
        }
    }

    protected void renderLabel(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent label = property.getLabelComponent();
        if (label != null) {
            RenderingUtilities.renderComponent(label, context);
            return;
        }
        writer.startElement("span", (UIComponent)property);
        writer.writeAttribute("class", (Object)theme.getStyleClass("LblLev2Txt"), null);
        writer.write("&nbsp;");
        writer.endElement("span");
    }

    protected void renderHelpText(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent helpText = property.getHelpTextComponent();
        if (helpText != null) {
            RenderingUtilities.renderComponent(helpText, context);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }
}

