/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class LabelRenderer
extends Renderer {
    private static final String[] EVENT_NAMES = new String[]{"onClick", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut"};

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String value;
        if (!(component instanceof Label)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Label.class.getName()};
            String message = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Label.renderer", params);
            throw new FacesException(message);
        }
        Label label = (Label)component;
        if (LogUtil.fineEnabled(LabelRenderer.class)) {
            LogUtil.fine((Object)LabelRenderer.class, "Label.renderAttributes", new Object[]{label.getId(), label.getFor()});
        }
        EditableValueHolder comp = label.getLabeledComponent();
        boolean requiredFlag = label.isRequiredIndicator();
        boolean errorFlag = false;
        if (!label.isHideIndicators() && comp != null) {
            Object o = ((UIComponent)comp).getAttributes().get("readOnly");
            if (o != null && o instanceof Boolean && o.equals(Boolean.TRUE)) {
                requiredFlag = false;
                errorFlag = false;
            } else {
                requiredFlag = comp.isRequired();
                errorFlag = !comp.isValid();
            }
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String styleClass = this.getThemeStyleClass(label, theme, errorFlag);
        ResponseWriter writer = context.getResponseWriter();
        this.startElement(label, (UIComponent)comp, styleClass, writer, context);
        if (requiredFlag) {
            writer.write("\n");
            RenderingUtilities.renderComponent(label.getRequiredIcon(theme, context), context);
        }
        if (errorFlag) {
            writer.write("\n");
            RenderingUtilities.renderComponent(label.getErrorIcon(theme, context, false), context);
        }
        if ((value = this.formatLabelText(context, label)) != null) {
            writer.write("\n");
            writer.writeText((Object)value, "text");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement(label.getElement());
        Iterator children = label.getChildren().iterator();
        while (children.hasNext()) {
            RenderingUtilities.renderComponent((UIComponent)children.next(), context);
            writer.writeText((Object)"\n", null);
        }
        if (LogUtil.finestEnabled(LabelRenderer.class)) {
            LogUtil.finest(LabelRenderer.class, "Label.renderEnd");
        }
    }

    private void startElement(Label label, UIComponent labeledComponent, String styleClass, ResponseWriter writer, FacesContext context) throws IOException {
        String toolTip;
        writer.startElement(label.getElement(), (UIComponent)label);
        writer.writeAttribute("id", (Object)label.getClientId(context), "id");
        String id = label.getLabeledComponentId(context);
        if (id != null) {
            writer.writeAttribute("for", (Object)id, "for");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)label, styleClass);
        if (label.getStyle() != null) {
            writer.writeAttribute("style", (Object)label.getStyle(), "style");
        }
        if ((toolTip = label.getToolTip()) != null) {
            writer.writeAttribute("title", (Object)toolTip, "toolTip");
        }
        this.writeEvents(label, writer);
    }

    private String formatLabelText(FacesContext context, Label label) {
        String text = ConversionUtilities.convertValueToString((UIComponent)label, label.getValue());
        text = text.concat(" ");
        if (label.getChildCount() == 0) {
            return text;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator kids = label.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            list.add(((UIParameter)kid).getValue());
        }
        if (list.size() == 0) {
            return text;
        }
        return MessageFormat.format(text, list.toArray(new Object[list.size()]));
    }

    private String getThemeStyleClass(Label label, Theme theme, boolean errorFlag) {
        String style = null;
        int level = label.getLabelLevel();
        if (errorFlag) {
            style = theme.getStyleClass("ConErrLblTxt");
        } else if (level == 1) {
            style = theme.getStyleClass("LblLev1Txt");
        } else if (level == 2) {
            style = theme.getStyleClass("LblLev2Txt");
        } else if (level == 3) {
            style = theme.getStyleClass("LblLev3Txt");
        }
        return style;
    }

    private void writeEvents(Label label, ResponseWriter writer) throws IOException {
        Map attributes = label.getAttributes();
        int length = EVENT_NAMES.length;
        for (int i = 0; i < length; ++i) {
            Object value = attributes.get(EVENT_NAMES[i]);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)((String)value), EVENT_NAMES[i]);
                continue;
            }
            writer.writeAttribute(EVENT_NAMES[i].toLowerCase(), (Object)value.toString(), EVENT_NAMES[i]);
        }
    }
}

