/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.faces;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import com.sun.rave.web.ui.model.Option;
import java.util.ArrayList;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.model.SelectItem;

public class DataProviderPropertyResolver
extends PropertyResolver {
    public static final String VALUE_KEY = "value";
    public static final String SELECT_ITEMS_KEY = "selectItems";
    public static final String OPTIONS_KEY = "options";
    public static final String STRING_LIST_KEY = "stringList";
    public static final String ROWID_FKEY = ":ROWID:";
    public static final String ROWKEY_FKEY = ":ROWKEY:";
    protected PropertyResolver nested;
    static /* synthetic */ Class class$com$sun$data$provider$RowKey;
    static /* synthetic */ Class class$java$lang$String;

    public DataProviderPropertyResolver(PropertyResolver nested) {
        this.nested = nested;
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof DataProvider) {
            DataProvider provider = (DataProvider)base;
            if (VALUE_KEY.equals(property)) {
                return new ValueData(provider);
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return new SelectItemsData(provider);
            }
            if (OPTIONS_KEY.equals(property)) {
                return new OptionsData(provider);
            }
            if (STRING_LIST_KEY.equals(property)) {
                return new StringListData(provider);
            }
        } else {
            if (base instanceof ValueData) {
                return ((ValueData)base).getValue(property.toString());
            }
            if (base instanceof SelectItemsData) {
                return ((SelectItemsData)base).getSelectItems(property.toString());
            }
        }
        if (this.nested != null) {
            return this.nested.getValue(base, property);
        }
        throw new PropertyNotFoundException("Property [" + property + "] not found in object [" + base + "]");
    }

    public Object getValue(Object base, int row) throws EvaluationException, PropertyNotFoundException {
        return this.nested.getValue(base, row);
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ValueData) {
            ((ValueData)base).setValue("" + property, value);
        } else if (this.nested != null) {
            this.nested.setValue(base, property, value);
        } else {
            throw new PropertyNotFoundException("Property [" + property + "] not found in object [" + base + "]");
        }
    }

    public void setValue(Object base, int row, Object value) throws EvaluationException, PropertyNotFoundException {
        this.nested.setValue(base, row, value);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ValueData) {
            return ((ValueData)base).isReadOnly("" + property);
        }
        if (base instanceof SelectItemsData) {
            return true;
        }
        if (base instanceof DataProvider) {
            if (VALUE_KEY.equals(property)) {
                return true;
            }
            if (SELECT_ITEMS_KEY.equals(property) || OPTIONS_KEY.equals(property) || STRING_LIST_KEY.equals(property)) {
                return true;
            }
        }
        if (this.nested != null) {
            return this.nested.isReadOnly(base, property);
        }
        throw new PropertyNotFoundException("Property [" + property + "] not found in object [" + base + "]");
    }

    public boolean isReadOnly(Object base, int row) throws EvaluationException, PropertyNotFoundException {
        return this.nested.isReadOnly(base, row);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof DataProvider) {
            if (VALUE_KEY.equals(property)) {
                return ValueData.class;
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return SelectItemsData.class;
            }
            if (OPTIONS_KEY.equals(property)) {
                return OptionsData.class;
            }
            if (STRING_LIST_KEY.equals(property)) {
                return StringListData.class;
            }
        } else {
            if (base instanceof ValueData) {
                return ((ValueData)base).getType("" + property);
            }
            if (base instanceof SelectItemsData) {
                return ArrayList.class;
            }
        }
        if (this.nested != null) {
            return this.nested.getType(base, property);
        }
        throw new PropertyNotFoundException("Property [" + property + "] not found in object [" + base + "]");
    }

    public Class getType(Object base, int row) throws EvaluationException, PropertyNotFoundException {
        return this.nested.getType(base, row);
    }

    private class StringListData
    extends SelectItemsData {
        public StringListData(DataProvider provider) {
            super(provider);
        }

        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null) {
                return new String(itemValue.toString());
            }
            return "";
        }
    }

    private class OptionsData
    extends SelectItemsData {
        public OptionsData(DataProvider provider) {
            super(provider);
        }

        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null && itemLabel != null && itemDescr != null) {
                return new Option(itemValue, itemLabel.toString(), itemDescr.toString());
            }
            if (itemValue != null && itemLabel != null) {
                return new Option(itemValue, itemLabel.toString());
            }
            if (itemValue != null) {
                return new Option(itemValue);
            }
            return null;
        }
    }

    private class SelectItemsData {
        protected DataProvider provider;

        public SelectItemsData(DataProvider provider) {
            this.provider = provider;
        }

        protected Object getValue(DataProvider provider, String fieldId, RowKey row) {
            if (fieldId == null) {
                return null;
            }
            Object value = null;
            if (DataProviderPropertyResolver.ROWKEY_FKEY.equals(fieldId)) {
                value = row != null ? row : (provider instanceof TableRowDataProvider ? ((TableRowDataProvider)provider).getTableRow() : null);
            } else if (DataProviderPropertyResolver.ROWID_FKEY.equals(fieldId)) {
                value = row != null ? row.getRowId() : (provider instanceof TableRowDataProvider ? ((TableRowDataProvider)provider).getTableRow().getRowId() : null);
            } else {
                try {
                    FieldKey fk = provider.getFieldKey(fieldId);
                    if (fk != null) {
                        value = row != null && provider instanceof TableDataProvider ? ((TableDataProvider)provider).getValue(fk, row) : provider.getValue(fk);
                    }
                }
                catch (Exception x) {
                    if (x instanceof RuntimeException) {
                        throw (RuntimeException)x;
                    }
                    x.printStackTrace();
                }
            }
            return value;
        }

        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null && itemLabel != null && itemDescr != null) {
                return new SelectItem(itemValue, itemLabel.toString(), itemDescr.toString());
            }
            if (itemValue != null && itemLabel != null) {
                return new SelectItem(itemValue, itemLabel.toString());
            }
            if (itemValue != null) {
                return new SelectItem(itemValue);
            }
            return null;
        }

        public Object getSelectItems(String columns) {
            String[] args;
            String col;
            String valueId = null;
            String labelId = null;
            String descrId = null;
            ArrayList<String> cols = new ArrayList<String>();
            boolean quoteOpen = false;
            int currStart = 0;
            for (int i = 0; i < columns.length(); ++i) {
                char c = columns.charAt(i);
                if (c == '\'') {
                    quoteOpen = !quoteOpen;
                    continue;
                }
                if (c != ',' || quoteOpen) continue;
                col = columns.substring(currStart, i);
                if (col.length() > 0) {
                    cols.add(col);
                }
                currStart = i + 1;
            }
            if (currStart < columns.length()) {
                col = columns.substring(currStart);
                cols.add(col);
            }
            if ((args = cols.toArray(new String[cols.size()])).length < 1) {
                throw new IllegalArgumentException();
            }
            valueId = args[0];
            if (args.length > 1) {
                labelId = args[1];
            }
            if (args.length > 2) {
                descrId = args[2];
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.provider instanceof TableDataProvider) {
                TableDataProvider tableProvider = (TableDataProvider)this.provider;
                int rowCount = tableProvider.getRowCount();
                if (rowCount < 0) {
                    rowCount = 999;
                }
                RowKey[] rows = tableProvider.getRowKeys(rowCount, null);
                for (int i = 0; i < rows.length; ++i) {
                    Object itemDescr;
                    Object itemLabel;
                    Object itemValue = this.getValue(this.provider, valueId, rows[i]);
                    Object selectItem = this.getSelectItem(itemValue, itemLabel = this.getValue(this.provider, labelId, rows[i]), itemDescr = this.getValue(this.provider, descrId, rows[i]));
                    if (selectItem == null) continue;
                    list.add(selectItem);
                }
            } else {
                Object itemDescr;
                Object itemLabel;
                Object itemValue = this.getValue(this.provider, valueId, null);
                Object selectItem = this.getSelectItem(itemValue, itemLabel = this.getValue(this.provider, labelId, null), itemDescr = this.getValue(this.provider, descrId, null));
                if (selectItem != null) {
                    list.add(selectItem);
                }
            }
            return list;
        }
    }

    private class ValueData {
        protected DataProvider provider;

        public ValueData(DataProvider provider) {
            this.provider = provider;
        }

        public Object getValue(String fieldId) throws PropertyNotFoundException {
            Object value;
            block14: {
                if (fieldId == null) {
                    return null;
                }
                value = null;
                if (DataProviderPropertyResolver.ROWKEY_FKEY.equals(fieldId)) {
                    if (this.provider instanceof TableDataProvider) {
                        return ((TableDataProvider)this.provider).getCursorRow();
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        return ((TableRowDataProvider)this.provider).getTableRow();
                    }
                } else if (DataProviderPropertyResolver.ROWID_FKEY.equals(fieldId)) {
                    if (this.provider instanceof TableDataProvider) {
                        return ((TableDataProvider)this.provider).getCursorRow().getRowId();
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        return ((TableRowDataProvider)this.provider).getTableRow().getRowId();
                    }
                } else {
                    try {
                        FieldKey fk = this.provider.getFieldKey(fieldId);
                        if (fk != null) {
                            try {
                                value = this.provider.getValue(fk);
                            }
                            catch (IndexOutOfBoundsException e) {
                                value = null;
                            }
                            break block14;
                        }
                        throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
                    }
                    catch (Exception x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                }
            }
            return value;
        }

        public void setValue(String fieldId, Object value) throws PropertyNotFoundException {
            block22: {
                if (fieldId == null) {
                    return;
                }
                if (DataProviderPropertyResolver.ROWKEY_FKEY.equals(fieldId) && value instanceof RowKey) {
                    if (this.provider instanceof TableDataProvider) {
                        try {
                            ((TableDataProvider)this.provider).setCursorRow((RowKey)value);
                            return;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        try {
                            ((TableRowDataProvider)this.provider).setTableRow((RowKey)value);
                            return;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                } else if (DataProviderPropertyResolver.ROWID_FKEY.equals(fieldId) && value instanceof String) {
                    if (this.provider instanceof TableDataProvider) {
                        try {
                            RowKey row = ((TableDataProvider)this.provider).getRowKey((String)value);
                            ((TableDataProvider)this.provider).setCursorRow(row);
                            return;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        try {
                            RowKey row = ((TableRowDataProvider)this.provider).getTableDataProvider().getRowKey((String)value);
                            ((TableRowDataProvider)this.provider).setTableRow(row);
                            return;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                } else {
                    try {
                        FieldKey fk = this.provider.getFieldKey(fieldId);
                        if (fk != null) {
                            try {
                                this.provider.setValue(fk, value);
                            }
                            catch (IndexOutOfBoundsException e) {}
                            break block22;
                        }
                        throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
                    }
                    catch (Exception x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                }
            }
        }

        public boolean isReadOnly(String fieldId) throws PropertyNotFoundException {
            if (DataProviderPropertyResolver.ROWKEY_FKEY.equals(fieldId) || DataProviderPropertyResolver.ROWID_FKEY.equals(fieldId)) {
                return false;
            }
            try {
                FieldKey fk = this.provider.getFieldKey(fieldId);
                if (fk != null) {
                    return this.provider.isReadOnly(fk);
                }
                throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
            }
            catch (Exception x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
        }

        public Class getType(String fieldId) throws PropertyNotFoundException {
            if (DataProviderPropertyResolver.ROWKEY_FKEY.equals(fieldId)) {
                return class$com$sun$data$provider$RowKey == null ? (class$com$sun$data$provider$RowKey = DataProviderPropertyResolver.class$("com.sun.data.provider.RowKey")) : class$com$sun$data$provider$RowKey;
            }
            if (DataProviderPropertyResolver.ROWID_FKEY.equals(fieldId)) {
                return class$java$lang$String == null ? (class$java$lang$String = DataProviderPropertyResolver.class$("java.lang.String")) : class$java$lang$String;
            }
            try {
                FieldKey fk = this.provider.getFieldKey(fieldId);
                if (fk != null) {
                    return this.provider.getType(fk);
                }
                throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
            }
            catch (Exception x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
        }
    }
}

