/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component.util;

import com.sun.rave.web.ui.component.ChildManager;
import com.sun.rave.web.ui.component.util.descriptors.ComponentType;
import com.sun.rave.web.ui.component.util.descriptors.LayoutComponent;
import com.sun.rave.web.ui.component.util.descriptors.LayoutElement;
import com.sun.rave.web.ui.util.VariableResolver;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.http.HttpServletRequest;

public class Util {
    private static Map _types = new HashMap();

    private Util() {
    }

    public static UIComponent getChild(UIComponent parent, String id) {
        return Util.findChild(parent, id, id);
    }

    public static UIComponent findChild(UIComponent parent, String id, String facetName) {
        if (parent == null) {
            return null;
        }
        UIComponent child = null;
        if (facetName != null && (child = (UIComponent)parent.getFacets().get(facetName)) != null) {
            return child;
        }
        if (id != null) {
            Iterator it = parent.getChildren().iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass) {
        return Util.getChild(parent, id, factoryClass, id);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, String facetName) {
        return Util.getChild(parent, id, Util.getComponentType(factoryClass), null, facetName);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties) {
        return Util.getChild(parent, id, factoryClass, properties, id);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties, String facetName) {
        return Util.getChild(parent, id, Util.getComponentType(factoryClass), properties, facetName);
    }

    private static UIComponent getChild(UIComponent parent, String id, ComponentType type, Properties properties, String facetName) {
        LayoutComponent desc = new LayoutComponent(null, id, type);
        if (properties != null) {
            desc.setOptions(properties);
        }
        if (facetName != null) {
            desc.addOption("_facetName", facetName);
        }
        return Util.getChild(parent, desc);
    }

    private static ComponentType getComponentType(String factoryClass) {
        ComponentType type = (ComponentType)_types.get(factoryClass);
        if (type == null) {
            type = new ComponentType(factoryClass, factoryClass);
            HashMap<String, ComponentType> newMap = new HashMap<String, ComponentType>(_types);
            newMap.put(factoryClass, type);
            _types = newMap;
        }
        return type;
    }

    public static UIComponent getChild(UIComponent parent, LayoutComponent descriptor) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (parent instanceof ChildManager) {
            return ((ChildManager)parent).getChild(context, descriptor);
        }
        String childId = descriptor.getId(context, parent);
        UIComponent childComponent = Util.findChild(parent, childId, (String)descriptor.getEvaluatedOption(context, "_facetName", null));
        if (childComponent != null) {
            return childComponent;
        }
        return Util.createChildComponent(context, descriptor, parent);
    }

    public static UIComponent createChildComponent(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        if (descriptor == null) {
            throw new IllegalArgumentException("'descriptor' cannot be null!");
        }
        return descriptor.getType().getFactory().create(context, descriptor, parent);
    }

    public static Object setOption(FacesContext context, String key, Object value, LayoutElement desc, UIComponent component) {
        if ((value = VariableResolver.resolveVariables(context, desc, component, value)) == null) {
            return null;
        }
        String strVal = value.toString();
        if (UIComponentTag.isValueReference((String)strVal)) {
            ValueBinding vb = context.getApplication().createValueBinding(strVal);
            if (component != null) {
                component.setValueBinding(key, vb);
            }
            value = vb;
        } else if (component != null) {
            component.getAttributes().put(key, value);
        }
        return value;
    }

    public static UIComponent getForm(FacesContext context, UIComponent component) {
        if (component != null) {
            if (component instanceof UIForm) {
                return component;
            }
            UIComponent form = component;
            do {
                if ((form = form.getParent()) == null || !(form instanceof UIForm)) continue;
                return form;
            } while (form != null);
        }
        return null;
    }

    public static String getFormName(FacesContext context, UIComponent component) {
        UIComponent form = Util.getForm(context, component);
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    public static Object resolveValue(FacesContext context, LayoutElement elt, UIComponent parent, String value) {
        String strVal;
        Object result = VariableResolver.resolveVariables(context, elt, parent, value);
        if (result != null && UIComponentTag.isValueReference((String)(strVal = result.toString()))) {
            ValueBinding vb = context.getApplication().createValueBinding(strVal);
            result = vb.getValue(context);
        }
        return result;
    }

    public static String getBase(FacesContext context) {
        return Util.getContext(context) + context.getViewRoot().getViewId();
    }

    public static String getContext(FacesContext context) {
        if (Beans.isDesignTime()) {
            return "http://localhost:18080/myapp";
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        StringBuffer sb = new StringBuffer(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        if (!("http".equals(request.getScheme()) && 80 == request.getServerPort() || "https".equals(request.getScheme()) && 443 == request.getServerPort())) {
            sb.append(":" + request.getServerPort());
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    public static String getActionURL(FacesContext context, String url) {
        return context.getApplication().getViewHandler().getActionURL(context, url);
    }

    public static boolean isVisible(UIComponent component) {
        Object visible = component.getAttributes().get("visible");
        if (visible == null) {
            return true;
        }
        return (Boolean)visible;
    }

    public static void addPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(phaseListener);
    }

    public static void removePhaseListener(PhaseListener phaseListener) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.removePhaseListener(phaseListener);
    }
}

