/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.UploadBase;
import com.sun.rave.web.ui.model.UploadedFile;
import com.sun.rave.web.ui.util.ComponentUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.fileupload.FileItem;

public class Upload
extends UploadBase
implements Serializable {
    public static final String INPUT_ID = "_com.sun.rave.web.ui.upload";
    public static final String INPUT_PARAM_ID = "_com.sun.rave.web.ui.uploadParam";
    public static final String SCRIPT_ID = "_script";
    public static final String SCRIPT_FACET = "script";
    public static final String TEXT_ID = "_text";
    public static final String UPLOAD_ERROR_KEY = "upload_error_key";
    public static final String FILE_SIZE_KEY = "file_size_key";
    private static final boolean DEBUG = false;

    protected void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object value) {
        String name;
        UploadedFileImpl uf = new UploadedFileImpl();
        uf.setAttribute(value);
        if (this.isRequired() && uf.getSize() == 0L && ((name = uf.getOriginalName()) == null || name.trim().length() == 0)) {
            this.setValue("");
            return "";
        }
        return uf;
    }

    public String getValueAsString(FacesContext context) {
        String valueString = null;
        Object value = this.getValue();
        if (value instanceof UploadedFile) {
            valueString = ((UploadedFile)value).getOriginalName();
        }
        if (valueString == null) {
            valueString = ThemeUtilities.getTheme(context).getMessage("FileUpload.noFile");
        }
        return valueString;
    }

    public String getType() {
        return "file";
    }

    public Object getText() {
        return null;
    }

    public void setText(Object text) {
    }

    public int getColumns() {
        int columns = super.getColumns();
        if (columns < 1) {
            columns = 40;
            super.setColumns(40);
        }
        return columns;
    }

    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent facet = this.getFacet("label");
        if (facet != null) {
            return clntId.concat(INPUT_ID);
        }
        facet = ComponentUtilities.getPrivateFacet((UIComponent)this, "label", false);
        if (facet == null) {
            return this.getClientId(context);
        }
        return this.getClientId(context).concat(INPUT_ID);
    }

    class UploadedFileImpl
    implements UploadedFile {
        transient Object attribute = null;

        UploadedFileImpl() {
        }

        void setAttribute(Object attribute) {
            this.attribute = attribute;
        }

        private FileItem getFileItemObject() {
            FacesContext context = FacesContext.getCurrentInstance();
            Object fileItemObject = context.getExternalContext().getRequestMap().get(this.attribute);
            if (fileItemObject == null) {
                return null;
            }
            if (!(fileItemObject instanceof FileItem)) {
                String message = "Did you install the upload filter?";
                throw new FacesException(message);
            }
            return (FileItem)fileItemObject;
        }

        public void write(File file) throws Exception {
            if (this.getFileItemObject() != null) {
                this.getFileItemObject().write(file);
            }
        }

        public long getSize() {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().getSize();
            }
            return 0L;
        }

        public String getOriginalName() {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().getName();
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().getInputStream();
            }
            return null;
        }

        public String getContentType() {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().getContentType();
            }
            return null;
        }

        public byte[] getBytes() {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().get();
            }
            return null;
        }

        public String getAsString() {
            if (this.getFileItemObject() != null) {
                return this.getFileItemObject().getString();
            }
            return null;
        }

        public void dispose() {
            if (this.getFileItemObject() != null) {
                this.getFileItemObject().delete();
            }
        }
    }
}

