/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.SelectorBase;
import com.sun.rave.web.ui.component.SelectorManager;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.ValueType;
import com.sun.rave.web.ui.util.ValueTypeEvaluator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

public class Selector
extends SelectorBase
implements SelectorManager {
    private static final boolean DEBUG = false;
    private static final String READ_ONLY_SEPARATOR = ", ";
    private boolean multiple;
    protected ValueTypeEvaluator valueTypeEvaluator = new ValueTypeEvaluator((UIComponent)this);

    public boolean getRendersChildren() {
        return true;
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        return this.getConvertedValue((UIComponent)this, this.valueTypeEvaluator, context, submittedValue);
    }

    private Object getConvertedValue(UIComponent component, ValueTypeEvaluator valueTypeEvaluator, FacesContext context, Object submittedValue) throws ConverterException {
        String cv;
        if (!(submittedValue instanceof String[])) {
            Object[] args = new Object[]{component.getClass().getName()};
            String msg = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Selector.invalidSubmittedValue", args);
            throw new ConverterException(msg);
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 1 && "com_sun_rave_web_ui_NONESELECTED".equals(rawValues[0])) {
            Object[] args = new Object[]{"com_sun_rave_web_ui_NONESELECTED"};
            String msg = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Selector.invalidSubmittedValue", args);
            throw new ConverterException(msg);
        }
        if (rawValues.length == 0 && ConversionUtilities.renderedNull(component)) {
            return null;
        }
        if (((SelectorManager)component).isMultiple()) {
            if (valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
                return ConversionUtilities.convertValueToArray(component, rawValues, context);
            }
            if (valueTypeEvaluator.getValueType() == ValueType.LIST) {
                return ConversionUtilities.convertValueToList(component, rawValues, context);
            }
            Object[] params = new Object[]{component.getClass().getName()};
            String msg = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Selector.multipleError", params);
            throw new ConverterException(msg);
        }
        String string = cv = rawValues.length == 0 ? "" : rawValues[0];
        if (valueTypeEvaluator.getValueType() == ValueType.NONE) {
            return cv;
        }
        return ConversionUtilities.convertValueToObject(component, cv, context);
    }

    protected String getValueAsReadOnly(FacesContext context) {
        return this.getValueAsString(context, READ_ONLY_SEPARATOR, true);
    }

    private String getValueAsString(FacesContext context, String separator, boolean readOnly) {
        Object value = this.getValue();
        if (value == null) {
            return new String();
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.NONE) {
            return new String();
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            return new String();
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
            StringBuffer valueBuffer = new StringBuffer(256);
            List list = (List)value;
            Iterator valueIterator = ((List)value).iterator();
            String valueString = null;
            if (!readOnly && valueIterator.hasNext()) {
                valueBuffer.append(separator);
            }
            while (valueIterator.hasNext()) {
                valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueIterator.next());
                valueBuffer.append(valueString);
                if (readOnly && (!readOnly || !valueIterator.hasNext())) continue;
                valueBuffer.append(separator);
            }
            return valueBuffer.toString();
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            StringBuffer valueBuffer = new StringBuffer(256);
            int length = Array.getLength(value);
            Object valueObject = null;
            String valueString = null;
            if (!readOnly && length != 0) {
                valueBuffer.append(separator);
            }
            for (int counter = 0; counter < length; ++counter) {
                valueObject = Array.get(value, counter);
                valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueObject);
                valueBuffer.append(valueString);
                if (readOnly && (!readOnly || counter >= length - 1)) continue;
                valueBuffer.append(separator);
            }
            return valueBuffer.toString();
        }
        String cv = ConversionUtilities.convertValueToString((UIComponent)this, value);
        if (readOnly) {
            return cv;
        }
        StringBuffer sb = new StringBuffer(64);
        return sb.append(separator).append(cv).append(separator).toString();
    }

    public int getLabelLevel() {
        int labelLevel = super.getLabelLevel();
        if (labelLevel < 1 || labelLevel > 3) {
            labelLevel = 2;
            super.setLabelLevel(labelLevel);
        }
        return labelLevel;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this.multiple != multiple) {
            this.valueTypeEvaluator.reset();
            this.multiple = multiple;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        return string;
    }

    static void log(String s, Object o) {
        System.out.println(o.getClass().getName() + "::" + s);
    }

    void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public void setSelected(Object selected) {
        super.setSelected(selected);
        this.valueTypeEvaluator.reset();
    }
}

