/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.ComplexComponent;
import com.sun.rave.web.ui.component.FieldBase;
import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.component.StaticText;
import com.sun.rave.web.ui.util.ComponentUtilities;
import java.beans.Beans;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;

public class Field
extends FieldBase
implements ComplexComponent {
    public static final String READONLY_ID = "_readOnly";
    public static final String LABEL_ID = "_label";
    public static final String INPUT_ID = "_field";
    public static final String READONLY_FACET = "readOnly";
    public static final String LABEL_FACET = "label";
    private static final boolean DEBUG = false;

    public UIComponent getLabelComponent(FacesContext context, String style) {
        String label;
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent == null && (label = this.getLabel()) != null && label.length() > 0) {
            labelComponent = this.createLabel(label, style, context);
        }
        return labelComponent;
    }

    public UIComponent getReadOnlyComponent(FacesContext context) {
        String id = this.getId();
        UIComponent textComponent = this.getFacet(READONLY_FACET);
        if (textComponent == null) {
            textComponent = this.createText(this.getReadOnlyValueString(context));
        } else if (textComponent instanceof UIOutput) {
            UIOutput outputComponent = (UIOutput)textComponent;
            outputComponent.setValue((Object)this.getReadOnlyValueString(context));
        }
        return textComponent;
    }

    private UIComponent createLabel(String labelString, String style, FacesContext context) {
        if (labelString == null || labelString.length() < 1) {
            return null;
        }
        Label label = new Label();
        label.setId(this.getId().concat(LABEL_ID));
        label.setLabelLevel(this.getLabelLevel());
        label.setStyleClass(style);
        label.setText(labelString);
        label.setLabeledComponent((UIComponent)this);
        if (!Beans.isDesignTime()) {
            this.getFacets().put(LABEL_FACET, label);
        }
        return label;
    }

    private UIComponent createText(String string) {
        if (string == null || string.length() < 1) {
            string = new String();
        }
        StaticText text = new StaticText();
        text.setText(string);
        text.setId(this.getId().concat(READONLY_ID));
        if (!Beans.isDesignTime()) {
            this.getFacets().put(READONLY_FACET, text);
        }
        return text;
    }

    protected void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent facet = this.getFacet(LABEL_FACET);
        if (facet != null) {
            return clntId.concat(INPUT_ID);
        }
        facet = ComponentUtilities.getPrivateFacet((UIComponent)this, LABEL_FACET, false);
        if (facet == null) {
            return this.getClientId(context);
        }
        return this.getClientId(context).concat(INPUT_ID);
    }

    public int getColumns() {
        int columns = super.getColumns();
        if (columns < 1) {
            columns = 20;
            super.setColumns(20);
        }
        return columns;
    }

    public void setText(Object text) {
        if (this.isReadOnly()) {
            Object facet = (UIComponent)this.getFacets().get(READONLY_FACET);
            if (facet == null || !(facet instanceof StaticText)) {
                StaticText staticText = new StaticText();
                staticText.setId(this.getId().concat(READONLY_ID));
                this.getFacets().put(READONLY_FACET, staticText);
                facet = staticText;
            }
            ((StaticText)((Object)facet)).setText(text);
        }
        super.setText(text);
    }
}

