/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ant;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class NBProfileAttachTask
extends Task {
    private Path classpath = null;
    private String port = null;
    private boolean direct = true;
    private boolean directDefinedExplicitely = false;

    public void setDirect(boolean aos) {
        this.direct = aos;
        this.directDefinedExplicitely = true;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void execute() throws BuildException {
        FileObject projectFO;
        Hashtable props = this.getProject().getProperties();
        ProfilingSettings ps = new ProfilingSettings();
        ps.load((Map)props);
        AttachSettings as = new AttachSettings();
        as.load((Map)this.getProject().getProperties());
        if (this.directDefinedExplicitely) {
            as.setDirect(Boolean.valueOf(this.direct).booleanValue());
        }
        if (this.port != null) {
            try {
                int portNo = Integer.parseInt(this.port);
                as.setPort(portNo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.getProject().log("Attaching to Profiled Application", 3);
        this.getProject().log("  classpath: " + this.classpath, 3);
        this.getProject().log("  attach direct: " + as.isDirect(), 3);
        this.getProject().log("  remote attach: " + as.isRemote(), 3);
        this.getProject().log("  remote host: " + as.getHost(), 3);
        this.getProject().log("  profiler port: " + as.getPort(), 3);
        this.getProject().log("  profiling settings: " + ps.debug(), 4);
        this.getProject().log("  attach settings: " + as.debug(), 4);
        Project profiledProject = null;
        String projectDir = (String)props.get("profiler.info.project.dir");
        if (projectDir != null && (projectFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(projectDir)))) != null) {
            try {
                profiledProject = ProjectManager.getDefault().findProject(projectFO);
            }
            catch (IOException e) {
                this.getProject().log("Could not determine project: " + e.getMessage(), 1);
            }
        }
        ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(profiledProject, null);
        Profiler.getDefault().attachToApp(ps, as);
    }
}

