/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.web.project.WebProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class WebSourceRootsUi {
    public static DefaultTableModel createModel(SourceRoots sourceRoots) {
        String[] stringArray = sourceRoots.getRootNames();
        String[] stringArray2 = sourceRoots.getRootProperties();
        URL[] uRLArray = sourceRoots.getRootURLs();
        Object[][] objectArray = new Object[uRLArray.length][2];
        for (int i = 0; i < uRLArray.length; ++i) {
            objectArray[i][0] = new File(URI.create(uRLArray[i].toExternalForm()));
            objectArray[i][1] = sourceRoots.getRootDisplayName(stringArray[i], stringArray2[i]);
        }
        return new SourceRootsModel(objectArray);
    }

    public static EditMediator registerEditMediator(WebProject webProject, SourceRoots sourceRoots, JTable jTable, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        EditMediator editMediator = new EditMediator(webProject, sourceRoots, jTable, jButton, jButton2, jButton3, jButton4);
        jButton.addActionListener(editMediator);
        jButton2.addActionListener(editMediator);
        jButton3.addActionListener(editMediator);
        jButton4.addActionListener(editMediator);
        jTable.getSelectionModel().addListSelectionListener(editMediator);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.addCellEditorListener(editMediator);
        jTable.setDefaultRenderer(File.class, new FileRenderer(FileUtil.toFile((FileObject)webProject.getProjectDirectory())));
        jTable.setDefaultEditor(String.class, defaultCellEditor);
        editMediator.valueChanged(null);
        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
        Object[] objectArray = new String[]{NbBundle.getMessage(WebSourceRootsUi.class, (String)"CTL_PackageFolders"), NbBundle.getMessage(WebSourceRootsUi.class, (String)"CTL_PackageLabels")};
        defaultTableModel.setColumnIdentifiers(objectArray);
        jTable.setSelectionMode(2);
        return editMediator;
    }

    public static void showIllegalRootsDialog(Set set) {
        JButton jButton = new JButton(NbBundle.getMessage(WebSourceRootsUi.class, (String)"CTL_WebSourceRootsUi_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebSourceRootsUi.class, (String)"AD_WebSourceRootsUi_Close"));
        WarningDlg warningDlg = new WarningDlg(set);
        String string = NbBundle.getMessage(WebSourceRootsUi.class, (String)"MSG_InvalidRoot");
        JOptionPane jOptionPane = new JOptionPane(new Object[]{string, warningDlg}, 2, 0, null, new Object[0], null);
        jOptionPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebSourceRootsUi.class, (String)"AD_InvalidRootDlg"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jOptionPane, NbBundle.getMessage(WebSourceRootsUi.class, (String)"TITLE_InvalidRoot"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
    }

    private static class WarningDlg
    extends JPanel {
        public WarningDlg(Set set) {
            this.initGui(set);
        }

        private void initGui(Set set) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            jLabel.setText(NbBundle.getMessage(WebSourceRootsUi.class, (String)"LBL_InvalidRoot"));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(WebSourceRootsUi.class, (String)"MNE_InvalidRoot").charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            JList<Object> jList = new JList<Object>(set.toArray());
            jList.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane jScrollPane = new JScrollPane(jList);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            jLabel.setLabelFor(jList);
            jList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebSourceRootsUi.class, (String)"AD_InvalidRoot"));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(NbBundle.getMessage(WebSourceRootsUi.class, (String)"MSG_InvalidRoot2"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private boolean projectConflict;

            public InvalidRootRenderer(boolean bl) {
                this.projectConflict = bl;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Project project;
                File file = (File)object;
                String string = file.getAbsolutePath();
                if (this.projectConflict && (project = FileOwnerQuery.getOwner((URI)file.toURI())) != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    String string2 = projectInformation.getDisplayName();
                    string = MessageFormat.format(NbBundle.getMessage(WebSourceRootsUi.class, (String)"TXT_RootOwnedByProject"), string, string2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        }
    }

    private static class FileRenderer
    extends DefaultTableCellRenderer {
        private File projectFolder;

        public FileRenderer(File file) {
            this.projectFolder = file;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Serializable serializable;
            if (object instanceof File) {
                serializable = (File)object;
                String string2 = this.projectFolder.getAbsolutePath() + File.separatorChar;
                String string3 = ((File)serializable).getAbsolutePath();
                string = string3.startsWith(string2) ? string3.substring(string2.length()) : string3;
            } else {
                string = null;
            }
            serializable = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (serializable instanceof JComponent) {
                ((JComponent)serializable).setToolTipText(string);
            }
            return serializable;
        }
    }

    private static class SourceRootsModel
    extends DefaultTableModel {
        public SourceRootsModel(Object[][] objectArray) {
            super(objectArray, new Object[]{"location", "label"});
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return File.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener,
    CellEditorListener {
        final JTable rootsList;
        final JButton addFolderButton;
        final JButton removeButton;
        final JButton upButton;
        final JButton downButton;
        private final Project project;
        private final SourceRoots sourceRoots;
        private final Set ownedFolders;
        private DefaultTableModel rootsModel;
        private EditMediator relatedEditMediator;
        private File lastUsedDir;

        public EditMediator(WebProject webProject, SourceRoots sourceRoots, JTable jTable, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
            if (!(jTable.getModel() instanceof DefaultTableModel)) {
                throw new IllegalArgumentException("Jtable's model has to be of class DefaultTableModel");
            }
            this.rootsList = jTable;
            this.addFolderButton = jButton;
            this.removeButton = jButton2;
            this.upButton = jButton3;
            this.downButton = jButton4;
            this.ownedFolders = new HashSet();
            this.project = webProject;
            this.sourceRoots = sourceRoots;
            this.ownedFolders.clear();
            this.rootsModel = (DefaultTableModel)jTable.getModel();
            Vector<Vector> vector = this.rootsModel.getDataVector();
            for (Vector vector2 : vector) {
                File file = (File)vector2.elementAt(0);
                this.ownedFolders.add(file);
            }
        }

        public void setRelatedEditMediator(EditMediator editMediator) {
            this.relatedEditMediator = editMediator;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.addFolderButton) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(true);
                if (this.sourceRoots.isTest()) {
                    jFileChooser.setDialogTitle(NbBundle.getMessage(WebSourceRootsUi.class, (String)"LBL_TestFolder_DialogTitle"));
                } else {
                    jFileChooser.setDialogTitle(NbBundle.getMessage(WebSourceRootsUi.class, (String)"LBL_SourceFolder_DialogTitle"));
                }
                File file = this.lastUsedDir;
                if (file == null) {
                    file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                }
                if (file != null) {
                    jFileChooser.setCurrentDirectory(file);
                }
                if ((n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.addFolderButton))) == 0) {
                    file = jFileChooser.getCurrentDirectory();
                    if (file != null) {
                        this.lastUsedDir = file;
                        if (this.relatedEditMediator != null) {
                            this.relatedEditMediator.lastUsedDir = file;
                        }
                    }
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    this.addFolders(fileArray);
                }
            } else if (object == this.removeButton) {
                this.removeElements();
            } else if (object == this.upButton) {
                this.moveUp();
            } else if (object == this.downButton) {
                this.moveDown();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = this.rootsList.getSelectedRows();
            boolean bl = nArray != null && nArray.length > 0;
            boolean bl2 = nArray != null && nArray.length > 0 && nArray[0] != 0;
            boolean bl3 = nArray != null && nArray.length > 0 && nArray[nArray.length - 1] != this.rootsList.getRowCount() - 1;
            this.removeButton.setEnabled(bl);
            this.upButton.setEnabled(bl2);
            this.downButton.setEnabled(bl3);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
        }

        private void addFolders(File[] fileArray) {
            int[] nArray = this.rootsList.getSelectedRows();
            int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
            ListSelectionModel listSelectionModel = this.rootsList.getSelectionModel();
            listSelectionModel.clearSelection();
            HashSet<File> hashSet = new HashSet<File>();
            HashSet<File> hashSet2 = new HashSet<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = FileUtil.normalizeFile((File)fileArray[i]);
                if (this.ownedFolders.contains(file)) {
                    Vector<Vector> vector = this.rootsModel.getDataVector();
                    for (int j = 0; j < vector.size(); ++j) {
                        File file2 = (File)vector.elementAt(j).elementAt(0);
                        if (!file2.equals(file)) continue;
                        listSelectionModel.addSelectionInterval(j, j);
                    }
                    continue;
                }
                if (this.relatedEditMediator != null && this.relatedEditMediator.ownedFolders.contains(file)) {
                    hashSet2.add(file);
                    continue;
                }
                Project project = FileOwnerQuery.getOwner((URI)file.toURI());
                if (project != null && !project.getProjectDirectory().equals(this.project.getProjectDirectory())) {
                    hashSet.add(file);
                    continue;
                }
                int n2 = n + 1 + i;
                this.rootsModel.insertRow(n2, new Object[]{file, this.sourceRoots.createInitialDisplayName(file)});
                listSelectionModel.addSelectionInterval(n2, n2);
                this.ownedFolders.add(file);
            }
            if (hashSet.size() > 0 || hashSet2.size() > 0) {
                hashSet.addAll(hashSet2);
                WebSourceRootsUi.showIllegalRootsDialog(hashSet);
            }
        }

        private void removeElements() {
            int n;
            int[] nArray = this.rootsList.getSelectedRows();
            if (nArray == null || nArray.length == 0) assert (false) : "Remove button should be disabled";
            for (n = nArray.length - 1; n >= 0; --n) {
                this.ownedFolders.remove(this.rootsModel.getDataVector().elementAt(0).elementAt(0));
                this.rootsModel.removeRow(nArray[n]);
            }
            if (this.rootsModel.getRowCount() != 0) {
                n = nArray[nArray.length - 1] - nArray.length + 1;
                if (n > this.rootsModel.getRowCount() - 1) {
                    n = this.rootsModel.getRowCount() - 1;
                }
                this.rootsList.setRowSelectionInterval(n, n);
            }
        }

        private void moveUp() {
            int[] nArray = this.rootsList.getSelectedRows();
            if (nArray == null || nArray.length == 0) assert (false) : "MoveUp button should be disabled";
            ListSelectionModel listSelectionModel = this.rootsList.getSelectionModel();
            listSelectionModel.clearSelection();
            for (int i = 0; i < nArray.length; ++i) {
                Vector vector = this.rootsModel.getDataVector().elementAt(nArray[i]);
                int n = nArray[i] - 1;
                this.rootsModel.removeRow(nArray[i]);
                this.rootsModel.insertRow(n, vector);
                listSelectionModel.addSelectionInterval(n, n);
            }
        }

        private void moveDown() {
            int[] nArray = this.rootsList.getSelectedRows();
            if (nArray == null || nArray.length == 0) assert (false) : "MoveDown button should be disabled";
            ListSelectionModel listSelectionModel = this.rootsList.getSelectionModel();
            listSelectionModel.clearSelection();
            for (int i = nArray.length - 1; i >= 0; --i) {
                Vector vector = this.rootsModel.getDataVector().elementAt(nArray[i]);
                int n = nArray[i] + 1;
                this.rootsModel.removeRow(nArray[i]);
                this.rootsModel.insertRow(n, vector);
                listSelectionModel.addSelectionInterval(n, n);
            }
        }
    }
}

