/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerCompile;
import org.netbeans.modules.web.project.ui.customizer.CustomizerDebug;
import org.netbeans.modules.web.project.ui.customizer.CustomizerFrameworks;
import org.netbeans.modules.web.project.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.web.project.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.project.ui.customizer.CustomizerRun;
import org.netbeans.modules.web.project.ui.customizer.CustomizerSources;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSClientHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSServiceHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWar;
import org.netbeans.modules.web.project.ui.customizer.NoWebServiceClientsPanel;
import org.netbeans.modules.web.project.ui.customizer.NoWebServicesPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class WebCompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String FRAMEWORKS = "Frameworks";
    private static final String BUILD = "Build";
    private static final String WAR = "War";
    private static final String JAVADOC = "Javadoc";
    public static final String RUN = "Run";
    public static final String DEBUG = "Debug";
    private static final String WEBSERVICESCATEGORY = "WebServicesCategory";
    private static final String WEBSERVICES = "WebServices";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";
    private String name;

    public WebCompositePanelProvider(String string) {
        this.name = string;
    }

    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        ResourceBundle resourceBundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category category = null;
        if (SOURCES.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)SOURCES, (String)resourceBundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])null);
        } else if (FRAMEWORKS.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)FRAMEWORKS, (String)resourceBundle.getString("LBL_Config_Frameworks"), null, (ProjectCustomizer.Category[])null);
        } else if (LIBRARIES.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)LIBRARIES, (String)resourceBundle.getString("LBL_Config_Libraries"), null, (ProjectCustomizer.Category[])null);
        } else if (BUILD.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)BUILD, (String)resourceBundle.getString("LBL_Config_Build"), null, (ProjectCustomizer.Category[])null);
        } else if (WAR.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)WAR, (String)resourceBundle.getString("LBL_Config_War"), null, (ProjectCustomizer.Category[])null);
        } else if (JAVADOC.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)JAVADOC, (String)resourceBundle.getString("LBL_Config_Javadoc"), null, (ProjectCustomizer.Category[])null);
        } else if (RUN.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)RUN, (String)resourceBundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])null);
        } else if (DEBUG.equals(this.name)) {
            category = ProjectCustomizer.Category.create((String)DEBUG, (String)resourceBundle.getString("LBL_Config_Debug"), null, (ProjectCustomizer.Category[])null);
        } else if (WEBSERVICESCATEGORY.equals(this.name) && WebCompositePanelProvider.showWebServicesCategory((WebProjectProperties)lookup.lookup(WebProjectProperties.class))) {
            ProjectCustomizer.Category category2 = ProjectCustomizer.Category.create((String)WEBSERVICES, (String)resourceBundle.getString("LBL_Config_WebServices"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            ProjectCustomizer.Category category3 = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)resourceBundle.getString("LBL_Config_WebServiceClients"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            category = ProjectCustomizer.Category.create((String)WEBSERVICESCATEGORY, (String)resourceBundle.getString("LBL_Config_WebServiceCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{category2, category3});
        }
        return category;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        String string = category.getName();
        WebProjectProperties webProjectProperties = (WebProjectProperties)lookup.lookup(WebProjectProperties.class);
        if (SOURCES.equals(string)) {
            return new CustomizerSources(webProjectProperties);
        }
        if (FRAMEWORKS.equals(string)) {
            return new CustomizerFrameworks(category, webProjectProperties);
        }
        if (LIBRARIES.equals(string)) {
            CustomizerProviderImpl.SubCategoryProvider subCategoryProvider = (CustomizerProviderImpl.SubCategoryProvider)lookup.lookup(CustomizerProviderImpl.SubCategoryProvider.class);
            assert (subCategoryProvider != null) : "Assuming CustomizerProviderImpl.SubCategoryProvider in customizer context";
            return new CustomizerLibraries(webProjectProperties, subCategoryProvider);
        }
        if (BUILD.equals(string)) {
            return new CustomizerCompile(webProjectProperties);
        }
        if (WAR.equals(string)) {
            return new CustomizerWar(webProjectProperties);
        }
        if (JAVADOC.equals(string)) {
            return new CustomizerJavadoc(webProjectProperties);
        }
        if (RUN.equals(string)) {
            return new CustomizerRun(webProjectProperties);
        }
        if (DEBUG.equals(string)) {
            return new CustomizerDebug(webProjectProperties);
        }
        if (WEBSERVICES.equals(string) || WEBSERVICECLIENTS.equals(string)) {
            ProjectWebModule projectWebModule = (ProjectWebModule)webProjectProperties.getProject().getLookup().lookup(ProjectWebModule.class);
            FileObject fileObject = projectWebModule.getDocumentBase();
            if (WEBSERVICES.equals(string)) {
                WebServicesSupport webServicesSupport;
                List list = null;
                if (fileObject != null && (webServicesSupport = WebServicesSupport.getWebServicesSupport((FileObject)fileObject)) != null) {
                    list = webServicesSupport.getServices();
                }
                if (list != null && list.size() > 0) {
                    return new CustomizerWSServiceHost(webProjectProperties, list);
                }
                return new NoWebServicesPanel();
            }
            if (WEBSERVICECLIENTS.equals(string)) {
                WebServicesClientSupport webServicesClientSupport;
                List list = null;
                if (fileObject != null && (webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)fileObject)) != null) {
                    list = webServicesClientSupport.getServiceClients();
                }
                if (list != null && list.size() > 0) {
                    return new CustomizerWSClientHost(webProjectProperties, list);
                }
                return new NoWebServiceClientsPanel();
            }
        }
        return new JPanel();
    }

    public static WebCompositePanelProvider createSources() {
        return new WebCompositePanelProvider(SOURCES);
    }

    public static WebCompositePanelProvider createFrameworks() {
        return new WebCompositePanelProvider(FRAMEWORKS);
    }

    public static WebCompositePanelProvider createLibraries() {
        return new WebCompositePanelProvider(LIBRARIES);
    }

    public static WebCompositePanelProvider createBuild() {
        return new WebCompositePanelProvider(BUILD);
    }

    public static WebCompositePanelProvider createWar() {
        return new WebCompositePanelProvider(WAR);
    }

    public static WebCompositePanelProvider createJavadoc() {
        return new WebCompositePanelProvider(JAVADOC);
    }

    public static WebCompositePanelProvider createRun() {
        return new WebCompositePanelProvider(RUN);
    }

    public static WebCompositePanelProvider createDebug() {
        return new WebCompositePanelProvider(DEBUG);
    }

    public static WebCompositePanelProvider createWebServicesCategory() {
        return new WebCompositePanelProvider(WEBSERVICESCATEGORY);
    }

    private static boolean showWebServicesCategory(WebProjectProperties webProjectProperties) {
        WebProject webProject = webProjectProperties.getProject();
        if (!webProject.isJavaEE5(webProject)) {
            WebServicesSupport webServicesSupport = WebServicesSupport.getWebServicesSupport((FileObject)webProject.getProjectDirectory());
            WebServicesClientSupport webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)webProject.getProjectDirectory());
            return webServicesSupport != null || webServicesClientSupport != null;
        }
        return false;
    }
}

