/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.AntArtifactChooser;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesNode;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.WarIncludesUiSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WarIncludesUi {
    private WarIncludesUi() {
    }

    static class ClassPathCellRenderer
    extends DefaultTableCellRenderer {
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        ClassPathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = null;
            if (object instanceof ClassPathSupport.Item) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)object;
                this.setIcon(ClassPathCellRenderer.getIcon(item));
                this.setToolTipText(this.getToolTipText(item));
                string = this.getDisplayName(item);
            }
            return super.getTableCellRendererComponent(jTable, string, bl, false, n, n2);
        }

        private String getDisplayName(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WarIncludesUi.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                    }
                    return item.getLibrary().getDisplayName();
                }
                case 3: {
                    String string = (String)WELL_KNOWN_PATHS_NAMES.get(CommonProjectUtils.getAntPropertyName((String)item.getReference()));
                    return string == null ? item.getReference() : string;
                }
                case 2: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WarIncludesUi.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                    }
                    return item.getArtifactURI().toString();
                }
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(WarIncludesUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    return item.getFilePath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(Utilities.mergeImages((Image)ProjectProperties.ICON_LIBRARY.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ProjectProperties.ICON_LIBRARY;
                }
                case 2: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_ARTIFACT == null) {
                            ICON_BROKEN_ARTIFACT = new ImageIcon(Utilities.mergeImages((Image)ProjectProperties.ICON_ARTIFACT.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_ARTIFACT;
                    }
                    return ProjectProperties.ICON_ARTIFACT;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(Utilities.mergeImages((Image)ProjectProperties.ICON_JAR.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    File file = item.getResolvedFile();
                    return file.isDirectory() ? ClassPathCellRenderer.getFolderIcon() : ProjectProperties.ICON_JAR;
                }
                case 3: {
                    return ProjectProperties.ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ClassPathSupport.Item item) {
            return this.getDisplayName(item);
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ClassPathSupport.Item item) {
            String string = item.getReference();
            return string.substring(12, string.indexOf(46, 12));
        }

        private String getLibraryName(ClassPathSupport.Item item) {
            String string = item.getReference();
            return string.substring(7, string.indexOf(".classpath"));
        }

        private String getFileRefName(ClassPathSupport.Item item) {
            String string = item.getReference();
            return string.substring(17, string.length() - 1);
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
            WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(LibrariesNode.class, (String)"LBL_JavacClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(LibrariesNode.class, (String)"LBL_JavacTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(LibrariesNode.class, (String)"LBL_RunTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(LibrariesNode.class, (String)"LBL_BuildClassesDir_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(LibrariesNode.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener,
    TableModelListener {
        private final WebProject project;
        private final JTable list;
        private final WarIncludesUiSupport.ClasspathTableModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addJar;
        private final ButtonModel addLibrary;
        private final ButtonModel addAntArtifact;
        private final ButtonModel remove;
        private Document libraryPath;

        public EditMediator(WebProject webProject, JTable jTable, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, Document document) {
            this.list = jTable;
            if (!(jTable.getModel() instanceof WarIncludesUiSupport.ClasspathTableModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (WarIncludesUiSupport.ClasspathTableModel)jTable.getModel();
            this.selectionModel = jTable.getSelectionModel();
            this.addJar = buttonModel;
            this.addLibrary = buttonModel2;
            this.addAntArtifact = buttonModel3;
            this.remove = buttonModel4;
            this.libraryPath = document;
            this.project = webProject;
        }

        public static void register(WebProject webProject, JTable jTable, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, Document document) {
            EditMediator editMediator = new EditMediator(webProject, jTable, buttonModel, buttonModel2, buttonModel3, buttonModel4, document);
            buttonModel.addActionListener(editMediator);
            buttonModel2.addActionListener(editMediator);
            buttonModel3.addActionListener(editMediator);
            buttonModel4.addActionListener(editMediator);
            editMediator.selectionModel.addListSelectionListener(editMediator);
            editMediator.listModel.addTableModelListener(editMediator);
            editMediator.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.addJar) {
                FileChooser fileChooser = new FileChooser(this.project.getAntProjectHelper(), true);
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
                fileChooser.setFileSelectionMode(2);
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setDialogTitle(NbBundle.getMessage(WarIncludesUi.class, (String)"LBL_AddFile_DialogTitle"));
                fileChooser.setAcceptAllFileFilterUsed(true);
                File file = UserProjectSettings.getDefault().getLastUsedClassPathFolder();
                fileChooser.setCurrentDirectory(file);
                int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this.list));
                if (n == 0) {
                    String[] stringArray;
                    try {
                        stringArray = fileChooser.getSelectedPaths();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                        return;
                    }
                    WarIncludesUiSupport.addJarFiles(stringArray, FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.listModel);
                    file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
                    UserProjectSettings.getDefault().setLastUsedClassPathFolder(file);
                }
            } else if (object == this.addLibrary) {
                Object object2;
                HashSet<Library> hashSet = new HashSet<Library>();
                Iterator iterator = WarIncludesUiSupport.getIterator(this.listModel);
                while (iterator.hasNext()) {
                    object2 = (ClassPathSupport.Item)iterator.next();
                    if (object2.getType() != 1) continue;
                    hashSet.add(object2.getLibrary());
                }
                object2 = LibraryChooser.showDialog((LibraryManager)this.project.getReferenceHelper().getProjectLibraryManager(), null, (LibraryChooser.LibraryImportHandler)this.project.getReferenceHelper().getLibraryChooserImportHandler());
                if (object2 != null) {
                    WarIncludesUiSupport.addLibraries(object2.toArray(new Library[object2.size()]), hashSet, this.list);
                }
            } else if (object == this.addAntArtifact) {
                AntArtifactChooser.ArtifactItem[] artifactItemArray = AntArtifactChooser.showDialog((String[])new String[]{"jar", "folder"}, (Project)this.project, (Component)this.list.getParent());
                if (artifactItemArray != null) {
                    WarIncludesUiSupport.addArtifacts(artifactItemArray, this.listModel);
                }
            } else if (object == this.remove) {
                WarIncludesUiSupport.remove(this.list);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ClassPathSupport.Item item;
            boolean bl;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.list.getSelectionModel();
            int n = defaultListSelectionModel.getMinSelectionIndex();
            boolean bl2 = bl = n != -1;
            if (bl && !(item = (ClassPathSupport.Item)this.listModel.getValueAt(n, 0)).canDelete()) {
                bl = false;
            }
            this.remove.setEnabled(bl);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getColumn() == 1) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)this.listModel.getValueAt(tableModelEvent.getFirstRow(), 0);
                String string = (String)this.listModel.getValueAt(tableModelEvent.getFirstRow(), 1);
                String string2 = null;
                if (item.getType() == 0 && string.startsWith("WEB-INF")) {
                    if (string.equals("WEB-INF\\lib") || string.equals("WEB-INF/lib")) {
                        string2 = ((File)item.getObject()).isDirectory() ? NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FOLDER_IN_WEBINF_LIB", (Object)string) : NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FILE_IN_WEBINF_LIB", (Object)string);
                    } else if (string.equals("WEB-INF\\classes") || string.equals("WEB-INF/classes")) {
                        string2 = NbBundle.getMessage(WarIncludesUi.class, (String)"MSG_NO_FOLDER_IN_WEBINF_CLASSES", (Object)string);
                    }
                }
                if (string2 != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(string2, 2));
                }
                item.setAdditionalProperty("pathInDeployment", (String)this.listModel.getValueAt(tableModelEvent.getFirstRow(), 1));
            }
        }
    }
}

