/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.WebProjectUtil;
import org.netbeans.modules.web.project.classpath.ClassPathSupportCallbackImpl;
import org.netbeans.modules.web.project.ui.SourceNodeFactory;
import org.netbeans.modules.web.project.ui.WebLogicalViewProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class LibrariesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        WebProject webProject = (WebProject)project.getLookup().lookup(WebProject.class);
        assert (webProject != null);
        return new LibrariesNodeList(webProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibrariesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String LIBRARIES = "Libs";
        private static final String TEST_LIBRARIES = "TestLibs";
        private final SourceRoots testSources;
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private final ReferenceHelper resolver;
        private final ClassPathSupport cs;

        LibrariesNodeList(WebProject webProject) {
            this.project = webProject;
            this.testSources = this.project.getTestSourceRoots();
            WebLogicalViewProvider webLogicalViewProvider = (WebLogicalViewProvider)this.project.getLookup().lookup(WebLogicalViewProvider.class);
            assert (webLogicalViewProvider != null);
            this.evaluator = this.project.evaluator();
            this.helper = this.project.getUpdateHelper();
            this.resolver = this.project.getReferenceHelper();
            this.cs = new ClassPathSupport(this.evaluator, this.resolver, this.helper.getAntProjectHelper(), this.helper, (ClassPathSupport.Callback)new ClassPathSupportCallbackImpl(this.helper.getAntProjectHelper()));
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(LIBRARIES);
            URL[] uRLArray = this.testSources.getRootURLs();
            boolean bl = false;
            for (int i = 0; i < uRLArray.length; ++i) {
                File file = new File(URI.create(uRLArray[i].toExternalForm()));
                if (!file.exists()) continue;
                bl = true;
                break;
            }
            if (bl) {
                arrayList.add(TEST_LIBRARIES);
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(String string) {
            if (string == LIBRARIES) {
                return new LibrariesNode(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_LibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "javac.classpath", new String[]{"build.classes.dir"}, "platform.active", "j2ee.server.instance", "j2ee.platform.classpath", new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getSourceRoots(), (LibraryChooser.Filter)WebProjectUtil.getFilter(this.project)), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getSourceRoots()), null, new SourceNodeFactory.PreselectPropertiesAction(this.project, "Libraries", "COMPILE")}, "web-module-libraries", this.cs, new String[]{"javac.classpath", "war.content.additional"});
            }
            if (string == TEST_LIBRARIES) {
                return new LibrariesNode(NbBundle.getMessage(LibrariesNodeFactory.class, (String)"CTL_TestLibrariesNode"), (Project)this.project, this.evaluator, this.helper, this.resolver, "javac.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, null, null, new Action[]{LibrariesNode.createAddProjectAction((Project)this.project, (SourceRoots)this.project.getTestSourceRoots()), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.resolver, (SourceRoots)this.project.getTestSourceRoots(), (LibraryChooser.Filter)WebProjectUtil.getFilter(this.project)), LibrariesNode.createAddFolderAction((AntProjectHelper)this.project.getAntProjectHelper(), (SourceRoots)this.project.getTestSourceRoots()), null, new SourceNodeFactory.PreselectPropertiesAction(this.project, "Libraries", "COMPILE_TESTS")}, null, this.cs, null);
            }
            assert (false) : "No node for key: " + string;
            return null;
        }

        public void addNotify() {
            this.testSources.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.testSources.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LibrariesNodeList.this.changeSupport.fireChange();
                }
            });
        }
    }
}

