/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.web.project.classpath.BootClassPathImplementation;
import org.netbeans.modules.web.project.classpath.JspSourcePathImplementation;
import org.netbeans.modules.web.project.classpath.SourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Map<ClassPathCache, ClassPath> cache = new HashMap<ClassPathCache, ClassPath>();
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.evaluator.getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getDistJar() {
        return this.getDir("dist.war");
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir("build.test.classes.dir");
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir("web.docbase.dir");
    }

    private FileType getType(FileObject fileObject) {
        FileObject fileObject2;
        int n;
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return FileType.SOURCE;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return FileType.TEST_SOURCE;
        }
        FileObject fileObject3 = this.getDocumentBaseDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.WEB_SOURCE;
        }
        fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.CLASS;
        }
        fileObject3 = this.getDistJar();
        if (fileObject3 != null && fileObject3.equals(FileUtil.getArchiveFile((FileObject)fileObject))) {
            return FileType.CLASS_IN_JAR;
        }
        fileObject3 = this.getBuildTestClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return FileType.TEST_CLASS;
        }
        return FileType.UNKNOWN;
    }

    private synchronized ClassPath getCompileTimeClasspath(FileType fileType) {
        if (fileType == FileType.SOURCE || fileType == FileType.CLASS || fileType == FileType.WEB_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.SOURCE_COMPILATION);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.SOURCE_COMPILATION, classPath);
            }
            return classPath;
        }
        if (fileType == FileType.TEST_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE_COMPILATION);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.test.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.TEST_SOURCE_COMPILATION, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getRunTimeClasspath(FileType fileType) {
        if (fileType == FileType.SOURCE || fileType == FileType.CLASS || fileType == FileType.CLASS_IN_JAR || fileType == FileType.WEB_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.SOURCE_RUNTIME);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.SOURCE_RUNTIME, classPath);
            }
            return classPath;
        }
        if (fileType == FileType.TEST_SOURCE || fileType == FileType.TEST_CLASS) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE_RUNTIME);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"run.test.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.TEST_SOURCE_RUNTIME, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getSourcepath(FileType fileType) {
        if (fileType == FileType.SOURCE || fileType == FileType.CLASS) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.SOURCE);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper));
                this.cache.put(ClassPathCache.SOURCE, classPath);
            }
            return classPath;
        }
        if (fileType == FileType.TEST_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.TEST_SOURCE);
            if (classPath == null) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots, this.helper));
                this.cache.put(ClassPathCache.TEST_SOURCE, classPath);
            }
            return classPath;
        }
        if (fileType == FileType.WEB_SOURCE) {
            ClassPath classPath = this.cache.get((Object)ClassPathCache.WEB_SOURCE);
            if (classPath == null) {
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)new JspSourcePathImplementation(this.helper, this.evaluator)), ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper))});
                this.cache.put(ClassPathCache.WEB_SOURCE, classPath);
            }
            return classPath;
        }
        return null;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache.get((Object)ClassPathCache.BOOT);
        if (classPath == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
            this.cache.put(ClassPathCache.BOOT, classPath);
        }
        return classPath;
    }

    public synchronized ClassPath getJ2eePlatformClassPath() {
        ClassPath classPath = this.cache.get((Object)ClassPathCache.PLATFORM);
        if (classPath == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"j2ee.platform.classpath"}));
            this.cache.put(ClassPathCache.PLATFORM, classPath);
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        FileType fileType = this.getType(fileObject);
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileType);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileType);
        }
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileType);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getCompileTimeClasspath(FileType.SOURCE), this.getCompileTimeClasspath(FileType.TEST_SOURCE)};
            return classPathArray;
        }
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getSourcepath(FileType.SOURCE), this.getSourcepath(FileType.WEB_SOURCE), this.getSourcepath(FileType.TEST_SOURCE)};
            return classPathArray;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(FileType.SOURCE);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(FileType.SOURCE);
        }
        assert (false);
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }

    public String getPropertyName(SourceGroup sourceGroup, String string) {
        int n;
        FileObject fileObject = sourceGroup.getRootFolder();
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return "javac.classpath";
            }
            if ("classpath/execute".equals(string)) {
                return "debug.classpath";
            }
            return null;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return "javac.test.classpath";
            }
            if ("classpath/execute".equals(string)) {
                return "run.test.classpath";
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassPathCache {
        SOURCE_COMPILATION,
        TEST_SOURCE_COMPILATION,
        SOURCE,
        TEST_SOURCE,
        WEB_SOURCE,
        SOURCE_RUNTIME,
        TEST_SOURCE_RUNTIME,
        BOOT,
        PLATFORM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileType {
        SOURCE,
        TEST_SOURCE,
        CLASS,
        TEST_CLASS,
        CLASS_IN_JAR,
        WEB_SOURCE,
        UNKNOWN;

    }
}

