/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.sql.project.dbmodel.DBMetaData;
import org.netbeans.modules.sql.project.dbmodel.Parameter;
import org.netbeans.modules.sql.project.dbmodel.PrepStmt;
import org.netbeans.modules.sql.project.dbmodel.Procedure;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumn;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumns;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLGenerator {
    public static HashMap builtInTypes = new HashMap();
    private static Logger logger = Logger.getLogger(WSDLGenerator.class.getName());
    private static WSDLFactory factory;
    private static DocumentBuilderFactory docBuilderfactory;
    private Definition def;
    private DBMetaData dbmeta;
    private String sqlFileName;
    private List sqlFileList = null;
    private String schema;
    private String wsdlFileLocation;
    private String engineFileName;
    private Document doc;
    private String STATEMENT_TYPE = null;
    private String wsdlFileName = null;
    private boolean wsdlFileExsits = false;
    private Connection conn;
    private DatabaseConnection dbConn;
    private static final String SELECT_STATEMENT = "SELECT";
    private static final String INSERT_STATEMENT = "INSERT";
    private static final String UPDATE_STATEMENT = "UPDATE";
    private static final String DELETE_STATEMENT = "DELETE";
    private static final String DDL_STATEMENT_CREATE = "CREATE";
    private static final String DDL_STATEMENT_ALTER = "ALTER";
    private static final String DDL_STATEMENT_DROP = "DROP";
    private static final String TRUNCATE_STATEMENT = "TRUNCATE";
    private static final String PROC_STATEMENT = "EXEC";

    public WSDLGenerator(DBMetaData dbmeta, String sqlFile, String wsdlFileLocation, String engineFileName) {
        this.dbmeta = dbmeta;
        this.sqlFileName = sqlFile;
        this.wsdlFileLocation = wsdlFileLocation;
        this.engineFileName = engineFileName.substring(0, engineFileName.indexOf(".xml"));
    }

    public WSDLGenerator(Connection conn, List sqlFiles, String wsdlFileName, String wsdlFileLocation, String engineFileName) {
        this.conn = conn;
        this.sqlFileList = sqlFiles;
        this.wsdlFileLocation = wsdlFileLocation;
        this.wsdlFileName = wsdlFileName;
        this.engineFileName = engineFileName.substring(0, engineFileName.indexOf(".xml"));
    }

    private static void initFactory() {
        if (factory == null) {
            try {
                factory = WSDLFactory.newInstance();
                docBuilderfactory = DocumentBuilderFactory.newInstance();
            }
            catch (WSDLException wsdle) {
                logger.log(Level.WARNING, wsdle.getMessage(), wsdle);
            }
        }
    }

    private Definition getWsdlTemplate() throws WSDLException, ParserConfigurationException, SAXException, IOException {
        Definition def = null;
        try {
            URL u = WSDLGenerator.class.getResource("sqlpro.wsdl.template");
            if (u != null) {
                String wsdlURI = u.getFile().indexOf(".jar") > 0 ? "jar:" + u.getFile() : u.getFile();
                def = this.readWSDLFile(wsdlURI);
            } else {
                logger.log(Level.WARNING, "Unable to locate the wsdl template");
            }
        }
        catch (WSDLException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return def;
    }

    private Definition readWSDLFile(String wsdlURI) throws SAXException, IOException, ParserConfigurationException, WSDLException {
        WSDLReader reader = factory.newWSDLReader();
        docBuilderfactory.setNamespaceAware(true);
        docBuilderfactory.setValidating(false);
        this.doc = docBuilderfactory.newDocumentBuilder().parse(wsdlURI);
        Definition def = reader.readWSDL(wsdlURI, this.doc);
        return def;
    }

    public Definition generateWSDL() throws Exception {
        try {
            if (new File(this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl").exists()) {
                this.wsdlFileExsits = true;
                this.def = this.loadExistingWSDLFile(this.wsdlFileName);
            } else {
                this.def = this.getWsdlTemplate();
            }
            this.modifyWSDL();
            this.writeWsdl();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return this.def;
    }

    private Definition loadExistingWSDLFile(String wsdlFileName) {
        try {
            URI f = new File(this.wsdlFileLocation + File.separator + wsdlFileName + ".wsdl").toURI();
            Definition def = this.readWSDLFile(f.getPath());
            return def;
        }
        catch (Exception mfe) {
            logger.log(Level.SEVERE, "Unable to load existing wsdl file " + wsdlFileName + " Reason: " + mfe.getLocalizedMessage());
            return null;
        }
    }

    private void modifyWSDL() throws Exception {
        try {
            this.modifyName();
            if (this.sqlFileList != null) {
                for (int i = 0; i < this.sqlFileList.size(); ++i) {
                    File f = (File)this.sqlFileList.get(i);
                    this.sqlFileName = f.getName().trim().substring(0, f.getName().indexOf(".sql"));
                    this.modifyMessageTypes(f);
                    this.createMessages();
                    PortType pt = this.createPortType();
                    Binding binding = this.createBinding(pt);
                    this.modifyServices(binding);
                }
                this.modifyPartnerLink();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
            throw e;
        }
    }

    private void modifyName() {
        QName q = this.def.getQName();
        q = new QName(q.getNamespaceURI(), this.wsdlFileName);
        this.def.setQName(q);
    }

    private void modifyMessageTypes(File sqlFile) throws Exception {
        block41: {
            try {
                Element currRequest = null;
                Element currResponse = null;
                BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                String line = null;
                StringBuffer sqlText = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    if (sqlText.length() != 0) {
                        sqlText.append("\n");
                    }
                    sqlText.append(line);
                }
                this.dbmeta = new DBMetaData(this.conn, sqlText.toString());
                logger.log(Level.INFO, "SQL Statement is:[" + this.dbmeta.getSQLText() + "]");
                this.parseSQLStatement(sqlText.toString());
                Types types = this.def.getTypes();
                if (null == types) break block41;
                List schemaList = types.getExtensibilityElements();
                for (Object o : schemaList) {
                    if (o instanceof Schema) {
                        Schema schemaType = (Schema)o;
                        Element e = schemaType.getElement();
                        currRequest = this.getElementByName(e, this.sqlFileName + "Request");
                        if (currRequest == null) {
                            currRequest = this.createElementWithComplexType(this.sqlFileName + "Request");
                        }
                        if (this.STATEMENT_TYPE != null) {
                            if (this.STATEMENT_TYPE.equalsIgnoreCase(SELECT_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                if (currResponse == null) {
                                    currResponse = this.createElementWithComplexType(this.sqlFileName + "Response");
                                }
                                this.generateSelectSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(INSERT_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(UPDATE_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DELETE_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_CREATE)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateCreateSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_ALTER)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateAlterSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_DROP)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateDropSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(TRUNCATE_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                this.removeSchemaElements(currRequest, currResponse);
                                if (currResponse == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((currResponse = this.getElementByName(e, "numRowsEffected")) == null) {
                                    currResponse = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateTruncateSchemaElements(currRequest, currResponse);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(PROC_STATEMENT)) {
                                currResponse = this.getElementByName(e, this.sqlFileName + "Response");
                                if (currResponse == null) {
                                    currResponse = this.createElementWithComplexType(this.sqlFileName + "Response");
                                }
                                this.generateProcSchemaElements(currRequest, currResponse);
                            }
                            e.appendChild(currRequest);
                            e.appendChild(currResponse);
                            continue;
                        }
                        throw new Exception("Unsupported SQL Statement entered: " + sqlText);
                    }
                    if (!(o instanceof UnknownExtensibilityElement)) continue;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                throw e;
            }
        }
    }

    private void createMessages() {
        QName responseQName = null;
        QName partQName = null;
        Message m = this.def.createMessage();
        QName qname = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Request");
        Part p = this.def.createPart();
        p.setName(this.sqlFileName + "RequestPart");
        p.setElementName(qname);
        m.addPart(p);
        m.setQName(qname);
        m.setUndefined(false);
        this.def.addMessage(m);
        Message mResponse = this.def.createMessage();
        Part p2 = this.def.createPart();
        if (this.STATEMENT_TYPE.equalsIgnoreCase(SELECT_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(PROC_STATEMENT)) {
            partQName = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Response");
        } else if (this.STATEMENT_TYPE.equalsIgnoreCase(INSERT_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(UPDATE_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(DELETE_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_CREATE) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_ALTER) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_DROP) || this.STATEMENT_TYPE.equalsIgnoreCase(TRUNCATE_STATEMENT)) {
            partQName = new QName(this.def.getTargetNamespace(), "numRowsEffected");
        }
        p2.setName(this.sqlFileName + "ResponsePart");
        p2.setElementName(partQName);
        mResponse.addPart(p2);
        responseQName = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Response");
        mResponse.setQName(responseQName);
        mResponse.setUndefined(false);
        this.def.addMessage(mResponse);
    }

    private PortType createPortType() {
        QName qn = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "_sqlsePortType");
        PortType pt = this.def.getPortType(qn);
        if (pt == null) {
            pt = this.def.createPortType();
            pt.setQName(qn);
            pt.setUndefined(false);
            this.def.addPortType(pt);
        }
        this.createPortTypeOperations(pt);
        return pt;
    }

    private void createPortTypeOperations(PortType pt) {
        Operation op = pt.getOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response");
        if (op == null) {
            op = this.def.createOperation();
            op.setName(this.sqlFileName);
            Input input = this.def.createInput();
            Output output = this.def.createOutput();
            input.setMessage(this.getMessageByName(this.sqlFileName + "Request"));
            input.setName(this.sqlFileName + "Request");
            output.setMessage(this.getMessageByName(this.sqlFileName + "Response"));
            output.setName(this.sqlFileName + "Response");
            op.setInput(input);
            op.setOutput(output);
            op.setUndefined(false);
            pt.addOperation(op);
        }
    }

    private Binding createBinding(PortType pt) {
        Operation op;
        QName qname = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "Binding");
        Binding binding = this.def.getBinding(qname);
        if (binding == null) {
            binding = this.def.createBinding();
            binding.setQName(qname);
            binding.setUndefined(false);
            binding.setPortType(pt);
            this.def.addBinding(binding);
        } else {
            PortType pt2 = binding.getPortType();
            if (pt2.equals(pt)) {
                BindingOperation bindingOp = binding.getBindingOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response");
                if (bindingOp != null) {
                    return binding;
                }
            } else {
                binding.setPortType(pt2);
                pt = pt2;
            }
        }
        BindingOperation bo = this.def.createBindingOperation();
        bo.setName(this.sqlFileName);
        if (pt != null && (op = pt.getOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response")) != null) {
            bo.setOperation(op);
            BindingInput binput = this.def.createBindingInput();
            binput.setName(this.sqlFileName + "Request");
            bo.setBindingInput(binput);
            BindingOutput boutput = this.def.createBindingOutput();
            boutput.setName(this.sqlFileName + "Response");
            bo.setBindingOutput(boutput);
            binding.addBindingOperation(bo);
        }
        return binding;
    }

    private Message getMessageByName(String messageName) {
        QName qname = new QName("http://com.sun.jbi/sqlse/sqlseengine", messageName);
        return this.def.getMessage(qname);
    }

    private void modifyMessageElementName(Message message, String partName, String newElementName) {
        Part part = message.getPart(partName);
        if (part != null) {
            QName qname = new QName("http://com.sun.jbi/sqlse/sqlseengine", newElementName);
            part.setElementName(qname);
        }
    }

    private void modifyServices(Binding binding) {
        Port p = null;
        QName qname = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "_sqlseService");
        Service service = this.def.getService(qname);
        if (service == null) {
            service = this.def.createService();
            service.setQName(qname);
            p = this.def.createPort();
            p.setBinding(binding);
            p.setName(this.wsdlFileName + "_sqlsePort");
            service.addPort(p);
            this.def.addService(service);
        }
    }

    private void modifyPartnerLink() {
        if (!this.wsdlFileExsits) {
            List l = this.def.getExtensibilityElements();
            UnknownExtensibilityElement plinkType = (UnknownExtensibilityElement)l.get(0);
            plinkType.getElement();
            String plinkName = plinkType.getElement().getAttribute("name");
            plinkType.getElement().setAttribute("name", this.wsdlFileName + "_" + plinkName);
            NodeList nl = plinkType.getElement().getChildNodes();
            Element plinkRole = (Element)nl.item(1);
            plinkRole.setAttribute("name", this.wsdlFileName + "_" + plinkRole.getAttribute("name"));
            String temp = plinkRole.getAttribute("portType").substring("tns:".length());
            plinkRole.setAttribute("portType", "tns:" + this.wsdlFileName + "_" + temp);
        }
    }

    private void generateDeleteSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateCreateSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateAlterSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateDropSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateTruncateSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateInsertSchemaElements(Element requestElement, Element responseElement) throws Exception {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
            throw e;
        }
    }

    private void generateSelectSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            PrepStmt prep = this.dbmeta.getPrepStmtMetaData();
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (prep.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prep, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prep, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void generateProcSchemaElements(Element requestElement, Element responseElement) {
        try {
            Element colElem2;
            Element sequenceElement;
            Procedure proc;
            String catalog = this.conn.getCatalog();
            this.schema = this.dbConn.getSchema();
            String procName = this.getProcName();
            if (catalog == null) {
                catalog = "";
            }
            if ((proc = this.dbmeta.getProcedureMetaData(catalog, this.schema, procName, "Procedure")).getHasReturn()) {
                // empty if block
            }
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null) {
                if (proc.getNumParameters() > 0) {
                    this.addProcedureParametersToElement(proc, sequenceElement);
                } else {
                    NodeList list = sequenceElement.getChildNodes();
                    if (list != null) {
                        for (int j = list.getLength() - 1; j >= 0; --j) {
                            sequenceElement.removeChild(list.item(j));
                        }
                    }
                }
            }
            if (responseElement != null && (colElem2 = this.getElementByName(responseElement, "xsd:sequence")) != null) {
                this.addProcedureResultSetColumnsToElement(proc, colElem2);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void addResultSetColumnsToElement(PrepStmt prep, Element sequenceElement) throws WSDLException {
        ResultSetColumn[] rs;
        NodeList list;
        String colType = null;
        if (sequenceElement != null && (list = sequenceElement.getChildNodes()) != null) {
            for (int j = list.getLength() - 1; j >= 0; --j) {
                sequenceElement.removeChild(list.item(j));
            }
        }
        if (prep != null && (rs = prep.getResultSetColumns()) != null && rs.length > 0) {
            for (int i = 0; i < rs.length; ++i) {
                try {
                    colType = rs[i].getJavaType();
                    Element elem = null;
                    if (!WSDLGenerator.isBuiltInType(colType)) {
                        throw new WSDLException("INVALID_WSDL", "Invalid datatype encountered");
                    }
                    elem = this.createElement(rs[i].getName(), (String)builtInTypes.get(colType));
                    sequenceElement.appendChild(elem);
                    continue;
                }
                catch (WSDLException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage());
                    throw new WSDLException("INVALID_WSDL", "Check if the sql entered is valid");
                }
            }
        }
    }

    private void addProcedureResultSetColumnsToElement(Procedure proc, Element sequenceElement) throws WSDLException {
        int j;
        NodeList list;
        String colType = null;
        if (sequenceElement != null && (list = sequenceElement.getChildNodes()) != null) {
            for (j = list.getLength() - 1; j >= 0; --j) {
                sequenceElement.removeChild(list.item(j));
            }
        }
        if (proc != null) {
            ResultSetColumns[] rss = proc.getResultSetColumnsArray();
            for (j = 0; j < rss.length; ++j) {
                ResultSetColumn rs = rss[j].get(j);
                if (rs == null) continue;
                try {
                    colType = rs.getJavaType();
                    Element elem = null;
                    if (!WSDLGenerator.isBuiltInType(colType)) {
                        throw new WSDLException("INVALID_WSDL", "Invalid datatype encountered");
                    }
                    elem = this.createElement(rs.getName(), (String)builtInTypes.get(colType));
                    sequenceElement.appendChild(elem);
                    continue;
                }
                catch (WSDLException e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage());
                    throw new WSDLException("INVALID_WSDL", "Check if the sql entered is valid");
                }
            }
        }
    }

    private void addPreparedStmtParametersToElement(PrepStmt prep, Element sequenceElement) {
        if (prep.getNumParameters() > 0 && sequenceElement != null) {
            NodeList list = sequenceElement.getChildNodes();
            if (list != null) {
                for (int j = list.getLength() - 1; j >= 0; --j) {
                    sequenceElement.removeChild(list.item(j));
                }
            }
            Parameter[] params = prep.getParameters();
            for (int i = 0; i < prep.getNumParameters(); ++i) {
                Element elem2 = this.createElement(params[i].getName(), (String)builtInTypes.get(params[i].getJavaType()));
                sequenceElement.appendChild(elem2);
            }
        }
    }

    private void addProcedureParametersToElement(Procedure prep, Element sequenceElement) {
        if (prep.getNumParameters() > 0 && sequenceElement != null) {
            NodeList list = sequenceElement.getChildNodes();
            if (list != null) {
                for (int j = list.getLength() - 1; j >= 0; --j) {
                    sequenceElement.removeChild(list.item(j));
                }
            }
            Parameter[] params = prep.getParameters();
            for (int i = 0; i < prep.getNumParameters(); ++i) {
                Element elem2 = this.createElement(params[i].getName(), (String)builtInTypes.get(params[i].getJavaType()));
                sequenceElement.appendChild(elem2);
            }
        }
    }

    private Element getElementByName(Element e, String elementName) {
        if (e.getAttribute("name").equalsIgnoreCase(elementName)) {
            return e;
        }
        NodeList list = e.getChildNodes();
        Element el = null;
        Element e2 = null;
        for (int i = 0; i < list.getLength() && e2 == null; ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            el = (Element)n;
            if (el.getAttribute("name").equalsIgnoreCase(elementName) || el.getTagName().equalsIgnoreCase(elementName) || el.getLocalName() != null && el.getLocalName().equalsIgnoreCase(elementName)) {
                e2 = el;
                break;
            }
            e2 = this.getElementByName(el, elementName);
            if (e2 == null || !e2.getAttribute("name").equalsIgnoreCase(elementName)) continue;
            return e2;
        }
        return e2;
    }

    private void parseSQLStatement(String sqlText) {
        String modSQLText = (sqlText = sqlText.trim()).toUpperCase();
        this.STATEMENT_TYPE = modSQLText.startsWith(SELECT_STATEMENT) ? SELECT_STATEMENT : (modSQLText.startsWith(INSERT_STATEMENT) ? INSERT_STATEMENT : (modSQLText.startsWith(UPDATE_STATEMENT) ? UPDATE_STATEMENT : (modSQLText.startsWith(DELETE_STATEMENT) ? DELETE_STATEMENT : (modSQLText.startsWith(TRUNCATE_STATEMENT) ? TRUNCATE_STATEMENT : (modSQLText.startsWith(DDL_STATEMENT_CREATE) ? DDL_STATEMENT_CREATE : (modSQLText.startsWith(DDL_STATEMENT_ALTER) ? DDL_STATEMENT_ALTER : (modSQLText.startsWith(DDL_STATEMENT_DROP) ? DDL_STATEMENT_DROP : PROC_STATEMENT)))))));
    }

    private void writeWsdl() throws WSDLException {
        try {
            WSDLWriter writer = factory.newWSDLWriter();
            FileWriter sink = new FileWriter(this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl");
            writer.writeWSDL(this.def, (Writer)sink);
            logger.log(Level.INFO, "Successfully generated wsdl file:" + this.wsdlFileName + ".wsdl");
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", e.getMessage());
        }
    }

    private void indentWSDLFile(Writer writer) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            PrintWriter pw = new PrintWriter(writer);
            StreamResult result = new StreamResult(pw);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
            }
            catch (Exception e) {
                // empty catch block
            }
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to indent wsdl file " + e.getLocalizedMessage());
        }
    }

    public static boolean isBuiltInType(String type) {
        return builtInTypes.get(type) != null;
    }

    private Element createElementWithComplexType(String name) {
        Element elem = this.doc.createElement("xsd:element");
        elem.setAttribute("name", name);
        Element complexType = this.doc.createElement("xsd:complexType");
        Element sequence = this.doc.createElement("xsd:sequence");
        complexType.appendChild(sequence);
        elem.appendChild(complexType);
        return elem;
    }

    private Element createElement(String name, String type) {
        Element elem = this.doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        elem.setAttribute("name", name);
        elem.setAttribute("type", type);
        return elem;
    }

    private void removeSchemaElements(Element requestElement, Element responseElement) {
        try {
            NodeList list;
            NodeList list2;
            Element sequenceElement;
            if (requestElement != null && (sequenceElement = this.getElementByName(requestElement, "xsd:sequence")) != null && (list2 = sequenceElement.getChildNodes()) != null) {
                for (int j = list2.getLength() - 1; j >= 0; --j) {
                    sequenceElement.removeChild(list2.item(j));
                }
            }
            if (responseElement != null && responseElement != null && (list = responseElement.getChildNodes()) != null) {
                for (int j = list.getLength() - 1; j >= 0; --j) {
                    responseElement.removeChild(list.item(j));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void setDBConnection(DatabaseConnection con) {
        this.dbConn = con;
        this.schema = this.schema;
    }

    private String getProcName() {
        String proc_name = "";
        String schema = "";
        StringTokenizer tok = new StringTokenizer(this.dbmeta.getSQLText(), " ");
        while (tok.hasMoreElements()) {
            String column = (String)tok.nextElement();
            int cnt = 0;
            if ((column = column.toLowerCase()).endsWith("call")) {
                ++cnt;
                proc_name = (String)tok.nextElement();
                if (proc_name.contains(".")) {
                    StringTokenizer tok1 = new StringTokenizer(proc_name, ".");
                    schema = tok1.nextToken();
                    proc_name = tok1.nextToken();
                }
                if (proc_name.contains("(")) {
                    int i = proc_name.indexOf("(");
                    proc_name = proc_name.substring(0, i);
                }
                if (proc_name.contains("}")) {
                    int i = proc_name.indexOf("}");
                    proc_name = proc_name.substring(0, i);
                }
            }
            if (cnt <= 0) continue;
            break;
        }
        return proc_name;
    }

    static {
        builtInTypes.put("byte[]", "xsd:base64Binary");
        builtInTypes.put("boolean", "xsd:boolean");
        builtInTypes.put("byte", "xsd:byte");
        builtInTypes.put("java.util.Calendar", "xsd:dateTime");
        builtInTypes.put("java.math.BigDecimal", "xsd:decimal");
        builtInTypes.put("double", "xsd:double");
        builtInTypes.put("float", "xsd:float");
        builtInTypes.put("byte[]", "xsd:hexBinary");
        builtInTypes.put("int", "xsd:int");
        builtInTypes.put("java.math.BigInteger", "xsd:integer");
        builtInTypes.put("long", "xsd:long");
        builtInTypes.put("javax.xml.namespace.QName", "xsd:QName");
        builtInTypes.put("short", "xsd:short");
        builtInTypes.put("java.lang.String", "xsd:string");
        builtInTypes.put("java.sql.Time", "xsd:string");
        builtInTypes.put("java.sql.Timestamp", "xsd:string");
        builtInTypes.put("java.sql.Date", "xsd:string");
        builtInTypes.put("java.sql.Blob", "xsd:string");
        builtInTypes.put("java.sql.Clob", "xsd:string");
        builtInTypes.put("java.sql.ResultSet", "xsd:ResultSet");
        WSDLGenerator.initFactory();
    }
}

