/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.sql.project.anttasks.FileUtil;
import org.w3c.dom.Document;

public class SQLEngineFileGenerator {
    private Map sqlDefinitionMap = new HashMap();
    private String engineFileName = null;
    private String projectName = null;
    private static Logger logger = Logger.getLogger(SQLEngineFileGenerator.class.getName());

    public SQLEngineFileGenerator(String engineFileName, String projectName) {
        this.engineFileName = engineFileName;
        this.projectName = projectName;
    }

    public void addSQLDefinition(String sqlFileName, DatabaseConnection dbConn) {
        this.sqlDefinitionMap.put(sqlFileName, dbConn);
    }

    public void persistEngineFile(String jndi_name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<sqlengine name=\"" + this.projectName + "\">");
        for (String sqlFileName : this.sqlDefinitionMap.keySet()) {
            DatabaseConnection dbConn = (DatabaseConnection)this.sqlDefinitionMap.get(sqlFileName);
            sb.append("<sqldef>\n");
            sb.append("<sqlfile name=\"" + sqlFileName + "\"/>" + "\n");
            sb.append("<connectiondef name=\"" + dbConn.getName() + "\"" + "\t");
            sb.append("driverClass=\"" + dbConn.getDriverClass() + "\"" + "\t");
            sb.append("dbURL=\"" + dbConn.getDatabaseURL() + "\"" + "\t");
            sb.append("databaseName=\"" + dbConn.getSchema() + "\"" + "\t");
            sb.append("user=\"" + dbConn.getUser() + "\"" + "\t");
            sb.append("password=\"" + dbConn.getPassword() + "\"" + "\t");
            sb.append("jndi_name=\"" + jndi_name + "\"" + "\t");
            sb.append(">\n</connectiondef>");
            sb.append("\n</sqldef>");
        }
        sb.append("\n</sqlengine>");
        try {
            FileOutputStream fos = new FileOutputStream(this.engineFileName);
            FileUtil.copy(sb.toString().getBytes("UTF-8"), (OutputStream)fos);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void indentWSDLFile(Writer writer, Document doc) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            PrintWriter pw = new PrintWriter(writer);
            StreamResult result = new StreamResult(pw);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
            }
            catch (Exception e) {
                // empty catch block
            }
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

