/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.Util;

public class TreeNamedObjectMap
extends TreeObjectList {
    private Map map;
    private KeyListener keyListener;

    protected TreeNamedObjectMap(ContentManager contentManager) {
        super(contentManager);
        this.map = null;
        this.keyListener = null;
    }

    protected TreeNamedObjectMap(TreeNamedObjectMap treeNamedObjectMap) {
        super(treeNamedObjectMap);
    }

    private KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyListener();
        }
        return this.keyListener;
    }

    private Map getMap() {
        if (this.map == null) {
            this.map = new HashMap(3);
        }
        return this.map;
    }

    private void mapClear() {
        Iterator iterator = this.getMap().values().iterator();
        while (iterator.hasNext()) {
            NamedObject namedObject = (NamedObject)iterator.next();
            namedObject.setKeyListener(null);
        }
        this.getMap().clear();
    }

    private Object mapPut(NamedObject namedObject) {
        NamedObject namedObject2 = this.getMap().put(namedObject.mapKey(), namedObject);
        namedObject.setKeyListener(this.getKeyListener());
        return namedObject2;
    }

    private Object mapRemove(NamedObject namedObject) {
        Object v = this.getMap().remove(namedObject.mapKey());
        namedObject.setKeyListener(null);
        return v;
    }

    public Object clone() {
        return new TreeNamedObjectMap(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeNamedObjectMap treeNamedObjectMap = (TreeNamedObjectMap)object;
        if (this.getMap().size() != treeNamedObjectMap.getMap().size()) {
            return false;
        }
        Iterator iterator = this.getMap().keySet().iterator();
        Iterator iterator2 = treeNamedObjectMap.getMap().keySet().iterator();
        while (iterator.hasNext()) {
            Object k;
            Object k2 = iterator.next();
            if (!Util.equals(k2, k = iterator2.next())) {
                return false;
            }
            if (Util.equals(this.getMap().get(k2), treeNamedObjectMap.getMap().get(k))) continue;
            return false;
        }
        return true;
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        this.mapClear();
        super.merge(treeObject);
    }

    protected int findMergeCandidate(TreeObject treeObject, TreeObject[] treeObjectArray) {
        if (!(treeObject instanceof NamedObject)) {
            return -1;
        }
        for (int i = 0; i < treeObjectArray.length; ++i) {
            TreeObject treeObject2 = treeObjectArray[i];
            if (treeObject2 == null || !(treeObject2 instanceof NamedObject)) continue;
            Object object = ((NamedObject)((Object)treeObject2)).mapKey();
            Object object2 = ((NamedObject)((Object)treeObject)).mapKey();
            if (object2 == null || !object2.equals(object)) continue;
            return i;
        }
        return -1;
    }

    public final Object get(Object object) {
        return this.getMap().get(object);
    }

    protected boolean removeImpl(Object object) throws ClassCastException {
        boolean bl = super.removeImpl(object);
        if (bl) {
            this.mapRemove((NamedObject)object);
        }
        return bl;
    }

    protected Object setImpl(int n, Object object) throws ClassCastException {
        Object object2 = super.setImpl(n, object);
        this.mapRemove((NamedObject)object2);
        this.mapPut((NamedObject)object);
        return object2;
    }

    protected Object removeImpl(int n) {
        Object object = super.removeImpl(n);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeNamedObjectMap::removeImpl [ " + n + " ] = " + object);
        }
        if (object != null) {
            this.mapRemove((NamedObject)object);
        }
        return object;
    }

    protected void addImpl(int n, Object object) throws ClassCastException {
        Object v = this.getMap().get(((NamedObject)object).mapKey());
        if (v != null) {
            this.remove(v);
        }
        super.addImpl(n, object);
        this.mapPut((NamedObject)object);
    }

    protected boolean addImpl(Object object) throws ClassCastException {
        boolean bl;
        Object v = this.getMap().get(((NamedObject)object).mapKey());
        if (v != null) {
            this.remove(v);
        }
        if (bl = super.addImpl(object)) {
            this.mapPut((NamedObject)object);
        }
        return bl;
    }

    private void keyChanged(Object object) {
        Object v = this.getMap().remove(object);
        Object object2 = ((NamedObject)v).mapKey();
        Object v2 = this.getMap().get(object2);
        if (v2 != null) {
            this.remove(v2);
        }
        this.getMap().put(object2, v);
    }

    public class KeyListener {
        private KeyListener() {
        }

        public void mapKeyChanged(Object object) {
            TreeNamedObjectMap.this.keyChanged(object);
        }
    }

    protected static abstract class ContentManager
    extends TreeObjectList.ContentManager {
        protected ContentManager() {
        }

        public void checkAssignableObject(Object object) throws ClassCastException {
            super.checkAssignableObject(object);
            if (!(object instanceof NamedObject)) {
                String string = Util.THIS.getString("EXC_instance_of_NamedObject");
                throw new ClassCastException(string);
            }
        }
    }

    public static interface NamedObject {
        public Object mapKey();

        public void setKeyListener(KeyListener var1);
    }
}

