/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.openide.util.NbBundle;

class ClassLoaderManager {
    private static final String AM_SYSTEM_PROPERTIES_CLASS = "com.iplanet.am.util.SystemProperties";
    private static final String AM_INITIALIZE_PROPERTIES_METHOD = "initializeProperties";
    private static String[] dependentJars = new String[]{"/addons/accessmanager/amclientsdk.jar", "/lib/javaee.jar", "/lib/webservices-rt.jar"};
    private static ClassLoaderManager instance;
    private Map<String, AMClientSDKClassLoader> classLoaderCache = new HashMap<String, AMClientSDKClassLoader>();

    private ClassLoaderManager() {
    }

    public static ClassLoaderManager getDefault() {
        if (instance == null) {
            instance = new ClassLoaderManager();
        }
        return instance;
    }

    public ClassLoader getClassLoader(ServerProperties serverProperties) {
        String string = serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id");
        AMClientSDKClassLoader aMClientSDKClassLoader = this.classLoaderCache.get(string);
        if (aMClientSDKClassLoader != null && !serverProperties.equals(aMClientSDKClassLoader.getProperties())) {
            aMClientSDKClassLoader = null;
        }
        if (aMClientSDKClassLoader == null) {
            aMClientSDKClassLoader = this.createClassLoader(serverProperties);
            this.classLoaderCache.put(string, aMClientSDKClassLoader);
        }
        return aMClientSDKClassLoader;
    }

    public void removeClassLoader(ServerProperties serverProperties) {
        this.classLoaderCache.remove(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
    }

    private AMClientSDKClassLoader createClassLoader(ServerProperties serverProperties) {
        String string = serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.asroot");
        if (string != null) {
            URL[] uRLArray = new URL[dependentJars.length];
            for (int i = 0; i < dependentJars.length; ++i) {
                File file = new File(string + dependentJars[i]);
                try {
                    URL uRL;
                    uRLArray[i] = uRL = file.toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return new AMClientSDKClassLoader(uRLArray, serverProperties);
        }
        return new AMClientSDKClassLoader(new URL[0], ClassLoaderManager.class.getClassLoader(), serverProperties);
    }

    private static class AMClientSDKClassLoader
    extends URLClassLoader {
        private ServerProperties properties;

        public AMClientSDKClassLoader(URL[] uRLArray, ServerProperties serverProperties) {
            super(uRLArray);
            this.init(serverProperties);
        }

        public AMClientSDKClassLoader(URL[] uRLArray, ClassLoader classLoader, ServerProperties serverProperties) {
            super(uRLArray, classLoader);
            this.init(serverProperties);
        }

        private void init(ServerProperties serverProperties) {
            this.properties = (ServerProperties)serverProperties.clone();
            try {
                Class<?> clazz = this.loadClass(ClassLoaderManager.AM_SYSTEM_PROPERTIES_CLASS);
                Method method = clazz.getMethod(ClassLoaderManager.AM_INITIALIZE_PROPERTIES_METHOD, Properties.class);
                method.invoke(null, serverProperties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfiguratorException(NbBundle.getMessage(ClassLoaderManager.class, (String)"TXT_FailedToLoadAMClientSDK"));
            }
            catch (Exception exception) {
                throw ConfiguratorException.create(exception);
            }
        }

        public ServerProperties getProperties() {
            return this.properties;
        }
    }
}

