/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.openide.util.NbBundle;

public class ServerProperties
extends Properties
implements Cloneable {
    public static final String PROP_ID = "org.netbeans.modules.identity.profile.api.configurator.id";
    public static final String PROP_HOST = "com.iplanet.am.server.host";
    public static final String PROP_PORT = "com.iplanet.am.server.port";
    public static final String PROP_CONTEXT_ROOT = "org.netbeans.modules.identity.profile.api.configurator.contextroot";
    public static final String PROP_USERNAME = "com.sun.identity.agents.app.username";
    public static final String PROP_PASSWORD = "com.iplanet.am.service.password";
    private static final String PROP_PROTOCOL = "com.iplanet.am.server.protocol";
    public static final String PROP_AM_CONFIG_FILE = "org.netbeans.modules.identity.profile.api.configurator.amconfigfile";
    public static final String PROP_AM_CONSOLE_URL = "org.netbeans.modules.identity.profile.api.configurator.amconsoleurl";
    private static final String PROP_NAMING_SERVICE_URL = "com.iplanet.am.naming.url";
    public static final String PROP_IS_ALIVE_URL = "org.netbeans.modules.identity.profile.api.configurator.isaliveurl";
    public static final String PROP_LIBERTY_DISCO_SERVICE_URL = "org.netbeans.modules.identity.profile.api.configurator.libertydiscoserviceurl";
    public static final String PROP_AS_ROOT = "org.netbeans.modules.identity.profile.api.configurator.asroot";
    private static final String NAMING_SERVICE = "/namingservice";
    private static final String IS_ALIVE_JSP = "/isAlive.jsp";
    private static final String LIBERTY_DISCO_SERVICE = "/Liberty/disco";
    private static final String AM_CONFIG_FILE = "/domains/domain1/config/AMConfig.properties";
    private static HashMap<String, ServerProperties> instanceMap = new HashMap();

    public static synchronized ServerProperties getInstance(String string) {
        ServerProperties serverProperties = instanceMap.get(string);
        if (serverProperties == null) {
            serverProperties = new ServerProperties(string);
            instanceMap.put(string, serverProperties);
        }
        return serverProperties;
    }

    private ServerProperties(String string) throws ConfiguratorException {
        this.init(string);
    }

    private void init(String string) {
        String string2 = string.substring(1, string.indexOf(93));
        String string3 = string2 + AM_CONFIG_FILE;
        String[] stringArray = string.substring(string.indexOf(93) + 1).split(":");
        String string4 = stringArray[4];
        try {
            this.load(new FileInputStream(string3.trim()));
            this.setProperty(PROP_AM_CONFIG_FILE, string3);
            this.setProperty(PROP_AS_ROOT, string2);
            this.setProperty(PROP_ID, string);
            this.setProperty(PROP_CONTEXT_ROOT, this.getContextRoot());
            this.setProperty(PROP_HOST, string4);
            this.updateURLs();
        }
        catch (Exception exception) {
            throw new ConfiguratorException(NbBundle.getMessage(ServerProperties.class, (String)"TXT_InvalidAMConfigFile"));
        }
    }

    public Object setProperty(String string, String string2) {
        Object object = super.setProperty(string, string2);
        this.updateInternalProperties(string);
        return object;
    }

    private void updateInternalProperties(String string) {
        if (string.equals(PROP_PORT) || string.equals(PROP_HOST) || string.equals(PROP_PROTOCOL) || string.equals(PROP_CONTEXT_ROOT)) {
            this.updateURLs();
        } else if (string.equals(PROP_USERNAME) || string.equals(PROP_PASSWORD)) {
            // empty if block
        }
    }

    private void updateURLs() {
        String string = this.getProperty(PROP_PORT);
        String string2 = this.getProperty(PROP_HOST);
        String string3 = this.getProperty(PROP_PROTOCOL);
        String string4 = this.getProperty(PROP_CONTEXT_ROOT);
        String string5 = string3 + "://" + string2 + ":" + string + "/" + string4;
        String string6 = string5 + NAMING_SERVICE;
        String string7 = string5 + IS_ALIVE_JSP;
        String string8 = string5 + LIBERTY_DISCO_SERVICE;
        this.setProperty(PROP_AM_CONSOLE_URL, string5);
        this.setProperty(PROP_NAMING_SERVICE_URL, string6);
        this.setProperty(PROP_IS_ALIVE_URL, string7);
        this.setProperty(PROP_LIBERTY_DISCO_SERVICE_URL, string8);
    }

    private String getContextRoot() {
        String string = this.getProperty(PROP_NAMING_SERVICE_URL);
        String string2 = string.substring(0, string.length() - NAMING_SERVICE.length());
        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
        return string3;
    }

    public boolean equals(Object object) {
        if (object instanceof ServerProperties) {
            ServerProperties serverProperties = (ServerProperties)object;
            if (!this.getProperty(PROP_HOST).equals(serverProperties.getProperty(PROP_HOST))) {
                return false;
            }
            if (!this.getProperty(PROP_PORT).equals(serverProperties.getProperty(PROP_PORT))) {
                return false;
            }
            if (!this.getProperty(PROP_USERNAME).equals(serverProperties.getProperty(PROP_USERNAME))) {
                return false;
            }
            if (!this.getProperty(PROP_PASSWORD).equals(serverProperties.getProperty(PROP_PASSWORD))) {
                return false;
            }
            return this.getProperty(PROP_CONTEXT_ROOT).equals(serverProperties.getProperty(PROP_CONTEXT_ROOT));
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        String string = null;
        string = this.getProperty(PROP_HOST);
        if (string != null) {
            n += string.hashCode();
        }
        if ((string = this.getProperty(PROP_PORT)) != null) {
            n += string.hashCode();
        }
        if ((string = this.getProperty(PROP_USERNAME)) != null) {
            n += string.hashCode();
        }
        if ((string = this.getProperty(PROP_PASSWORD)) != null) {
            n += string.hashCode();
        }
        if ((string = this.getProperty(PROP_CONTEXT_ROOT)) != null) {
            n += string.hashCode();
        }
        return n;
    }

    public Object clone() {
        Object object = super.clone();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((ServerProperties)object).setProperty(string, this.getProperty(string));
        }
        return object;
    }

    public String toString() {
        return this.getProperty(PROP_ID) + " (" + this.getProperty(PROP_HOST) + ":" + this.getProperty(PROP_PORT) + ")";
    }
}

