/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorBeanTreeView;
import org.netbeans.modules.vmd.inspector.InspectorFolderNode;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InspectorUI
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener,
Presenter.Popup {
    static final String INSPECTOR_UI_ID = "InspectorUI";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private volatile transient boolean lockSelectionSetting = false;
    private transient BeanTreeView inspectorBeanTreeView;
    private transient WeakReference<DesignDocument> document;

    InspectorUI(DesignDocument designDocument) {
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initComponents();
        this.lockSelectionSetting = false;
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        this.document = new WeakReference<DesignDocument>(designDocument);
    }

    private void initComponents() {
        this.inspectorBeanTreeView = new InspectorBeanTreeView(this.explorerManager);
        this.inspectorBeanTreeView.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.inspectorBeanTreeView, "Center");
        this.setBackground(Color.WHITE);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (this.explorerManager.getSelectedNodes().length < 1) {
            return;
        }
        if (this.document == null || this.document.get() == null) {
            return;
        }
        final DesignDocument designDocument = (DesignDocument)this.document.get();
        if (designDocument.getTransactionManager().isAccess()) {
            return;
        }
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (InspectorUI.this.lockSelectionSetting) {
                    return;
                }
                try {
                    InspectorUI.this.lockSelectionSetting = true;
                    Node[] nodeArray = InspectorUI.this.explorerManager.getSelectedNodes();
                    WeakSet weakSet = new WeakSet();
                    for (Node node : nodeArray) {
                        DesignComponent designComponent;
                        if (!(node instanceof InspectorFolderNode)) continue;
                        Long l = ((InspectorFolderNode)node).getComponentID();
                        DesignComponent designComponent2 = designComponent = l == null ? null : designDocument.getComponentByUID(l.longValue());
                        if (designComponent == null) continue;
                        weakSet.add((Object)designComponent);
                    }
                    designDocument.setSelectedComponents(InspectorUI.INSPECTOR_UI_ID, (Collection)weakSet);
                }
                finally {
                    InspectorUI.this.lockSelectionSetting = false;
                }
            }
        });
    }

    void expandNodes(Collection<InspectorFolderWrapper> collection) {
        if (collection == null) {
            return;
        }
        for (InspectorFolderWrapper inspectorFolderWrapper : collection) {
            InspectorFolderNode inspectorFolderNode = inspectorFolderWrapper.getNode();
            if (inspectorFolderNode == null) continue;
            this.inspectorBeanTreeView.expandNode((Node)inspectorFolderNode);
        }
    }

    synchronized void setRootNode(Node node) {
        this.getExplorerManager().setRootContext(node);
        this.revalidate();
        this.repaint();
    }

    public void activeComponentsChanged(Collection<DesignComponent> collection) {
    }

    public Action[] getActions() {
        return new Action[0];
    }

    public JMenuItem getPopupPresenter() {
        return new JMenu("menu");
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
    }
}

