/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.inspector.FolderRegistry;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GlobalFolderRegistry {
    private static final String FILE_SYSTEM_FOLDER_NAME = "/inspectorfolders";
    private static final HashMap<String, WeakReference<GlobalFolderRegistry>> registries = new HashMap();
    private final DataFolder registryFolders;
    private final Mutex mutex = new Mutex();
    private HashMap<TypeID, InspectorFolder> descriptors = new HashMap();
    private FolderRegistry.Listener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GlobalFolderRegistry getGlobalFolderRegistry(String string) {
        assert (Debug.isFriend(FolderRegistry.class));
        HashMap<String, WeakReference<GlobalFolderRegistry>> hashMap = registries;
        synchronized (hashMap) {
            GlobalFolderRegistry globalFolderRegistry;
            WeakReference<GlobalFolderRegistry> weakReference = registries.get(string);
            GlobalFolderRegistry globalFolderRegistry2 = globalFolderRegistry = weakReference != null ? (GlobalFolderRegistry)weakReference.get() : null;
            if (globalFolderRegistry == null) {
                globalFolderRegistry = new GlobalFolderRegistry(string);
                registries.put(string, new WeakReference<GlobalFolderRegistry>(globalFolderRegistry));
            }
            return globalFolderRegistry;
        }
    }

    private GlobalFolderRegistry(String string) {
        assert (string != null && string.length() > 0);
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string + FILE_SYSTEM_FOLDER_NAME);
        if (fileObject != null) {
            this.registryFolders = DataFolder.findFolder((FileObject)fileObject);
            this.registryFolders.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }
            });
        } else {
            this.registryFolders = null;
        }
        this.reload();
    }

    private void reloadAll() {
        this.reload();
        this.listener.notifyRegistryContentChange();
    }

    void readAccess(Runnable runnable) {
        assert (Debug.isFriend(FolderRegistry.class));
        this.mutex.readAccess(runnable);
    }

    private void reload() {
        this.mutex.writeAccess(new Runnable(){

            public void run() {
                GlobalFolderRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, InspectorFolder> hashMap = new HashMap<TypeID, InspectorFolder>();
        if (this.registryFolders != null) {
            Enumeration enumeration = this.registryFolders.children();
            while (enumeration.hasMoreElements()) {
                Object object = (DataObject)enumeration.nextElement();
                InspectorFolder inspectorFolder = GlobalFolderRegistry.dao2descriptor(object);
                if (inspectorFolder == null) {
                    Debug.warning((Object[])new Object[]{"No descriptor", object.getPrimaryFile().getNameExt()});
                    continue;
                }
                TypeID typeID = inspectorFolder.getTypeID();
                if (typeID == null) {
                    Debug.warning((Object[])new Object[]{"Null type descriptor", inspectorFolder});
                    continue;
                }
                TypeID typeID2 = inspectorFolder.getTypeID();
                if (hashMap.containsKey(typeID2)) {
                    Debug.warning((Object[])new Object[]{"Duplicate descriptor", typeID2});
                    continue;
                }
                hashMap.put(typeID2, inspectorFolder);
            }
        }
        for (Object object : hashMap.values()) {
            GlobalFolderRegistry.resolveDescriptor((InspectorFolder)object);
        }
        this.descriptors = hashMap;
    }

    private static void resolveDescriptor(InspectorFolder inspectorFolder) {
        GlobalFolderRegistry.resolveDescriptor(new HashSet<TypeID>(), inspectorFolder);
    }

    private static void resolveDescriptor(HashSet<TypeID> hashSet, InspectorFolder inspectorFolder) {
        assert (Debug.isFriend(GlobalFolderRegistry.class) || Debug.isFriend(FolderRegistry.class));
        TypeID typeID = inspectorFolder.getTypeID();
        if (typeID == null) {
            Debug.warning((Object[])new Object[]{"Null Type", inspectorFolder});
            return;
        }
        hashSet.add(typeID);
    }

    private static InspectorFolder dao2descriptor(DataObject dataObject) {
        InstanceCookie.Of of = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (of != null) {
            try {
                Object object = of.instanceCreate();
                if (object instanceof InspectorFolder) {
                    return (InspectorFolder)object;
                }
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.warning((Object[])new Object[]{classNotFoundException});
            }
            Debug.warning((Object[])new Object[]{"Instance is not InspectorFolder class"});
            return null;
        }
        return null;
    }

    Collection<InspectorFolder> getInspectorFolder() {
        assert (Debug.isFriend(FolderRegistry.class));
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    void addListener(FolderRegistry.Listener listener) {
        this.listener = listener;
    }

    void removeListener(FolderRegistry.Listener listener) {
        if (this.listener != listener) {
            Debug.warning((Object[])new Object[]{"Listener to remove != registred listener"});
        }
        listener = null;
    }
}

