/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.inspector.GlobalFolderRegistry;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FolderRegistry {
    private static final HashMap<String, WeakReference<FolderRegistry>> registries = new HashMap();
    private Mutex mutex = new Mutex();
    private HashMap<TypeID, InspectorFolder> folders = new HashMap();
    private GlobalFolderRegistry globalFolderRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FolderRegistry getRegistry(String string, String string2) {
        HashMap<String, WeakReference<FolderRegistry>> hashMap = registries;
        synchronized (hashMap) {
            FolderRegistry folderRegistry;
            WeakReference<FolderRegistry> weakReference = registries.get(string2);
            FolderRegistry folderRegistry2 = folderRegistry = weakReference != null ? (FolderRegistry)weakReference.get() : null;
            if (folderRegistry == null) {
                folderRegistry = new FolderRegistry(string);
                registries.put(string2, new WeakReference<FolderRegistry>(folderRegistry));
            }
            return folderRegistry;
        }
    }

    private FolderRegistry(String string) {
        this.globalFolderRegistry = GlobalFolderRegistry.getGlobalFolderRegistry(string);
        this.reload();
    }

    private boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    void readAccess(final Runnable runnable) {
        this.globalFolderRegistry.readAccess(new Runnable(){

            public void run() {
                FolderRegistry.this.mutex.readAccess(runnable);
            }
        });
    }

    private void writeAccess(final Runnable runnable) {
        this.globalFolderRegistry.readAccess(new Runnable(){

            public void run() {
                FolderRegistry.this.mutex.writeAccess(runnable);
            }
        });
    }

    private void reload() {
        this.writeAccess(new Runnable(){

            public void run() {
                FolderRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, InspectorFolder> hashMap = new HashMap<TypeID, InspectorFolder>();
        Collection<InspectorFolder> collection = this.globalFolderRegistry.getInspectorFolder();
        for (InspectorFolder inspectorFolder : collection) {
            hashMap.put(inspectorFolder.getTypeID(), inspectorFolder);
        }
        this.folders = hashMap;
    }

    Collection<InspectorFolder> getFolders() {
        assert (this.isAccess());
        return Collections.unmodifiableCollection(this.folders.values());
    }

    void addListener(Listener listener) {
        this.globalFolderRegistry.addListener(listener);
    }

    void removeListener(Listener listener) {
        this.globalFolderRegistry.removeListener(listener);
    }

    static interface Listener {
        public void notifyRegistryContentChange();
    }
}

