/*
 * Decompiled with CFR 0.152.
 */
package ricoh.ant.ssh;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import ricoh.ant.LoggingTask;
import ricoh.ant.ssh.LoginInfo;

public class FetchSSHPublicKey
extends LoggingTask {
    private String host;
    private String username;
    private LoginInfo ui;
    private int port;
    private boolean trustGranted;
    private boolean debugOn;
    private String knownHostsPath;
    public static final int DEFAULT_SSH_PORT = 22;
    public static final String KNOWN_HOSTS_DEFAULT_WINDOWS = "c:\\ssh\\known_hosts";
    public static final String KNOWN_HOSTS_DEFAULT_UNIX = "~/.ssh/known_hosts";
    private static final String DEBUG_ON_PROPNAME = "ricoh.ant.debugOn";

    public void initialize() {
        this.port = 22;
        this.knownHostsPath = System.getProperty("os.name").contains("windows") || System.getProperty("os.name").contains("Windows") ? KNOWN_HOSTS_DEFAULT_WINDOWS : KNOWN_HOSTS_DEFAULT_UNIX;
        this.username = "anonymous";
        this.ui = new LoginInfo();
        this.ui.setPassword("");
        this.host = "localhost";
        this.trustGranted = false;
        this.debugOn = this.getProject().getProperty(DEBUG_ON_PROPNAME).equals("true");
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.ui.setPassword(password);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setKnownHosts(String filepath) {
        this.knownHostsPath = filepath;
    }

    public void setPort(String port) throws BuildException {
        if (port == null || port.trim().equals("")) {
            this.port = 22;
        } else {
            int numericPort;
            try {
                numericPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                if (this.debugOn) {
                    nfe.printStackTrace();
                }
                throw new BuildException("Bad format for entered SSH port: " + port);
            }
            this.setPort(numericPort);
        }
    }

    private void setPort(int port) {
        this.port = port > 0 ? port : 22;
    }

    public void setTrust(boolean isUnknownTrusted) {
        this.trustGranted = isUnknownTrusted;
    }

    public void execute() throws BuildException {
        if (this.knownHostsPath.contains("@")) {
            String prefix = this.knownHostsPath.substring(0, this.knownHostsPath.indexOf("@"));
            if (prefix.contains(":")) {
                this.username = prefix.substring(0, prefix.indexOf(":"));
                this.ui.setPassword(prefix.substring(prefix.indexOf(":"), prefix.length()));
            } else {
                this.username = this.knownHostsPath.substring(0, this.knownHostsPath.indexOf("@"));
            }
        }
        File knownHosts = new File(this.knownHostsPath);
        JSch jsch = new JSch();
        boolean isExist = knownHosts.exists();
        try {
            if (isExist) {
                this.log("Found known_hosts file: " + knownHosts.getPath(), Level.FINE.intValue());
                jsch.setKnownHosts(this.knownHostsPath);
            } else {
                this.log("New known_hosts file created at: " + knownHosts.getPath(), Level.FINE.intValue());
                knownHosts.createNewFile();
                jsch.setKnownHosts(this.knownHostsPath);
            }
        }
        catch (IOException ioe) {
            String msg = "There was an error in reading or writing to the file. Check the provided path to the known_hosts file and try again";
            if (this.debugOn) {
                ioe.printStackTrace();
            }
            throw new BuildException(msg);
        }
        catch (JSchException jse) {
            if (this.debugOn) {
                jse.printStackTrace();
            }
            throw new BuildException("SSH or Network Error: " + jse.getMessage());
        }
        HostKeyRepository repository = jsch.getHostKeyRepository();
        HostKey[] keyArray = repository.getHostKey();
        boolean matchFound = false;
        if (isExist) {
            this.log("Checking keys...", Level.FINEST.intValue());
        }
        String tempFingerprint = null;
        if (keyArray != null) {
            this.log("Keys found in " + repository.getKnownHostsRepositoryID(), Level.INFO.intValue());
            for (int i = 0; i < keyArray.length || !matchFound; ++i) {
                HostKey matchKey = keyArray[i];
                String tempHost = matchKey.getHost();
                String tempType = matchKey.getType();
                tempFingerprint = matchKey.getFingerPrint(jsch);
                System.out.println(tempHost + " " + tempType + " " + tempFingerprint);
                if (!tempHost.equals(this.host)) continue;
                this.log("Matching key found.", Level.FINER.intValue());
                matchFound = true;
            }
        } else {
            this.log("No keys found.", Level.FINE.intValue());
        }
        if (!matchFound && !this.trustGranted) {
            throw new BuildException("Trust needs to be explicitly given to trust this unknown host:\nHost: " + this.host);
        }
        try {
            this.log("Connecting to: " + this.host + ":" + this.port, Level.INFO.intValue());
            this.log("As user:   " + this.username, Level.INFO.intValue());
            Session session = jsch.getSession(this.username, this.host, this.port);
            session.setUserInfo((UserInfo)this.ui);
            session.connect();
            if (tempFingerprint != null && !session.getHostKey().getFingerPrint(jsch).equals(tempFingerprint)) {
                throw new BuildException("The key retrieved from the server has changed. Contact the system admin to\nverify the new key's validity. Remove the key from the known_hosts file to\nlogin again with this tool\nNew key fingerprint: " + session.getHostKey().getFingerPrint(jsch));
            }
            if (!matchFound) {
                PrintWriter out = new PrintWriter(new FileWriter(this.knownHostsPath, true));
                out.println(this.host + " " + session.getHostKey().getType() + " " + session.getHostKey().getKey());
                this.log("Acquired key from " + this.host + " with fingerprint:\n" + session.getHostKey().getFingerPrint(jsch), Level.INFO);
            }
        }
        catch (JSchException jse) {
            if (this.debugOn) {
                jse.printStackTrace();
            }
            if (jse.getMessage().contains("HostKey") && jse.getMessage().contains("changed")) {
                throw new BuildException("The SSH key has changed and the connection was aborted.\nCheck the following key fingerprint with the system admin\nfor validity. A match may indicate your connection is being spoofed.\nFingerprint: " + tempFingerprint);
            }
            throw new BuildException("SSH or Network Error: " + jse.getMessage());
        }
        catch (IOException ioe) {
            String msg = "There was an error in reading or writing to the local file.\nCheck the provided path to the known_hosts file and try again";
            if (this.debugOn) {
                ioe.printStackTrace();
            }
            throw new BuildException(msg);
        }
    }
}

