/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.infrastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.hints.infrastructure.DisableHintFix;
import org.netbeans.modules.javascript.hints.infrastructure.PreviewHintFix;
import org.netbeans.modules.javascript.hints.infrastructure.RulesManager;
import org.netbeans.modules.javascript.hints.options.HintsSettings;
import org.netbeans.modules.javascript.hints.spi.AstRule;
import org.netbeans.modules.javascript.hints.spi.Description;
import org.netbeans.modules.javascript.hints.spi.ErrorRule;
import org.netbeans.modules.javascript.hints.spi.Fix;
import org.netbeans.modules.javascript.hints.spi.HintSeverity;
import org.netbeans.modules.javascript.hints.spi.PreviewableFix;
import org.netbeans.modules.javascript.hints.spi.Rule;
import org.netbeans.modules.javascript.hints.spi.RuleContext;
import org.netbeans.modules.javascript.hints.spi.SelectionRule;
import org.netbeans.modules.javascript.hints.spi.UserConfigurableRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHintsProvider
implements HintsProvider {
    private boolean cancelled;
    private Map<Integer, List<AstRule>> testHints;
    private Map<Integer, List<AstRule>> testSuggestions;
    private List<SelectionRule> testSelectionHints;
    private Map<String, List<ErrorRule>> testErrors;

    private boolean isTest() {
        return this.testHints != null || this.testSuggestions != null || this.testSelectionHints != null || this.testErrors != null;
    }

    public List<Error> computeErrors(CompilationInfo compilationInfo, List<ErrorDescription> list) {
        try {
            if (compilationInfo.getDocument() == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        Collection collection = compilationInfo.getEmbeddedResults("text/javascript");
        if (collection.size() == 0) {
            return Collections.emptyList();
        }
        assert (collection.size() == 1);
        ParserResult parserResult = (ParserResult)collection.iterator().next();
        List list2 = parserResult.getDiagnostics();
        if (list2 == null || list2.size() == 0) {
            return Collections.emptyList();
        }
        this.cancelled = false;
        Map<String, List<ErrorRule>> map = this.testErrors;
        if (map == null) {
            map = RulesManager.getInstance().getErrors();
        }
        if (map.isEmpty() || this.isCancelled()) {
            return list2;
        }
        ArrayList<Description> arrayList = new ArrayList<Description>();
        ArrayList<Error> arrayList2 = new ArrayList<Error>();
        for (Error object : list2) {
            if (this.applyRules(object, compilationInfo, map, arrayList)) continue;
            arrayList2.add(object);
        }
        if (arrayList.size() > 0) {
            for (Description description : arrayList) {
                ErrorDescription errorDescription = this.createDescription(description, compilationInfo, -1, true);
                list.add(errorDescription);
            }
        }
        return arrayList2;
    }

    public void computeSelectionHints(CompilationInfo compilationInfo, List<ErrorDescription> list, int n, int n2) {
        try {
            if (compilationInfo.getDocument() == null) {
                return;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.cancelled = false;
        Node node = AstUtilities.getRoot((CompilationInfo)compilationInfo);
        if (node == null) {
            return;
        }
        List<SelectionRule> list2 = this.testSelectionHints;
        if (list2 == null) {
            list2 = RulesManager.getInstance().getSelectionHints();
        }
        if (list2.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ArrayList<Description> arrayList = new ArrayList<Description>();
        this.applyRules(compilationInfo, list2, n, n2, arrayList);
        if (arrayList.size() > 0) {
            for (Description description : arrayList) {
                ErrorDescription errorDescription = this.createDescription(description, compilationInfo, -1, false);
                list.add(errorDescription);
            }
        }
    }

    public void computeHints(CompilationInfo compilationInfo, List<ErrorDescription> list) {
        try {
            if (compilationInfo.getDocument() == null) {
                return;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.cancelled = false;
        Node node = AstUtilities.getRoot((CompilationInfo)compilationInfo);
        if (node == null) {
            return;
        }
        Map<Integer, List<AstRule>> map = this.testHints;
        if (map == null) {
            map = RulesManager.getInstance().getHints(false, compilationInfo);
        }
        if (map.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ArrayList<Description> arrayList = new ArrayList<Description>();
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.applyRules(-1, node, astPath, compilationInfo, map, -1, arrayList);
        this.scan(node, astPath, compilationInfo, map, -1, arrayList);
        astPath.ascend();
        if (arrayList.size() > 0) {
            for (Description description : arrayList) {
                ErrorDescription errorDescription = this.createDescription(description, compilationInfo, -1, false);
                list.add(errorDescription);
            }
        }
    }

    private ErrorDescription createDescription(Description description, CompilationInfo compilationInfo, int n, boolean bl) {
        List<Object> list;
        Rule rule = description.getRule();
        HintSeverity hintSeverity = rule instanceof UserConfigurableRule ? RulesManager.getInstance().getSeverity((UserConfigurableRule)rule) : rule.getDefaultSeverity();
        OffsetRange offsetRange = description.getRange();
        if (description.getFixes() != null && description.getFixes().size() > 0) {
            list = new ArrayList(description.getFixes().size());
            String string = Integer.toString(10000 + description.getPriority());
            for (Fix fix : description.getFixes()) {
                PreviewableFix previewableFix;
                list.add(new FixWrapper(fix, string));
                if (!(fix instanceof PreviewableFix) || !(previewableFix = (PreviewableFix)fix).canPreview() || this.isTest()) continue;
                list.add(new PreviewHintFix(compilationInfo, previewableFix, string));
            }
            if (rule instanceof UserConfigurableRule && !this.isTest()) {
                list.add(new DisableHintFix((UserConfigurableRule)rule, compilationInfo, n, string));
            }
        } else if (bl && rule instanceof UserConfigurableRule && !this.isTest()) {
            String string = Integer.toString(10000 + description.getPriority());
            list = Collections.singletonList(new DisableHintFix((UserConfigurableRule)rule, compilationInfo, n, string));
        } else {
            list = Collections.emptyList();
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)hintSeverity.toEditorSeverity(), (String)description.getDescription(), list, (FileObject)description.getFile(), (int)offsetRange.getStart(), (int)offsetRange.getEnd());
    }

    public void computeSuggestions(CompilationInfo compilationInfo, List<ErrorDescription> list, int n) {
        Object object;
        List<Object> list2;
        try {
            if (compilationInfo.getDocument() == null) {
                return;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.cancelled = false;
        Node node = AstUtilities.getRoot((CompilationInfo)compilationInfo);
        if (node == null) {
            return;
        }
        Map<Integer, List<AstRule>> map = this.testSuggestions;
        if (map == null) {
            map = new HashMap<Integer, List<AstRule>>();
            map.putAll(RulesManager.getInstance().getHints(true, compilationInfo));
            for (Map.Entry<Integer, List<AstRule>> object22 : RulesManager.getInstance().getSuggestions().entrySet()) {
                list2 = map.get(object22.getKey());
                if (list2 != null) {
                    object = new LinkedList();
                    object.addAll(list2);
                    object.addAll((Collection)object22.getValue());
                    map.put(object22.getKey(), (List<AstRule>)object);
                    continue;
                }
                map.put(object22.getKey(), object22.getValue());
            }
        }
        if (map.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        int n2 = AstUtilities.getAstOffset((CompilationInfo)compilationInfo, (int)n);
        AstPath astPath = new AstPath(node, n2);
        list2 = new ArrayList();
        object = astPath.leafToRoot();
        while (object.hasNext()) {
            if (this.isCancelled()) {
                return;
            }
            Node node2 = (Node)object.next();
            this.applyRules(node2.getType(), node2, astPath, compilationInfo, map, n, list2);
        }
        if (list2.size() > 0) {
            for (Description description : list2) {
                ErrorDescription errorDescription = this.createDescription(description, compilationInfo, n, false);
                list.add(errorDescription);
            }
        }
    }

    private void applyRules(int n, Node node, AstPath astPath, CompilationInfo compilationInfo, Map<Integer, List<AstRule>> map, int n2, List<Description> list) {
        List<AstRule> list2 = map.get(n);
        if (list2 != null) {
            RuleContext ruleContext = new RuleContext();
            ruleContext.compilationInfo = compilationInfo;
            try {
                ruleContext.doc = (BaseDocument)compilationInfo.getDocument();
                if (ruleContext.doc == null) {
                    return;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            ruleContext.node = node;
            ruleContext.path = astPath;
            ruleContext.caretOffset = n2;
            for (AstRule astRule : list2) {
                if (!HintsSettings.isEnabled(astRule)) continue;
                astRule.run(ruleContext, list);
            }
        }
    }

    private boolean applyRules(Error error, CompilationInfo compilationInfo, Map<String, List<ErrorRule>> map, List<Description> list) {
        List<ErrorRule> list2;
        String string = error.getKey();
        if (string != null && (list2 = map.get(string)) != null) {
            int n = list.size();
            RuleContext ruleContext = new RuleContext();
            ruleContext.compilationInfo = compilationInfo;
            try {
                ruleContext.doc = (BaseDocument)compilationInfo.getDocument();
                if (ruleContext.doc == null) {
                    return false;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            boolean bl = false;
            for (ErrorRule errorRule : list2) {
                if (!HintsSettings.isEnabled(errorRule)) {
                    bl = true;
                    continue;
                }
                if (!errorRule.appliesTo(compilationInfo)) continue;
                errorRule.run(ruleContext, error, list);
            }
            return bl || n < list.size() || ruleContext.remove;
        }
        return false;
    }

    private void applyRules(CompilationInfo compilationInfo, List<SelectionRule> list, int n, int n2, List<Description> list2) {
        RuleContext ruleContext = new RuleContext();
        ruleContext.compilationInfo = compilationInfo;
        ruleContext.selectionStart = n;
        ruleContext.selectionEnd = n2;
        try {
            ruleContext.doc = (BaseDocument)compilationInfo.getDocument();
            if (ruleContext.doc == null) {
                return;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        for (SelectionRule selectionRule : list) {
            if (!selectionRule.appliesTo(compilationInfo)) continue;
            selectionRule.run(ruleContext, list2);
        }
    }

    private void scan(Node node, AstPath astPath, CompilationInfo compilationInfo, Map<Integer, List<AstRule>> map, int n, List<Description> list) {
        this.applyRules(node.getType(), node, astPath, compilationInfo, map, n, list);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (this.isCancelled()) {
                return;
            }
            astPath.descend(node2);
            this.scan(node2, astPath, compilationInfo, map, n, list);
            astPath.ascend();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    public void setTestingHints(Map<Integer, List<AstRule>> map, Map<Integer, List<AstRule>> map2, Map<String, List<ErrorRule>> map3, List<SelectionRule> list) {
        this.testHints = map;
        this.testSuggestions = map2;
        this.testErrors = map3;
        this.testSelectionHints = list;
    }

    private static class FixWrapper
    implements EnhancedFix {
        private Fix fix;
        private String sortText;

        FixWrapper(Fix fix, String string) {
            this.fix = fix;
            this.sortText = string;
        }

        public String getText() {
            return this.fix.getDescription();
        }

        public ChangeInfo implement() throws Exception {
            this.fix.implement();
            return null;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }
    }
}

