/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.infrastructure;

import java.util.ArrayList;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.javascript.hints.infrastructure.JsHintsProvider;
import org.netbeans.modules.javascript.hints.infrastructure.RulesManager;
import org.netbeans.modules.javascript.hints.options.HintsAdvancedOption;
import org.netbeans.modules.javascript.hints.options.HintsSettings;
import org.netbeans.modules.javascript.hints.spi.UserConfigurableRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DisableHintFix
implements EnhancedFix {
    private final UserConfigurableRule rule;
    private final CompilationInfo info;
    private final int caretPos;
    private final String sortText;

    public DisableHintFix(UserConfigurableRule userConfigurableRule, CompilationInfo compilationInfo, int n, String string) {
        this.rule = userConfigurableRule;
        this.info = compilationInfo;
        this.caretPos = n;
        this.sortText = string;
    }

    public String getText() {
        return NbBundle.getMessage(HintsAdvancedOption.class, (String)"DisableHint");
    }

    public ChangeInfo implement() throws Exception {
        HintsSettings.setEnabled(RulesManager.getInstance().getPreferences(this.rule, null), false);
        DisableHintFix.refreshHints(this.info, this.caretPos);
        return null;
    }

    public static void refreshHints(CompilationInfo compilationInfo, int n) {
        JsHintsProvider jsHintsProvider = new JsHintsProvider();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (n == -1) {
            jsHintsProvider.computeHints(compilationInfo, arrayList);
            HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)"org.netbeans.modules.gsfret.hints.infrastructure.HintsTask", arrayList);
        } else {
            jsHintsProvider.computeSuggestions(compilationInfo, arrayList, n);
            HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)"org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask", arrayList);
        }
    }

    public CharSequence getSortText() {
        return this.sortText;
    }
}

