/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search.impl.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bpel.search.api.SearchException;
import org.netbeans.modules.bpel.search.api.SearchMatch;
import org.netbeans.modules.bpel.search.api.SearchOption;
import org.netbeans.modules.bpel.search.api.SearchTarget;
import org.netbeans.modules.bpel.search.impl.output.View;
import org.netbeans.modules.bpel.search.impl.ui.Field;
import org.netbeans.modules.bpel.search.impl.ui.Progress;
import org.netbeans.modules.bpel.search.spi.SearchEngine;
import org.netbeans.modules.soa.ui.util.UI;
import org.openide.DialogDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Search
extends UI.Dialog {
    private Field myName;
    private Object mySource;
    private JButton mySearchButton;
    private JCheckBox myMatchCase;
    private JCheckBox myPatternMatch;
    private JCheckBox myRegularExpression;
    private UI.MyComboBox myTarget;
    private SearchTarget[] myTargets;
    private SearchEngine mySearchEngine;
    private DialogDescriptor myDescriptor;
    private static final int TEXT_WIDTH = 200;
    private static final String ASTERISK = "*";

    public Component getUIComponent(List<SearchEngine> list, Object object, SearchTarget[] searchTargetArray) {
        this.mySource = object;
        this.myTargets = searchTargetArray;
        this.mySearchEngine = list.get(0);
        this.mySearchEngine.removeSearchListeners();
        this.mySearchEngine.addSearchListener(new View());
        this.mySearchEngine.addSearchListener(new Progress());
        this.show();
        Component component = this.getUIComponent();
        UI.a11y((Component)component, (String)this.i18n("ACS_Advanced_Search"));
        return component;
    }

    protected void updated() {
        UI.setItems((JComboBox)this.myTarget, (Object[])this.myTargets);
        this.myTarget.init();
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this.createTextPanel(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)UI.createSeparator((String)this.i18n("LBL_Options")), gridBagConstraints);
        jPanel.add((Component)this.createOptionPanel(), gridBagConstraints);
        return jPanel;
    }

    private JComponent createTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        JLabel jLabel = UI.createLabel((String)this.i18n("LBL_Name"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.myName = new Field(ASTERISK);
        UI.setWidth((JComponent)this.myName.getUIComponent(), (int)200);
        jLabel.setLabelFor(this.myName.getUIComponent());
        jPanel.add((Component)this.myName.getUIComponent(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        jLabel = UI.createLabel((String)this.i18n("LBL_Target"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.weightx = 1.0;
        this.myTarget = UI.createComboBox((Object[])this.myTargets);
        UI.a11y((Component)this.myTarget, (String)this.i18n("ACS_Target"));
        jLabel.setLabelFor((Component)this.myTarget);
        jPanel.add((Component)this.myTarget, gridBagConstraints);
        return jPanel;
    }

    private JComponent createOptionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        this.myMatchCase = UI.createCheckBox((Action)new UI.ButtonAction(this.i18n("LBL_Match_Case")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myMatchCase, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.myPatternMatch = UI.createCheckBox((Action)new UI.ButtonAction(this.i18n("LBL_Match_Pattern")){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.exclusion(Search.this.myPatternMatch, Search.this.myRegularExpression);
            }
        });
        this.myPatternMatch.setSelected(true);
        this.myPatternMatch.setEnabled(true);
        jPanel.add((Component)this.myPatternMatch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.myRegularExpression = UI.createCheckBox((Action)new UI.ButtonAction(this.i18n("LBL_Regular_Expression")){

            public void actionPerformed(ActionEvent actionEvent) {
                Search.this.exclusion(Search.this.myRegularExpression, Search.this.myPatternMatch);
            }
        });
        this.myRegularExpression.setSelected(false);
        this.myRegularExpression.setEnabled(false);
        jPanel.add((Component)this.myRegularExpression, gridBagConstraints);
        return jPanel;
    }

    private void exclusion(JCheckBox jCheckBox, JCheckBox jCheckBox2) {
        jCheckBox.setEnabled(!jCheckBox2.isSelected());
        if (jCheckBox2.isSelected()) {
            jCheckBox.setSelected(false);
        }
        jCheckBox2.setEnabled(!jCheckBox.isSelected());
        if (jCheckBox.isSelected()) {
            jCheckBox2.setSelected(false);
        }
    }

    private SearchMatch getMatch() {
        if (this.myPatternMatch.isSelected()) {
            return SearchMatch.PATTERN;
        }
        if (this.myRegularExpression.isSelected()) {
            return SearchMatch.REGULAR_EXPRESSION;
        }
        return null;
    }

    private void search() {
        this.myDescriptor.setClosingOptions(new Object[]{this.mySearchButton, DialogDescriptor.CANCEL_OPTION});
        SearchOption.Adapter adapter = new SearchOption.Adapter(this.myName.getText().trim(), this.mySource, (SearchTarget)this.myTarget.getSelectedItem(), this.getMatch(), this.myMatchCase.isSelected(), false);
        try {
            this.mySearchEngine.search(adapter);
        }
        catch (SearchException searchException) {
            this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            UI.printError((String)this.i18n("ERR_Pattern_Error", searchException.getMessage()));
        }
    }

    private void close() {
        this.myName.save();
        this.mySearchEngine = null;
        this.mySource = null;
    }

    protected DialogDescriptor createDescriptor() {
        Object[] objectArray = this.getButtons();
        this.myDescriptor = new DialogDescriptor((Object)UI.getResizable((JPanel)this.createPanel()), this.i18n("LBL_Advanced_Search"), true, objectArray, (Object)this.mySearchButton, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Search.this.mySearchButton == actionEvent.getSource()) {
                    Search.this.search();
                    Search.this.close();
                }
            }
        });
        return this.myDescriptor;
    }

    private Object[] getButtons() {
        this.mySearchButton = UI.createButton((Action)new UI.ButtonAction(this.i18n("LBL_Search"), this.i18n("TLT_Search")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        return new Object[]{this.mySearchButton, DialogDescriptor.CANCEL_OPTION};
    }
}

