/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search.impl.core;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.bpel.search.api.SearchManager;
import org.netbeans.modules.bpel.search.api.SearchTarget;
import org.netbeans.modules.bpel.search.impl.action.SearchAction;
import org.netbeans.modules.bpel.search.impl.ui.Find;
import org.netbeans.modules.bpel.search.impl.ui.Search;
import org.netbeans.modules.bpel.search.impl.util.Util;
import org.netbeans.modules.bpel.search.spi.SearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager
extends SearchManager {
    private Search mySearch;
    private List<SearchEngine> myEngines = Util.getInstances(SearchEngine.class);

    public Manager() {
        this.mySearch = new Search();
    }

    @Override
    public Component createSearch(Object object, SearchTarget[] searchTargetArray) {
        List<SearchEngine> list = this.getEngines(object);
        if (list.isEmpty()) {
            return null;
        }
        return this.mySearch.getUIComponent(list, object, searchTargetArray);
    }

    @Override
    public Component createFind(Object object, JComponent jComponent) {
        List<SearchEngine> list = this.getEngines(object);
        if (list.isEmpty()) {
            return null;
        }
        return new Find(list, object, jComponent);
    }

    @Override
    public Action getSearchAction() {
        return SearchAction.DEFAULT;
    }

    private List<SearchEngine> getEngines(Object object) {
        ArrayList<SearchEngine> arrayList = new ArrayList<SearchEngine>();
        for (SearchEngine searchEngine : this.myEngines) {
            if (!searchEngine.accepts(object)) continue;
            arrayList.add(searchEngine);
        }
        return arrayList;
    }
}

