/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search.impl.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.bpel.core.helper.api.CoreUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.search.api.SearchManager;
import org.netbeans.modules.bpel.search.api.SearchTarget;
import org.netbeans.modules.bpel.search.impl.action.Target;
import org.netbeans.modules.bpel.search.impl.ui.Search;
import org.netbeans.modules.bpel.search.impl.util.Util;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumnsView;
import org.netbeans.modules.xml.schema.ui.basic.SchemaTreeView;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public final class SearchAction
extends UI.IconAction {
    private Search mySearch;
    public static final Action DEFAULT = new SearchAction();

    public SearchAction() {
        this("LBL_Search_Action", "TLT_Search_Action", "search");
    }

    private SearchAction(String string, String string2, String string3) {
        super(UI.i18n(SearchAction.class, (String)string), UI.i18n(SearchAction.class, (String)string2), (Icon)UI.icon(Util.class, (String)string3));
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node node = this.getLastNode();
        Model model = this.getModel(node);
        SearchTarget[] searchTargetArray = this.getTargets(model);
        if (searchTargetArray == null) {
            return;
        }
        ShowCookie showCookie = this.getShowCookie(node);
        Object object = this.getView();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(model);
        arrayList.add(showCookie);
        arrayList.add(object);
        SearchManager.getDefault().createSearch(arrayList, searchTargetArray);
    }

    private ShowCookie getShowCookie(Node node) {
        DataObject dataObject = UI.getDataObject((Node)node);
        if (dataObject == null) {
            return null;
        }
        return (ShowCookie)dataObject.getCookie(ShowCookie.class);
    }

    private Object getView() {
        TopComponent topComponent = UI.getActivateTopComponent();
        SchemaTreeView schemaTreeView = this.getTreeView((Container)topComponent, "  ");
        if (schemaTreeView != null) {
            return schemaTreeView;
        }
        return this.getColumnView((Container)topComponent, "  ");
    }

    private SchemaTreeView getTreeView(Container container, String string) {
        Component[] componentArray;
        if (container instanceof SchemaTreeView) {
            return (SchemaTreeView)container;
        }
        for (Component component : componentArray = container.getComponents()) {
            SchemaTreeView schemaTreeView;
            if (!(component instanceof Container) || (schemaTreeView = this.getTreeView((Container)component, "    " + string)) == null) continue;
            return schemaTreeView;
        }
        return null;
    }

    private SchemaColumnsView getColumnView(Container container, String string) {
        Component[] componentArray;
        if (container instanceof SchemaColumnsView) {
            return (SchemaColumnsView)container;
        }
        for (Component component : componentArray = container.getComponents()) {
            SchemaColumnsView schemaColumnsView;
            if (!(component instanceof Container) || (schemaColumnsView = this.getColumnView((Container)component, "    " + string)) == null) continue;
            return schemaColumnsView;
        }
        return null;
    }

    private SearchTarget[] getTargets(Model model) {
        if (model instanceof BpelModel) {
            return Target.BPEL;
        }
        if (model instanceof WSDLModel) {
            return Target.WSDL;
        }
        if (model instanceof SchemaModel) {
            return Target.SCHEMA;
        }
        return null;
    }

    private Model getModel(Node node) {
        DataObject dataObject = UI.getDataObject((Node)node);
        if (dataObject == null) {
            return null;
        }
        BpelModel bpelModel = CoreUtil.getBpelModel((DataObject)dataObject);
        if (bpelModel != null) {
            return bpelModel;
        }
        ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
        if (modelCookie == null) {
            return null;
        }
        try {
            return modelCookie.getModel();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

