/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.bpel.project.PackageDisplayUtils;
import org.netbeans.modules.bpel.project.PackageViewSettings;
import org.netbeans.modules.bpel.project.ui.PackageRootNode;
import org.netbeans.modules.bpel.project.ui.PackageViewChildren;
import org.netbeans.modules.bpel.project.ui.TreeRootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class PackageView {
    private PackageView() {
    }

    public static Node createPackageView(SourceGroup sourceGroup) {
        return new RootNode(sourceGroup);
    }

    public static Node findPath(Node node, Object object) {
        PackageRootNode.PathFinder pathFinder = (PackageRootNode.PathFinder)node.getLookup().lookup(PackageRootNode.PathFinder.class);
        if (pathFinder != null) {
            return pathFinder.findPath(node, object);
        }
        TreeRootNode.PathFinder pathFinder2 = (TreeRootNode.PathFinder)node.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pathFinder2 != null) {
            return pathFinder2.findPath(node, object);
        }
        return null;
    }

    public static ComboBoxModel createListView(SourceGroup sourceGroup) {
        TreeSet treeSet = new TreeSet();
        PackageView.findNonExcludedPackages(treeSet, sourceGroup.getRootFolder(), sourceGroup);
        return new DefaultComboBoxModel(new Vector(treeSet));
    }

    static void findNonExcludedPackages(PackageViewChildren packageViewChildren, FileObject fileObject) {
        PackageView.findNonExcludedPackages(packageViewChildren, null, fileObject, null);
    }

    static void findNonExcludedPackages(Collection collection, FileObject fileObject, SourceGroup sourceGroup) {
        PackageView.findNonExcludedPackages(null, collection, fileObject, sourceGroup);
    }

    private static void findNonExcludedPackages(PackageViewChildren packageViewChildren, Collection collection, FileObject fileObject, SourceGroup sourceGroup) {
        assert (fileObject.isFolder()) : "Package view only accepts folders";
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            if (fileObjectArray[i].isFolder()) {
                PackageView.findNonExcludedPackages(packageViewChildren, collection, fileObjectArray[i], sourceGroup);
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 || !bl) {
            if (sourceGroup != null) {
                collection.add(new PackageItem(sourceGroup, fileObject, !bl2));
            } else {
                packageViewChildren.add(fileObject, !bl2);
            }
        }
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    private static final class PackageListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PackageItem) {
                PackageItem packageItem = (PackageItem)object;
                super.getListCellRendererComponent((JList<?>)jList, packageItem.getLabel(), n, bl, bl2);
                this.setIcon(packageItem.getIcon());
            } else {
                String string = (String)object;
                super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
            return this;
        }
    }

    static final class PackageItem
    implements Comparable {
        private static IdentityHashMap image2icon = new IdentityHashMap();
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;

        public PackageItem(SourceGroup sourceGroup, FileObject fileObject, boolean bl) {
            this.pkg = fileObject;
            this.empty = bl;
            String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
            assert (string != null) : "No " + fileObject + " in " + sourceGroup;
            this.pkgname = string.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return PackageDisplayUtils.getDisplayLabel(this.pkgname);
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Image image = PackageDisplayUtils.getIcon(this.pkg, this.pkgname, this.empty);
                this.icon = (Icon)image2icon.get(image);
                if (this.icon == null) {
                    this.icon = new ImageIcon(image);
                    image2icon.put(image, this.icon);
                }
            }
            return this.icon;
        }

        public int compareTo(Object object) {
            return this.pkgname.compareTo(((PackageItem)object).pkgname);
        }
    }

    private static final class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private SourceGroup sourceGroup;
        private PackageViewSettings settings;

        private RootNode(SourceGroup sourceGroup) {
            super(RootNode.getOriginalNode(sourceGroup, PackageViewSettings.getDefault()));
            this.sourceGroup = sourceGroup;
            this.settings = PackageViewSettings.getDefault();
            PackageViewSettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.settings));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("packageViewType".equals(propertyChangeEvent.getPropertyName())) {
                this.changeOriginal(RootNode.getOriginalNode(this.sourceGroup, this.settings), true);
            }
        }

        private static Node getOriginalNode(SourceGroup sourceGroup, PackageViewSettings packageViewSettings) {
            assert (packageViewSettings != null) : "PackageViewSettings can't be null";
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            switch (packageViewSettings.getPackageViewType()) {
                case 0: {
                    return new PackageRootNode(sourceGroup);
                }
                case 1: {
                    return new TreeRootNode(sourceGroup);
                }
            }
            assert (false) : "Unknown PackageView Type";
            return new PackageRootNode(sourceGroup);
        }
    }
}

