/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.bpel.project.BpelProjectRetriever;
import org.netbeans.modules.bpel.project.BpelproProject;
import org.netbeans.modules.compapp.projects.base.ui.customizer.IcanproProjectProperties;
import org.netbeans.modules.compapp.projects.base.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.IOProvider;
import org.openide.windows.OutputWriter;

class BpelproActionProvider
implements ActionProvider {
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "delete", "delete", "copy", "move", "rename"};
    BpelproProject project;
    private AntProjectHelper antProjectHelper;
    private ReferenceHelper refHelper;
    Map commands = new HashMap();

    public BpelproActionProvider(BpelproProject bpelproProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.commands.put("build", new String[]{"dist_se"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist_se"});
        this.antProjectHelper = antProjectHelper;
        this.project = bpelproProject;
        this.refHelper = referenceHelper;
    }

    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String[] stringArray = (String[])this.commands.get(string);
        return stringArray;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject(this.project.getBuildXmlName());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if (string.equals("populate_catalog")) {
            BpelProjectRetriever bpelProjectRetriever = new BpelProjectRetriever(this.project.getProjectDirectory());
            bpelProjectRetriever.execute();
            return;
        }
        Properties properties = null;
        String[] stringArray = (String[])this.commands.get(string);
        if (string.equals("build")) {
            try {
                this.buildDependentProjectsAndRunTask(stringArray, properties);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        } else {
            this.runTask(stringArray, properties);
        }
    }

    private void runTask(String[] stringArray, Properties properties) {
        try {
            ActionUtils.runTarget((FileObject)this.findBuildXml(), (String[])stringArray, (Properties)properties);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void buildDependentProjectsAndRunTask(String[] stringArray, Properties properties) throws IOException {
        String string;
        Object object;
        IcanproProjectProperties icanproProjectProperties = this.project.getProjectProperties();
        List list = (List)icanproProjectProperties.get("javac.classpath");
        ArrayList<AntArtifact> arrayList = new ArrayList<AntArtifact>();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                VisualClassPathItem visualClassPathItem = (VisualClassPathItem)list.get(i);
                object = (AntArtifact)visualClassPathItem.getObject();
                string = object.getProject().getProjectDirectory().getPath() + "/" + object.getArtifactLocations()[0].getPath();
                File file = new File(string);
                this.log("Dependent Project artifact jar: " + string + ", [" + (file.exists() ? "exist" : "missing") + "]");
                if (file.exists()) continue;
                arrayList.add((AntArtifact)object);
            }
        }
        if (arrayList.size() != 0) {
            AntTaskListener antTaskListener = new AntTaskListener(stringArray, properties);
            antTaskListener.setTotalTasks(arrayList.size());
            for (AntArtifact antArtifact : arrayList) {
                object = antArtifact.getProject().getProjectDirectory().getPath() + "/" + antArtifact.getArtifactLocations()[0].getPath();
                this.log("Building dependent project " + (String)object + "...");
                string = ActionUtils.runTarget((FileObject)antArtifact.getScriptFile(), (String[])new String[]{antArtifact.getTargetName()}, null);
                string.addTaskListener((TaskListener)antTaskListener);
            }
        } else {
            this.runTask(stringArray, properties);
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return this.findBuildXml() != null;
    }

    private boolean isDebugged() {
        return false;
    }

    private void log(String string) {
        OutputWriter outputWriter = IOProvider.getDefault().getStdOut();
        outputWriter.println(string);
        outputWriter.flush();
    }

    class AntTaskListener
    implements TaskListener {
        int totalTaskCount;
        int finishedTaskCount = 0;
        private String[] mTargetNames;
        private Properties mProperties;

        public AntTaskListener(String[] stringArray, Properties properties) {
            this.mTargetNames = stringArray;
            this.mProperties = properties;
        }

        public void setTotalTasks(int n) {
            this.totalTaskCount = n;
        }

        public void taskFinished(Task task) {
            ++this.finishedTaskCount;
            if (this.finishedTaskCount == this.totalTaskCount) {
                BpelproActionProvider.this.runTask(this.mTargetNames, this.mProperties);
            }
        }
    }
}

