/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.api.ProjectUtil;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.CDataLoader;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.openide.loaders.ExtensionList;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemFactory {
    private FileSystemFactory() {
    }

    public static List<Set<String>> getUnusedFiles(String string, Set<String> set) {
        Set<String> set2 = FileSystemFactory.getSourceSuffixes();
        Set<String> set3 = FileSystemFactory.getHeaderSuffixes();
        HashSet<String> hashSet = new HashSet<String>();
        FileSystemFactory.gatherSubFolders(new File(string), hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        ArrayList<Set<String>> arrayList = new ArrayList<Set<String>>(2);
        arrayList.add(hashSet2);
        arrayList.add(hashSet3);
        Iterator<String> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next());
            if (!file.isDirectory()) continue;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                String string3;
                int n;
                if (!fileArray[i].isFile() || (n = (string3 = fileArray[i].getName()).lastIndexOf(46)) <= 0) continue;
                String string4 = string3.substring(n + 1);
                if (set2.contains(string4)) {
                    string2 = fileArray[i].getAbsolutePath();
                    if (Utilities.isWindows()) {
                        string2 = string2.replace('\\', '/');
                    }
                    if (set.contains(string2)) continue;
                    hashSet2.add(string2);
                    continue;
                }
                if (!set3.contains(string4)) continue;
                string2 = fileArray[i].getAbsolutePath();
                if (Utilities.isWindows()) {
                    string2 = string2.replace('\\', '/');
                }
                if (set.contains(string2)) continue;
                hashSet3.add(string2);
            }
        }
        return arrayList;
    }

    private static void gatherSubFolders(File file, HashSet<String> hashSet) {
        if (file.isDirectory()) {
            if (ProjectUtil.ignoreFolder(file)) {
                return;
            }
            String string = file.getAbsolutePath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    FileSystemFactory.gatherSubFolders(fileArray[i], hashSet);
                }
            }
        }
    }

    public static Set<String> createExtensionSet() {
        if (IpeUtils.isSystemCaseInsensitive()) {
            return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        return new TreeSet<String>();
    }

    public static Set<String> getSourceSuffixes() {
        Set<String> set = FileSystemFactory.createExtensionSet();
        FileSystemFactory.addSuffices(set, CCDataLoader.getInstance().getExtensions());
        FileSystemFactory.addSuffices(set, CDataLoader.getInstance().getExtensions());
        return set;
    }

    public static Set<String> getHeaderSuffixes() {
        Set<String> set = FileSystemFactory.createExtensionSet();
        FileSystemFactory.addSuffices(set, HDataLoader.getInstance().getExtensions());
        return set;
    }

    private static void addSuffices(Set<String> set, ExtensionList extensionList) {
        Enumeration enumeration = extensionList.extensions();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            set.add(string);
        }
    }
}

