/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.bridge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBridge {
    private String baseFolder;
    private MakeConfigurationDescriptor makeConfigurationDescriptor;
    private Project project;
    private Set<Project> resultSet = new HashSet<Project>();
    private Map<String, Item> canonicalItems;
    private static final String PATTERN_1 = File.separator + "." + File.separator;
    private static final String PATTERN_2 = File.separator + ".";
    private static final String PATTERN_3 = File.separator + ".." + File.separator;
    private static final String PATTERN_4 = File.separator + "..";
    private List<String> systemIncludePathsC;
    private List<String> systemIncludePathsCpp;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private Map<String, String> systemMacroDefinitionsC;
    private Map<String, String> systemMacroDefinitionsCpp;

    public ProjectBridge(Project project) {
        this.project = project;
        this.baseFolder = File.separator + project.getProjectDirectory().getPath();
        this.resultSet.add(project);
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        this.makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
    }

    public ProjectBridge(String string) throws IOException {
        this.baseFolder = string;
        MakeConfiguration makeConfiguration = new MakeConfiguration(string, "Default", 0);
        String string2 = string;
        String string3 = IpeUtils.toRelativePath((String)string, (String)FilePathAdaptor.naturalize((String)string2));
        string3 = FilePathAdaptor.normalize((String)string3);
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string3);
        this.project = ProjectGenerator.createBlankProject((String)"DiscoveryProject", (String)string, (MakeConfiguration[])new MakeConfiguration[]{makeConfiguration}, (boolean)true);
        this.resultSet.add(this.project);
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        this.makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
    }

    public Folder createFolder(Folder folder, String string) {
        return new Folder((ConfigurationDescriptor)this.makeConfigurationDescriptor, folder, string, string, true);
    }

    public Item createItem(String string) {
        return new Item(this.getRelativepath(string));
    }

    public Item getProjectItem(String string) {
        Item item = this.makeConfigurationDescriptor.findProjectItemByPath(string);
        if (item == null) {
            if (!IpeUtils.isPathAbsolute((String)string)) {
                string = IpeUtils.toAbsolutePath((String)this.baseFolder, (String)string);
            }
            item = this.findByCanonicalName(string);
        }
        return item;
    }

    private Item findByCanonicalName(String string) {
        if (this.canonicalItems == null) {
            this.canonicalItems = new HashMap<String, Item>();
            for (Item item : this.makeConfigurationDescriptor.getProjectItems()) {
                this.canonicalItems.put(item.getCanonicalFile().getAbsolutePath(), item);
            }
        }
        return this.canonicalItems.get(string);
    }

    public Object getAuxObject(Item item) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        return itemConfiguration;
    }

    public void setAuxObject(Item item, Object object) {
        if (object instanceof ItemConfiguration) {
            ItemConfiguration itemConfiguration = (ItemConfiguration)object;
            MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
            ItemConfiguration itemConfiguration2 = item.getItemConfiguration((Configuration)makeConfiguration);
            itemConfiguration2.setCCCompilerConfiguration(itemConfiguration.getCCCompilerConfiguration());
            itemConfiguration2.setCCompilerConfiguration(itemConfiguration.getCCompilerConfiguration());
            itemConfiguration2.setCustomToolConfiguration(itemConfiguration.getCustomToolConfiguration());
        }
    }

    public String getRelativepath(String string) {
        if (Utilities.isWindows()) {
            string = string.replace('/', File.separatorChar);
        }
        string = IpeUtils.toRelativePath((String)this.makeConfigurationDescriptor.getBaseDir(), (String)string);
        string = FilePathAdaptor.mapToRemote((String)string);
        string = this.cutLocalRelative(string);
        string = FilePathAdaptor.normalize((String)string);
        return string;
    }

    private String cutLocalRelative(String string) {
        int n;
        int n2;
        String string2 = PATTERN_1;
        while ((n2 = string.indexOf(string2)) >= 0) {
            string = string.substring(0, n2 + 1) + string.substring(n2 + string2.length());
        }
        string2 = PATTERN_2;
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        string2 = PATTERN_3;
        while ((n2 = string.indexOf(string2)) >= 0) {
            n = -1;
            for (int i = n2 - 1; i >= 0; --i) {
                if (string.charAt(i) != File.separatorChar) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            string = string.substring(0, n + 1) + string.substring(n2 + string2.length());
        }
        string2 = PATTERN_4;
        if (string.endsWith(string2)) {
            n2 = -1;
            for (n = string.length() - string2.length() - 1; n >= 0; --n) {
                if (string.charAt(n) != File.separatorChar) continue;
                n2 = n;
                break;
            }
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    public Item[] getAllSources() {
        return this.makeConfigurationDescriptor.getProjectItems();
    }

    public Folder getRoot() {
        Folder folder = this.makeConfigurationDescriptor.getLogicalFolders();
        Vector vector = folder.getFolders();
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        for (Object e : vector) {
            Folder folder2 = (Folder)e;
            if (!folder2.isProjectFiles() || !"SourceFiles".equals(folder2.getName())) continue;
            Vector vector2 = folder2.getFolders();
            for (Object e2 : vector2) {
                Folder folder3 = (Folder)e2;
                if (!folder3.isProjectFiles()) continue;
                arrayList.add(folder3);
            }
        }
        if (arrayList.size() > 0) {
            return (Folder)arrayList.get(0);
        }
        return folder;
    }

    public Set getResult() {
        this.makeConfigurationDescriptor.save();
        if (SwingUtilities.isEventDispatchThread()) {
            this.makeConfigurationDescriptor.checkForChangedItems(this.project, null, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectBridge.this.makeConfigurationDescriptor.checkForChangedItems(ProjectBridge.this.project, null, null);
                }
            });
        }
        return this.resultSet;
    }

    public void setupProject(List list, List list2, boolean bl) {
        Configuration configuration = this.makeConfigurationDescriptor.getConfs().getActive();
        if (configuration instanceof MakeConfiguration) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
            if (bl) {
                makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories().setValue(list);
                makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration().setValue(list2);
                makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
            } else {
                makeConfiguration.getCCompilerConfiguration().getIncludeDirectories().setValue(list);
                makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration().setValue(list2);
                makeConfiguration.getCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
            }
        }
        this.makeConfigurationDescriptor.setModified();
    }

    public void setupFolder(List list, boolean bl, List list2, boolean bl2, boolean bl3, Folder folder) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)folder.getConfigurationDescriptor().getConfs().getActive();
        FolderConfiguration folderConfiguration = folder.getFolderConfiguration((Configuration)makeConfiguration);
        if (folderConfiguration == null) {
            return;
        }
        if (bl3) {
            CCCompilerConfiguration cCCompilerConfiguration = folderConfiguration.getCCCompilerConfiguration();
            if (cCCompilerConfiguration != null) {
                cCCompilerConfiguration.getIncludeDirectories().setValue(list);
                cCCompilerConfiguration.getInheritIncludes().setValue(bl);
                cCCompilerConfiguration.getPreprocessorConfiguration().setValue(list2);
                cCCompilerConfiguration.getInheritPreprocessor().setValue(bl2);
            }
        } else {
            CCompilerConfiguration cCompilerConfiguration = folderConfiguration.getCCompilerConfiguration();
            if (cCompilerConfiguration != null) {
                cCompilerConfiguration.getIncludeDirectories().setValue(list);
                cCompilerConfiguration.getInheritIncludes().setValue(bl);
                cCompilerConfiguration.getPreprocessorConfiguration().setValue(list2);
                cCompilerConfiguration.getInheritPreprocessor().setValue(bl2);
            }
        }
    }

    public void setExclude(Item item, boolean bl) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
        if (booleanConfiguration.getValue() ^ bl) {
            booleanConfiguration.setValue(bl);
        }
    }

    public void setHeaderTool(Item item) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        if (itemConfiguration.getTool() == Tool.CCCompiler || itemConfiguration.getTool() == Tool.CCompiler) {
            itemConfiguration.setTool(Tool.CustomTool);
        }
    }

    public void setSourceTool(Item item, boolean bl) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        if (bl) {
            if (itemConfiguration.getTool() != Tool.CCCompiler) {
                itemConfiguration.setTool(Tool.CCCompiler);
            }
        } else if (itemConfiguration.getTool() != Tool.CCompiler) {
            itemConfiguration.setTool(Tool.CCompiler);
        }
    }

    public void setupFile(String string, List list, boolean bl, List list2, boolean bl2, Item item) {
        BasicCompilerConfiguration basicCompilerConfiguration;
        MakeConfiguration makeConfiguration = (MakeConfiguration)item.getFolder().getConfigurationDescriptor().getConfs().getActive();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return;
        }
        BooleanConfiguration booleanConfiguration = itemConfiguration.getExcluded();
        if (booleanConfiguration.getValue()) {
            booleanConfiguration.setValue(false);
        }
        if ((basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration()) instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            cCCCompilerConfiguration.getIncludeDirectories().setValue(list);
            cCCCompilerConfiguration.getInheritIncludes().setValue(bl);
            cCCCompilerConfiguration.getPreprocessorConfiguration().setValue(list2);
            cCCCompilerConfiguration.getInheritPreprocessor().setValue(bl2);
        }
    }

    private CompilerSet getCompilerSet() {
        MakeConfiguration makeConfiguration = (MakeConfiguration)this.makeConfigurationDescriptor.getConfs().getActive();
        return CompilerSetManager.getDefault().getCompilerSet(makeConfiguration.getCompilerSet().getValue());
    }

    public String getCompilerFlavor() {
        return this.getCompilerSet().getCompilerFlavor().toString();
    }

    public String getCompilerDirectory() {
        return this.getCompilerSet().getDirectory();
    }

    public List<String> getSystemIncludePaths(boolean bl) {
        List<String> list = bl ? this.systemIncludePathsCpp : this.systemIncludePathsC;
        if (list == null) {
            list = new ArrayList<String>();
            CompilerSet compilerSet = this.getCompilerSet();
            BasicCompiler basicCompiler = bl ? (BasicCompiler)compilerSet.getTool(Tool.CCCompiler) : (BasicCompiler)compilerSet.getTool(Tool.CCompiler);
            for (Object e : basicCompiler.getSystemIncludeDirectories()) {
                String string = (String)e;
                list.add(this.fixWindowsPath(string));
            }
            if (bl) {
                this.systemIncludePathsCpp = list;
            } else {
                this.systemIncludePathsC = list;
            }
        }
        return list;
    }

    private String fixWindowsPath(String string) {
        int n;
        if (Utilities.isWindows() && (n = (string = string.replace('\\', '/')).indexOf(CYG_DRIVE_UNIX)) >= 0 && string.length() > n + CYG_DRIVE_UNIX.length() + 1) {
            string = Character.toUpperCase(string.charAt(n + CYG_DRIVE_UNIX.length())) + ":" + string.substring(n + CYG_DRIVE_UNIX.length() + 1);
        }
        return string;
    }

    public Map<String, String> getSystemMacroDefinitions(boolean bl) {
        Map<String, String> map = bl ? this.systemMacroDefinitionsCpp : this.systemMacroDefinitionsC;
        if (map == null) {
            map = new HashMap<String, String>();
            CompilerSet compilerSet = this.getCompilerSet();
            BasicCompiler basicCompiler = bl ? (BasicCompiler)compilerSet.getTool(Tool.CCCompiler) : (BasicCompiler)compilerSet.getTool(Tool.CCompiler);
            for (Object e : basicCompiler.getSystemPreprocessorSymbols()) {
                String string = (String)e;
                int n = string.indexOf(61);
                if (n > 0) {
                    map.put(string.substring(0, n), string.substring(n + 1).trim());
                    continue;
                }
                map.put(string, null);
            }
            if (bl) {
                this.systemMacroDefinitionsCpp = map;
            } else {
                this.systemMacroDefinitionsC = map;
            }
        }
        return map;
    }
}

