/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class RangeConstraint
extends ConstraintUtils
implements Constraint {
    private Double startValue = null;
    private Double endValue = null;

    public RangeConstraint() {
        this.startValue = null;
        this.endValue = null;
    }

    public RangeConstraint(String string, String string2) {
        try {
            this.startValue = new Double(string);
            this.endValue = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = BundleReader.getValue("Error_failed_to_create");
            Object[] objectArray = new Object[]{"RangeConstaint"};
            System.out.println(MessageFormat.format(string3, objectArray));
        }
    }

    public Collection match(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (this.startValue == null || this.endValue == null) {
            return arrayList;
        }
        if (string != null && string.length() != 0) {
            try {
                Double d = new Double(string);
                if (d.compareTo(this.startValue) < 0 || d.compareTo(this.endValue) > 0) {
                    this.addFailure(arrayList, string2, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addFailure(arrayList, string2, string);
            }
        }
        return arrayList;
    }

    public void setRangeStart(String string) {
        try {
            this.startValue = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = BundleReader.getValue("Error_failed_to_set");
            Object[] objectArray = new Object[]{this.toString(), "Range Start"};
            System.out.println(MessageFormat.format(string2, objectArray));
        }
    }

    public void setRangeEnd(String string) {
        try {
            this.endValue = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = BundleReader.getValue("Error_failed_to_set");
            Object[] objectArray = new Object[]{this.toString(), "Range End"};
            System.out.println(MessageFormat.format(string2, objectArray));
        }
    }

    public void print() {
        super.print();
        String string = BundleReader.getValue("Name_Value_Pair_Format");
        Object[] objectArray = new Object[]{"Range Start", this.startValue};
        System.out.println(MessageFormat.format(string, objectArray));
        objectArray = new Object[]{"Range End", this.endValue};
        System.out.println(MessageFormat.format(string, objectArray));
    }

    public void setRangeStart(Double d) {
        this.startValue = d;
    }

    public void setRangeEnd(Double d) {
        this.endValue = d;
    }

    private void addFailure(Collection collection, String string, String string2) {
        String string3 = this.formatFailureMessage(this.toString(), string2, string);
        String string4 = BundleReader.getValue("MSG_RangeConstraint_Failure");
        String string5 = this.startValue + " - " + this.endValue;
        Object[] objectArray = new Object[]{string5};
        String string6 = MessageFormat.format(string4, objectArray);
        collection.add(new ConstraintFailure(this.toString(), string2, string, string3, string6));
    }
}

