/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.JavaMethod;
import org.netbeans.modules.j2ee.sun.dd.api.common.Message;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurity;
import org.netbeans.modules.j2ee.sun.dd.api.common.MethodParams;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.openide.util.NbBundle;

public class MessageEntry
extends GenericTableModel.TableEntry {
    public static final String OPERATION_ENTRY = "OperationName";
    public static final String METHOD_ENTRY = "MethodName";
    public static final Pattern methodSplitter = Pattern.compile("[\\s,\\(\\)\\[\\]]+");
    private boolean saveAsOperation;

    public MessageEntry(boolean bl) {
        super(null, "Message", NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle"), bl ? OPERATION_ENTRY : METHOD_ENTRY, true, true);
        this.saveAsOperation = bl;
    }

    public Object getEntry(CommonDDBean commonDDBean) {
        Object object = null;
        CommonDDBean[] commonDDBeanArray = (CommonDDBean[])commonDDBean.getValues(this.propertyName);
        if (commonDDBeanArray != null && commonDDBeanArray.length > 0 && commonDDBeanArray[0] != null) {
            if (this.saveAsOperation) {
                object = commonDDBeanArray[0].getValue(OPERATION_ENTRY);
            } else {
                object = this.methodToString((JavaMethod)commonDDBeanArray[0].getValue("JavaMethod"));
                if (!Utils.notEmpty((String)object)) {
                    object = commonDDBeanArray[0].getValue(OPERATION_ENTRY);
                }
            }
        }
        return object;
    }

    public void setEntry(CommonDDBean commonDDBean, Object object) {
        if (object instanceof String && ((String)object).length() == 0) {
            object = null;
        }
        Object[] objectArray = (CommonDDBean[])commonDDBean.getValues(this.propertyName);
        if (object != null) {
            if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
                MessageSecurity messageSecurity = (MessageSecurity)commonDDBean;
                objectArray = new Message[]{messageSecurity.newMessage()};
                commonDDBean.setValue(this.propertyName, objectArray);
            }
            if (this.saveAsOperation) {
                objectArray[0].setValue(OPERATION_ENTRY, object);
            } else {
                objectArray[0].setValue("JavaMethod", (Object)this.stringToMethod((Message)objectArray[0], object.toString()));
            }
        } else if (objectArray != null) {
            commonDDBean.setValue(this.propertyName, null);
        }
    }

    public Object getEntry(CommonDDBean commonDDBean, int n) {
        throw new UnsupportedOperationException();
    }

    public void setEntry(CommonDDBean commonDDBean, int n, Object object) {
        throw new UnsupportedOperationException();
    }

    private String methodToString(JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (javaMethod != null) {
            stringBuffer.append(javaMethod.getMethodName());
            MethodParams methodParams = javaMethod.getMethodParams();
            if (methodParams != null && methodParams.sizeMethodParam() > 0) {
                stringBuffer.append("(");
                String[] stringArray = methodParams.getMethodParam();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if (Utils.notEmpty(stringArray[i])) {
                        stringBuffer.append(stringArray[i]);
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    private JavaMethod stringToMethod(Message message, String string) {
        String[] stringArray;
        JavaMethod javaMethod = null;
        if (Utils.notEmpty(string) && (stringArray = methodSplitter.split(string)).length > 0) {
            javaMethod = message.newJavaMethod();
            javaMethod.setMethodName(stringArray[0]);
            if (stringArray.length > 1) {
                MethodParams methodParams = javaMethod.newMethodParams();
                for (int i = 1; i < stringArray.length; ++i) {
                    methodParams.addMethodParam(stringArray[i]);
                }
                javaMethod.setMethodParams(methodParams);
            }
        }
        return javaMethod;
    }
}

