/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.JavaMethod;
import org.netbeans.modules.j2ee.sun.dd.api.common.Message;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurity;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.AuthorizationEntry;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageEntry;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageSecurityEntryPanel;
import org.openide.util.NbBundle;

public class EditBinding
extends JPanel
implements TableModelListener {
    private final ResourceBundle webserviceBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
    private final Base theBean;
    private final ASDDVersion asVersion;
    private final String asCloneVersion;
    private final MessageSecurityBinding msBinding;
    private final boolean methodAsOperation;
    private Dimension initialPreferredSize;
    private GenericTableModel messageSecurityModel;
    private GenericTablePanel messageSecurityPanel;
    private MessageSecurity[] bindingData;
    private MessageSecurity[] newBindingData;
    private String providerId;
    private JLabel jLblAuthReq;
    private JLabel jLblAuthorizationLayer;
    private JLabel jLblProvIdReq;
    private JLabel jLblProviderId;
    private JTextField jTxtAuthorizationLayer;
    private JTextField jTxtProviderId;
    static GenericTableModel.ParentPropertyFactory messageSecurityFactory = new GenericTableModel.ParentPropertyFactory(){

        public CommonDDBean newParentProperty(ASDDVersion aSDDVersion) {
            return StorageBeanFactory.getStorageBeanFactory(aSDDVersion).createMessageSecurity();
        }
    };

    public EditBinding(Base base, MessageSecurityBinding messageSecurityBinding, boolean bl, ASDDVersion aSDDVersion, String string) {
        this.theBean = base;
        this.methodAsOperation = bl;
        this.asVersion = aSDDVersion;
        this.asCloneVersion = string;
        this.msBinding = messageSecurityBinding;
        this.providerId = this.msBinding.getProviderId();
        this.bindingData = this.expand(messageSecurityBinding.getMessageSecurity());
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    public String getProviderId() {
        return this.providerId;
    }

    private void initComponents() {
        this.jLblAuthReq = new JLabel();
        this.jLblAuthorizationLayer = new JLabel();
        this.jTxtAuthorizationLayer = new JTextField();
        this.jLblProvIdReq = new JLabel();
        this.jLblProviderId = new JLabel();
        this.jTxtProviderId = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLblAuthReq.setLabelFor(this.jTxtAuthorizationLayer);
        this.jLblAuthReq.setText("*");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblAuthReq, gridBagConstraints);
        this.jLblAuthorizationLayer.setLabelFor(this.jTxtAuthorizationLayer);
        this.jLblAuthorizationLayer.setText(this.webserviceBundle.getString("LBL_AuthorizationLayer_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblAuthorizationLayer, gridBagConstraints);
        this.jTxtAuthorizationLayer.setEditable(false);
        this.jTxtAuthorizationLayer.setText("SOAP");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtAuthorizationLayer, gridBagConstraints);
        this.jLblProvIdReq.setLabelFor(this.jTxtProviderId);
        this.jLblProvIdReq.setText("*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblProvIdReq, gridBagConstraints);
        this.jLblProviderId.setLabelFor(this.jTxtProviderId);
        this.jLblProviderId.setText(this.webserviceBundle.getString("LBL_Provider_Id_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblProviderId, gridBagConstraints);
        this.jTxtProviderId.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                EditBinding.this.jTxtProviderIdKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtProviderId, gridBagConstraints);
    }

    private void jTxtProviderIdKeyReleased(KeyEvent keyEvent) {
        this.providerId = this.jTxtProviderId.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.initialPreferredSize = this.getPreferredSize();
        ArrayList<GenericTableModel.TableEntry> arrayList = new ArrayList<GenericTableModel.TableEntry>(5);
        arrayList.add(new MessageEntry(this.methodAsOperation));
        arrayList.add(new AuthorizationEntry("RequestProtection", "AuthSource", "ReqAuthSource"));
        arrayList.add(new AuthorizationEntry("RequestProtection", "AuthRecipient", "ReqAuthRecipient"));
        arrayList.add(new AuthorizationEntry("ResponseProtection", "AuthSource", "RespAuthSource"));
        arrayList.add(new AuthorizationEntry("ResponseProtection", "AuthRecipient", "RespAuthRecipient"));
        this.messageSecurityModel = new GenericTableModel(messageSecurityFactory, arrayList);
        this.messageSecurityModel.addTableModelListener(this);
        this.messageSecurityPanel = new GenericTablePanel(this.messageSecurityModel, this.webserviceBundle, "MessageSecurity", MessageSecurityEntryPanel.class, "AS_CFG_WebServiceEndpointMessageSecurity", this.methodAsOperation);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.messageSecurityPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_EditBindings"));
        this.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_EditBindings"));
    }

    private void initFields() {
        this.messageSecurityPanel.setModel((CommonDDBean[])this.bindingData, this.asVersion);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtProviderId.setText(this.providerId);
    }

    Collection getErrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getProviderId();
        if (!Utils.notEmpty(string)) {
            arrayList.add(this.webserviceBundle.getString("ERR_BlankProviderId"));
        }
        if (this.newBindingData == null || this.newBindingData.length == 0) {
            arrayList.add(this.webserviceBundle.getString("ERR_NoSecurityBindings"));
        }
        if (this.newBindingData != null && this.newBindingData.length > 1 && this.hasStarBinding()) {
            arrayList.add(this.webserviceBundle.getString("ERR_StarBindingConflict"));
        }
        return arrayList;
    }

    private boolean hasStarBinding() {
        boolean bl = false;
        for (int i = 0; i < this.newBindingData.length; ++i) {
            Message[] messageArray;
            String string = null;
            if (this.newBindingData[i] != null && (messageArray = this.newBindingData[i].getMessage()) != null && messageArray.length > 0 && messageArray[0] != null) {
                string = EditBinding.getMethodName(messageArray[0]);
            }
            if (!"*".equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.newBindingData = this.messageSecurityModel.getData().toArray(new MessageSecurity[0]);
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void commit() {
        MessageSecurityBinding messageSecurityBinding = (MessageSecurityBinding)this.msBinding.clone();
        this.msBinding.setAuthLayer("SOAP");
        String string = this.getProviderId();
        this.msBinding.setProviderId(string);
        this.newBindingData = this.compress(this.newBindingData);
        this.msBinding.setMessageSecurity(this.newBindingData);
        this.theBean.firePropertyChange("endpointSecurityBinding", messageSecurityBinding, this.msBinding);
    }

    private MessageSecurity[] expand(MessageSecurity[] messageSecurityArray) {
        MessageSecurity[] messageSecurityArray2 = new MessageSecurity[]{};
        if (messageSecurityArray != null && messageSecurityArray.length > 0) {
            ArrayList<MessageSecurity> arrayList = new ArrayList<MessageSecurity>(messageSecurityArray.length * 10);
            for (int i = 0; i < messageSecurityArray.length; ++i) {
                MessageSecurity messageSecurity = messageSecurityArray[i];
                Message[] messageArray = messageSecurity.getMessage();
                if (messageArray == null || messageArray.length <= 0) continue;
                if (messageArray.length == 1) {
                    arrayList.add(messageSecurity);
                    continue;
                }
                for (int j = 0; j < messageArray.length; ++j) {
                    MessageSecurity messageSecurity2 = (MessageSecurity)messageSecurity.cloneVersion(this.asCloneVersion);
                    Message message = messageSecurity2.getMessage(j);
                    messageSecurity2.setMessage(new Message[]{message});
                    arrayList.add(messageSecurity2);
                }
            }
            messageSecurityArray2 = arrayList.toArray(messageSecurityArray2);
        }
        return messageSecurityArray2;
    }

    private MessageSecurity[] compress(MessageSecurity[] messageSecurityArray) {
        MessageSecurity[] messageSecurityArray2 = null;
        if (messageSecurityArray != null && messageSecurityArray.length > 0) {
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>(messageSecurityArray.length);
            Arrays.sort(messageSecurityArray, new MessageSecurityComparator(true));
            MessageSecurityComparator messageSecurityComparator = new MessageSecurityComparator(false);
            for (int i = 0; i < messageSecurityArray.length; i += n) {
                int n2;
                for (n2 = i + 1; n2 < messageSecurityArray.length && messageSecurityComparator.compare(messageSecurityArray[i], messageSecurityArray[n2]) == 0; ++n2) {
                }
                n = n2 - i;
                assert (n > 0);
                if (n == 1) {
                    arrayList.add(messageSecurityArray[i].clone());
                    continue;
                }
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                for (int j = i; j < n2; ++j) {
                    Message[] messageArray = messageSecurityArray[j].getMessage();
                    if (messageArray == null || messageArray.length <= 0) continue;
                    arrayList2.add(messageArray[0].clone());
                }
                Message[] messageArray = arrayList2.toArray(new Message[0]);
                messageSecurityArray[i].setMessage(messageArray);
                arrayList.add(messageSecurityArray[i].clone());
            }
            messageSecurityArray2 = arrayList.toArray(new MessageSecurity[0]);
        }
        return messageSecurityArray2;
    }

    private static String getMethodName(Message message) {
        JavaMethod javaMethod;
        String string = message.getOperationName();
        if (string == null && (javaMethod = message.getJavaMethod()) != null) {
            string = javaMethod.getMethodName();
        }
        return string;
    }

    static void editMessageSecurityBinding(JPanel jPanel, Base base, boolean bl, MessageSecurityBinding messageSecurityBinding, ASDDVersion aSDDVersion, String string) {
        EditBinding editBinding = new EditBinding(base, messageSecurityBinding, bl, aSDDVersion, string);
        editBinding.displayDialog(jPanel, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle").getString("TITLE_EditBindings"), "AS_CFG_WebServiceEndpointSecurity");
    }

    private void displayDialog(JPanel jPanel, String string, String string2) {
        BetterInputDialog betterInputDialog = new BetterInputDialog(jPanel, string, string2, this);
        do {
            int n = betterInputDialog.display();
            if (n == 0) break;
            if (n != 1) continue;
            Collection collection = this.getErrors();
            if (betterInputDialog.hasErrors()) {
                betterInputDialog.showErrors();
                continue;
            }
            this.commit();
        } while (betterInputDialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final EditBinding dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel jPanel, String string, String string2, EditBinding editBinding) {
            super(jPanel, string);
            this.dialogPanel = editBinding;
            this.panelHelpId = string2;
            this.dialogPanel.setPreferredSize(new Dimension(jPanel.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)editBinding, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(jPanel);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.dialogPanel.getErrors());
            this.setErrors(arrayList);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }

    private static class MessageSecurityComparator
    implements Comparator {
        private boolean sortNames;

        public MessageSecurityComparator(boolean bl) {
            this.sortNames = bl;
        }

        public int compare(Object object, Object object2) {
            MessageSecurity messageSecurity = (MessageSecurity)object;
            MessageSecurity messageSecurity2 = (MessageSecurity)object2;
            int n = Utils.strCompareTo(messageSecurity.getRequestProtectionAuthSource(), messageSecurity2.getRequestProtectionAuthSource());
            if (n != 0) {
                return n;
            }
            n = Utils.strCompareTo(messageSecurity.getRequestProtectionAuthRecipient(), messageSecurity2.getRequestProtectionAuthRecipient());
            if (n != 0) {
                return n;
            }
            n = Utils.strCompareTo(messageSecurity.getResponseProtectionAuthSource(), messageSecurity2.getResponseProtectionAuthSource());
            if (n != 0) {
                return n;
            }
            n = Utils.strCompareTo(messageSecurity.getResponseProtectionAuthRecipient(), messageSecurity2.getResponseProtectionAuthRecipient());
            if (n != 0) {
                return n;
            }
            if (this.sortNames) {
                Message[] messageArray = messageSecurity.getMessage();
                Message[] messageArray2 = messageSecurity2.getMessage();
                assert (messageArray.length == 1);
                assert (messageArray2.length == 1);
                n = Utils.strCompareTo(EditBinding.getMethodName(messageArray[0]), EditBinding.getMethodName(messageArray2[0]));
            }
            return n;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return 17 + 30 * (this.sortNames ? 1 : 0);
        }
    }
}

